/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.StatusReport;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStatusReport
implements StatusReport,
Serializable {
    private static final long serialVersionUID = 31678516957423590L;
    protected static final TraceComponent tc = Tr.register((String)AbstractStatusReport.class.getName(), null, null);
    protected int type = -1;
    protected String cell = null;
    protected List nodes = new LinkedList();
    protected Map servers = new HashMap();
    protected Date timestamp = new Date();
    protected Map total_app_state = new HashMap();
    protected String _server;
    protected Set _back_level_nodes = new HashSet();
    protected Set _back_level_apps = new HashSet();
    protected Map _server_types = new HashMap();
    private static ManagedObjectMetadataHelper metaObjectHelper = null;
    protected transient Map deployments;
    protected transient Map cluster_xml;

    public Date getTimeStamp() {
        return this.timestamp;
    }

    public void setServer(String string) {
        this._server = string;
    }

    public String getServer() {
        return this._server;
    }

    public void setDeployments(Map map) {
        this.deployments = map;
    }

    public Map getDeployments() {
        return this.deployments;
    }

    public void setClusterInfo(Map map) {
        this.cluster_xml = map;
    }

    public Map getClusterInfo() {
        return this.cluster_xml;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String string) {
        this.cell = string;
    }

    public String getApplicationState(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationState", (Object)string);
        }
        Tr.debug((TraceComponent)tc, (String)"Back level apps: ", (Object)this._back_level_apps);
        boolean bl = this._back_level_apps.contains(string);
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"App is on Backlevel Node");
            }
            string2 = this.getAppState(string);
        } else {
            string2 = (String)this.total_app_state.get(string);
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("State was NULL for app: " + string));
                }
                string2 = "ExecutionState.UNAVAILABLE";
            }
            if (EditionHelper.isEditionSupportEnabled() && string2.equalsIgnoreCase("ExecutionState.STOPPED")) {
                try {
                    String string3 = EditionHelper.getEditionState(string);
                    if (string3.equalsIgnoreCase("INACTIVE")) {
                        string2 = "ExecutionState.UNAVAILABLE";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationState", (Object)string2);
        }
        return string2;
    }

    public void generate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generate");
        }
        if (metaObjectHelper == null) {
            try {
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                metaObjectHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.status.AbstractStatusReport.generate", (String)"150", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"generate Exception", (Object)exception);
                }
                metaObjectHelper = null;
            }
        }
        this.generateAppState();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generate");
        }
    }

    public void generateAppState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationState");
        }
        HashSet hashSet = new HashSet(this.deployments.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getAppState(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("App Name: " + string));
                Tr.debug((TraceComponent)tc, (String)("App State: " + string2));
            }
            this.total_app_state.put(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateAppState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getServerType(String string, String string2) {
        boolean bl;
        String string3;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"_getServerType", (Object)new Object[]{string, string2});
            }
            string3 = "";
            bl = true;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"metaObjectHelper", (Object)metaObjectHelper);
                }
                if (metaObjectHelper != null && metaObjectHelper.isNodeZOS(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"isNodeZOS", (Object)string);
                    }
                    String string4 = metaObjectHelper.getNodeMajorVersion(string);
                    int n = Integer.parseInt(string4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("version " + n));
                    }
                    if (n < 6) {
                        string3 = "APPLICATION_SERVER";
                        bl = false;
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.status.AbstractStatusReport._getServerType", (String)"200", (Object)this);
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug((TraceComponent)tc, (String)"Exception caught - 1 ", (Object)exception);
            }
        }
        if (bl) {
            try {
                string3 = this.getServerType(string, string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught - 2", (Object)exception);
                }
                string3 = "APPLICATION_SERVER";
            }
            finally {
                if (string3 == null) {
                    string3 = "";
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"_getServerType", (Object)new Object[]{string3});
        }
        return string3;
    }

    public String getAppState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAppState - " + string));
        }
        Deployment deployment = (Deployment)this.deployments.get(string);
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        Iterator iterator = deployment.getDeploymentTargets().iterator();
        String string2 = "";
        if (!iterator.hasNext()) {
            string2 = "ExecutionState.UNAVAILABLE";
        } else {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (iterator.hasNext()) {
                try {
                    String string3;
                    Object object;
                    ServerTarget serverTarget;
                    DeploymentTarget deploymentTarget = (DeploymentTarget)iterator.next();
                    if (deploymentTarget instanceof ClusteredTarget) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Cluster Target - " + deploymentTarget.getName()));
                        }
                        serverTarget = (ServerCluster)this.cluster_xml.get(deploymentTarget.getName());
                        object = serverTarget.getMembers().iterator();
                        while (object.hasNext()) {
                            string3 = (ClusterMember)object.next();
                            String string4 = string3.getNodeName();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"BackLevel", (Object)new Object[]{string4, this._back_level_nodes});
                            }
                            if (this._back_level_nodes.contains(string4)) {
                                this._back_level_apps.add(string);
                            }
                            String string5 = this._getServerType(string3.getNodeName(), string3.getMemberName());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Server Type - " + string5));
                            }
                            if ("BACK_LEVEL".equals(string5)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"BackLevel Node, increasing target");
                                }
                                ++n;
                            } else {
                                if (!string5.equals("APPLICATION_SERVER") && !string5.equals("DEPLOYMENT_MANAGER") && !string5.equals("PROXY_SERVER") && !string5.equals("ONDEMAND_ROUTER") && !string5.equals("NODE_AGENT")) continue;
                                ++n;
                            }
                            if (!this.getServerState(string3.getNodeName(), string3.getMemberName()).equals("ExecutionState.STARTED")) continue;
                            if (this.getApplicationState(string, string3.getNodeName(), string3.getMemberName()).equals("ExecutionState.STARTED")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Application Started - " + string));
                                }
                                ++n2;
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Application Stopped - " + string));
                            }
                            ++n3;
                        }
                        continue;
                    }
                    serverTarget = (ServerTarget)deploymentTarget;
                    object = serverTarget.getNodeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"BackLevel", (Object)new Object[]{object, this._back_level_nodes});
                    }
                    if (this._back_level_nodes.contains(object)) {
                        this._back_level_apps.add(string);
                    }
                    string3 = this._getServerType((String)object, serverTarget.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Server Type - " + string3));
                    }
                    if ("BACK_LEVEL".equals(string3)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"BackLevel Node, increasing target");
                        }
                        ++n;
                    } else {
                        if (!string3.equals("APPLICATION_SERVER") && !string3.equals("DEPLOYMENT_MANAGER") && !string3.equals("PROXY_SERVER") && !string3.equals("ONDEMAND_ROUTER") && !string3.equals("NODE_AGENT")) continue;
                        ++n;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Server Target - " + serverTarget.getName()));
                    }
                    if (!this.getServerState(serverTarget.getNodeName(), deploymentTarget.getName()).equals("ExecutionState.STARTED")) continue;
                    Tr.debug((TraceComponent)tc, (String)("Server is Started: " + deploymentTarget.getName()));
                    if (this.getApplicationState(string, serverTarget.getNodeName(), deploymentTarget.getName()).equals("ExecutionState.STARTED")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Application Started - " + string));
                        }
                        ++n2;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Application Stopped - " + string));
                    }
                    ++n3;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.status.AbstractStatusReport.getAppState", (String)"336", (Object)this);
                    Tr.debug((TraceComponent)tc, (String)"Failed to load cluster context while determining application status: {0}", (Object)exception);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Server Target Count: " + n));
                Tr.debug((TraceComponent)tc, (String)("Application Started Count: " + n2));
                Tr.debug((TraceComponent)tc, (String)("Application Stopped Count: " + n3));
            }
            string2 = n == 0 ? "ExecutionState.UNAVAILABLE" : (n == n2 ? "ExecutionState.STARTED" : (n2 == 0 ? (n3 == 0 ? "ExecutionState.UNAVAILABLE" : "ExecutionState.STOPPED") : "ExecutionState.PARTIAL_START"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAppState - " + string2));
        }
        return string2;
    }

    public abstract String[] getNodes();

    public abstract String[] getServers(String var1);

    public abstract String getApplicationState(String var1, String var2, String var3);

    public abstract String getServerState(String var1, String var2);

    public abstract String getServerType(String var1, String var2);

    public abstract String getNodeState(String var1);

    public abstract String getMessageListenerState(String var1, String var2, String var3);
}

