/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManager;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class ManagedObjectMetadataCollectorManagerFactory {
    private static TraceComponent _tc = Tr.register((Class)ManagedObjectMetadataCollectorManagerFactory.class, (String)"Admin", null);
    private static final String COLLECTOR_IMPL_CLASS_NAME = "com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerImpl";

    public static ManagedObjectMetadataCollectorManager createCollectorManager(Properties properties, AdminClient adminClient) throws AdminException {
        return ManagedObjectMetadataCollectorManagerFactory.createCollectorManagerInstance(properties, adminClient);
    }

    public static ManagedObjectMetadataCollectorManager createCollectorManager(Properties properties) throws AdminException {
        return ManagedObjectMetadataCollectorManagerFactory.createCollectorManagerInstance(properties, null);
    }

    private static ManagedObjectMetadataCollectorManager createCollectorManagerInstance(Properties properties, AdminClient adminClient) throws AdminException {
        properties = ManagedObjectMetadataCollectorManagerFactory.validateProperties(properties);
        try {
            Class<?> clazz = Class.forName(COLLECTOR_IMPL_CLASS_NAME);
            Constructor<?> constructor = clazz.getConstructor(Properties.class, AdminClient.class);
            ManagedObjectMetadataCollectorManager managedObjectMetadataCollectorManager = (ManagedObjectMetadataCollectorManager)constructor.newInstance(properties, adminClient);
            return managedObjectMetadataCollectorManager;
        }
        catch (Exception exception) {
            throw new AdminException(exception, "Encountered an error while attempting to create a ManagedObjectMetadataCollector instance.");
        }
    }

    private static Properties validateProperties(Properties properties) throws AdminException {
        IllegalArgumentException illegalArgumentException = null;
        properties = properties == null ? new Properties() : (Properties)properties.clone();
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = properties.getProperty("was.repository.root");
        if (string == null || string.length() == 0) {
            string = System.getProperty("was.repository.root");
            if (string == null || string.length() == 0) {
                if (adminService == null) {
                    illegalArgumentException = new IllegalArgumentException("The property \"was.repository.root\" setting does not exist in the set of input properties or system properties or has a zero-length value.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("validateProperties: Using repository root from sys props: " + string));
                }
                properties.setProperty("was.repository.root", string);
            }
        }
        if ((string = properties.getProperty("local.cell")) == null || string.length() == 0) {
            string = System.getProperty("local.cell");
            if (string == null || string.length() == 0) {
                if (adminService != null) {
                    string = adminService.getCellName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Using cell name from AdminService: " + string));
                    }
                    properties.setProperty("local.cell", string);
                } else {
                    illegalArgumentException = new IllegalArgumentException("The property \"local.cell\" setting does not exist in the set of input properties and a value for \"local.cell\" could not be found in the system properties.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Using cell name from sys props: " + string));
                }
                properties.setProperty("local.cell", string);
            }
        }
        if ((string = properties.getProperty("local.node")) == null || string.length() == 0) {
            string = System.getProperty("local.node");
            if (string == null || string.length() == 0) {
                if (adminService != null) {
                    string = adminService.getNodeName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)("Using node name from AdminService: " + string));
                    }
                    properties.setProperty("local.node", string);
                } else {
                    illegalArgumentException = new IllegalArgumentException("The property \"local.node\" setting does not exist in the set of input properties and a value for \"local.node\" could not be found in the system properties.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Using cell name from sys props: " + string));
                }
                properties.setProperty("local.node", string);
            }
        }
        if ((string = properties.getProperty("was.install.root")) == null || string.length() == 0) {
            string = System.getProperty("was.install.root");
            if (string == null || string.length() == 0) {
                illegalArgumentException = new IllegalArgumentException("The property \"was.install.root\" setting does not exist in the set of input properties and a value for \"was.install.root\" could not be found in the system properties.");
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Using was.install.root from sys props: " + string));
                }
                properties.setProperty("was.install.root", string);
            }
        }
        if (illegalArgumentException != null) {
            throw new AdminException(illegalArgumentException, "Invalid input.  See nested exception for more information.");
        }
        return properties;
    }
}

