/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.j2ee;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ObjectNotRunningException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class J2EEManagedObjectProxy
extends J2EEManagedObjectCollaborator {
    private String deploymentDescriptor;
    private String fullServerName;

    public J2EEManagedObjectProxy(String string) {
        this.deploymentDescriptor = string;
    }

    public String getServer() {
        if (this.fullServerName == null) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("WebSphere:*,j2eeType=J2EEServer," + this.getStandardKeyProperties());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (!set.isEmpty()) {
                this.fullServerName = set.iterator().next().toString();
            }
        }
        return this.fullServerName;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getName() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        ObjectName objectName = this.getWebSphereMBeanObjectName();
        if (objectName == null) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(objectName, "name");
    }

    public String getJavaVendor() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        ObjectName objectName = this.getWebSphereMBeanObjectName();
        if (objectName == null) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(objectName, "javaVendor");
    }

    public String getJavaVersion() throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, ObjectNotRunningException {
        ObjectName objectName = this.getWebSphereMBeanObjectName();
        if (objectName == null) {
            throw new ObjectNotRunningException();
        }
        return (String)AdminServiceFactory.getAdminService().getAttribute(objectName, "javaVersion");
    }

    protected String getJ2EEName() {
        return this.getObjectName().getKeyProperty("name");
    }

    protected String getJ2EEType() {
        return this.getObjectName().getKeyProperty("j2eeType");
    }

    protected abstract String getWebSphereMBeanKeyProperties();

    protected ObjectName getPartialWebSphereMBeanObjectName() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*," + this.getWebSphereMBeanKeyProperties());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.j2ee.J2EEManagedObjectProxy.getPartialWebSphereMBeanObjectName", (String)"112", (Object)this);
        }
        return objectName;
    }

    protected ObjectName getWebSphereMBeanObjectName() {
        Set set = AdminServiceFactory.getAdminService().queryNames(this.getPartialWebSphereMBeanObjectName(), null);
        if (!set.isEmpty()) {
            return (ObjectName)set.iterator().next();
        }
        return null;
    }

    protected String getStandardKeyProperties() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("cell=");
        stringBuffer.append(adminService.getCellName());
        stringBuffer.append(",node=");
        stringBuffer.append(adminService.getNodeName());
        stringBuffer.append(",process=");
        stringBuffer.append(adminService.getProcessName());
        return stringBuffer.toString();
    }
}

