/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.ClientAdminCommand;
import com.ibm.ws.management.cmdframework.impl.ClientTaskCommand;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandMgrImpl;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.management.MBeanException;

public class ClientCommandMgr
extends CommandMgrImpl {
    private static TraceComponent tc = Tr.register((Class)ClientCommandMgr.class, (String)"ClientCommandMgr", (String)"com.ibm.ws.management.cmdframework.impl");
    private AdminClient adminClient;
    public static HashMap cmdMetadataMap = new HashMap();

    public ClientCommandMgr() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Init client command manager");
        }
        cmdMgr = this;
        this.helper = new CommandProviderHelper(){

            public ConfigService getConfigService() {
                return ConfigServiceFactory.getConfigService();
            }

            public AdminClient getAdminClient() {
                return ClientCommandMgr.this.adminClient;
            }

            public AdminService getAdminService() {
                return null;
            }

            public AppManagement getAppManagement() {
                AppManagement appManagement = null;
                try {
                    appManagement = AppManagementProxy.getJMXProxyForServer();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getAppManagement", (String)"59", (Object)this);
                    exception.printStackTrace();
                }
                return appManagement;
            }
        };
    }

    public CommandProviderHelper getCommandProviderHelper() {
        return this.helper;
    }

    public void setAdminClient(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public Collection listCommandGroups() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommandGroups", null, null);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)((Object)exception);
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public Collection listCommands(String string) throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommands", new Object[]{string}, new String[]{"java.lang.String"});
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)((Object)exception);
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public Collection listCommands() throws ConnectorException, CommandException {
        try {
            return (Collection)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "listCommands", null, null);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)((Object)exception);
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public CommandGroupMetadata getCommandGroupMetadata(String string) throws ConnectorException, CommandException {
        try {
            EObjectSerializer eObjectSerializer = (EObjectSerializer)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCommandGroupMetaInfo", new Object[]{string, Locale.getDefault()}, new String[]{"java.lang.String", "java.util.Locale"});
            return (CommandGroupMetadata)eObjectSerializer.getEObjectValue();
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof CommandException) {
                throw (CommandException)((Object)exception);
            }
            throw new CommandException(exception);
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (Exception exception) {
            throw new CommandException(exception);
        }
    }

    public CommandMetadata getCommandMetadata(String string) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCommandMetadata", (Object)string);
        }
        if ((commandMetadata = (CommandMetadata)cmdMetadataMap.get(string)) == null) {
            commandMetadata = this.initCommandMetadata(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCommandMetadata", (Object)commandMetadata);
        }
        return commandMetadata;
    }

    public AdminCommand createCommand(String string) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCommand", (Object)string);
        }
        if ((commandMetadata = (CommandMetadata)cmdMetadataMap.get(string)) == null) {
            commandMetadata = this.initCommandMetadata(string);
        }
        if (commandMetadata instanceof TaskCommandMetadata) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createCommand", (Object)"Creating Task Command");
            }
            return new ClientTaskCommand((TaskCommandMetadata)commandMetadata);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCommand", (Object)"Creating Command");
        }
        return new ClientAdminCommand(commandMetadata);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandMetadata initCommandMetadata(String string) throws ConnectorException, CommandException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initCommandMetadata", (Object)string);
        }
        try {
            try {
                String string2;
                CommandMetadata commandMetadata;
                block14: {
                    EObjectSerializer eObjectSerializer = (EObjectSerializer)this.adminClient.invoke(CommandUtility.getRemoteCmdMgrMbean(this.adminClient), "getCommandMetaInfo", new Object[]{string, Locale.getDefault()}, new String[]{"java.lang.String", "java.util.Locale"});
                    commandMetadata = (CommandMetadata)eObjectSerializer.getEObjectValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Command MetaData received is " + commandMetadata));
                    }
                    string2 = commandMetadata.getName();
                    try {
                        CommandMetadataMgr.getInstance().getCommandMetadata(string2);
                    }
                    catch (CommandNotFoundException commandNotFoundException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Command " + string2 + " does not exist locally. Process to add..."));
                        }
                        ArrayList<CommandMetadata> arrayList = new ArrayList<CommandMetadata>(0);
                        arrayList.add(commandMetadata);
                        CommandMetadataMgr.getInstance().registerCommandMetadataRemote(arrayList);
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)("Command " + string2 + " added to local CommandMetadataMgr"));
                    }
                }
                CommandMetadataMgr.getInstance().createParamDataEObject(string2);
                if (commandMetadata instanceof TaskCommandMetadata) {
                    object = ((TaskCommandMetadata)commandMetadata).getSteps();
                    for (int i = 0; i < object.size(); ++i) {
                        String string3 = ((CommandStepMetadata)object.get(i)).getName();
                        CommandMetadataMgr.getInstance().createParamDataEObject(string2, string3);
                    }
                }
                cmdMetadataMap.put(string, commandMetadata);
                object = commandMetadata;
                Object var9_14 = null;
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (!(exception instanceof CommandException)) throw new CommandException(exception);
                throw (CommandException)((Object)exception);
            }
            catch (ConnectorException connectorException) {
                throw connectorException;
            }
            catch (Exception exception) {
                throw new CommandException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"initCommandMetadata");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return object;
        Tr.exit((TraceComponent)tc, (String)"initCommandMetadata");
        return object;
    }
}

