/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class J2CAppUtils {
    private static TraceComponent tc = Tr.register((Class)J2CAppUtils.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String MESSAGE_BUNDLE = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.adminservice");
    private static HashMap pType = null;

    public static List getAppRefs(String string) throws AdminException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAppRefs( " + string + ")"));
        }
        Session session = new Session();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        if (configService == null) {
            object4 = new Properties();
            ((Properties)object4).setProperty("location", "local");
            configService = ConfigServiceFactory.createConfigService(true, (Properties)object4);
        }
        if (configService == null) {
            object4 = "No config service is available.";
            throw new AdminException((String)object4);
        }
        object4 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            object3 = null;
            String string5 = null;
            int n = string.lastIndexOf("(");
            int n2 = string.lastIndexOf(")");
            n2 = n2 == -1 ? string.length() : string.length() - 1;
            string5 = string.substring(n + 1, n2);
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getAppRefs( " + string + ", " + configService + ")"));
            }
            if (n > 0) {
                object3 = string.substring(0, n);
            }
            hashtable.put("_Websphere_Config_Data_Id", string5);
            if (object3 != null) {
                hashtable.put("_Websphere_Config_Data_Display_Name", (String)object3);
            }
        }
        if (hashtable.size() > 0) {
            try {
                object4 = new ObjectName("WebSphere", hashtable);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"95");
                throw new AdminException(malformedObjectNameException);
            }
        }
        object3 = ConfigServiceHelper.getObjectLocation((ObjectName)object4);
        int n = string.indexOf("cells/");
        int n3 = string.indexOf(47, n + 6);
        string2 = string.substring(n + 6, n3);
        n = string.indexOf("nodes/", n3);
        if (n != -1) {
            n3 = string.indexOf(47, n + 6);
            string3 = string.substring(n + 6, n3);
        }
        if ((n = string.indexOf("servers/", n3)) != -1) {
            n3 = string.indexOf(47, n + 8);
            string4 = string.substring(n + 8, n3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell= " + string2 + " node= " + string3 + " server= " + string4));
        }
        if (string3 == null || string3.equals("")) {
            string3 = AdminServiceFactory.getAdminService().getNodeName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Node = " + string3));
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string6 = null;
        ObjectName[] objectNameArray = null;
        List list = null;
        List list2 = null;
        try {
            objectNameArray = configService.getRelationship(session, (ObjectName)object4, "J2CConnectionFactory");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"102");
            throw new AdminException(exception);
        }
        AttributeList attributeList = null;
        try {
            attributeList = configService.getAttributes(session, (ObjectName)object4, new String[]{"j2cAdminObjects"}, false);
            list = (List)ConfigServiceHelper.getAttributeValue(attributeList, "j2cAdminObjects");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"121");
            throw new AdminException(exception);
        }
        try {
            attributeList = configService.getAttributes(session, (ObjectName)object4, new String[]{"j2cActivationSpec"}, false);
            list2 = (List)ConfigServiceHelper.getAttributeValue(attributeList, "j2cActivationSpec");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"157");
            throw new AdminException(exception);
        }
        try {
            int n4;
            if (objectNameArray != null) {
                for (n4 = 0; n4 < objectNameArray.length; ++n4) {
                    object2 = objectNameArray[n4];
                    string6 = (String)configService.getAttribute(session, (ObjectName)object2, "jndiName");
                    arrayList.add(string6);
                }
            }
            if (list2 != null) {
                for (n4 = 0; n4 < list2.size(); ++n4) {
                    object2 = (ObjectName)list2.get(n4);
                    string6 = (String)configService.getAttribute(session, (ObjectName)object2, "jndiName");
                    arrayList.add(string6);
                }
            }
            if (list != null) {
                for (n4 = 0; n4 < list.size(); ++n4) {
                    object2 = (ObjectName)list.get(n4);
                    string6 = (String)configService.getAttribute(session, (ObjectName)object2, "jndiName");
                    arrayList.add(string6);
                }
            }
        }
        catch (ConfigServiceException configServiceException) {
            FFDCFilter.processException((Throwable)((Object)configServiceException), (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"198");
            throw new AdminException((Throwable)((Object)configServiceException));
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)((Object)connectorException), (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"201");
            throw new AdminException((Throwable)((Object)connectorException));
        }
        Hashtable hashtable2 = new Hashtable(5);
        object2 = "WebSphere:cell=" + string2 + ",node=" + string3;
        if (string4 != null && string4.equals("")) {
            object2 = (String)object2 + ",server=" + string4;
        }
        try {
            object = AppManagementProxy.getLocalProxy();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("nodes " + (String)object2));
            }
            hashtable2 = object.searchJNDIReferences(arrayList, (String)object2, null, session.toString());
            configService.discard(session);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"275");
            throw new AdminException(exception);
        }
        object = null;
        if (hashtable2 != null) {
            object = new ArrayList(hashtable2.size());
            Set set = hashtable2.keySet();
            Object[] objectArray = set.toArray();
            for (int i = 0; i < hashtable2.size(); ++i) {
                object.add((String)objectArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("AppRefs() returns " + object));
        }
        return object;
    }

    public static Class getDefinedClass(String string, ClassLoader classLoader) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("loadBeanPropertyWithType: " + string));
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"ADMN0045E");
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"308");
            Tr.error((TraceComponent)tc, (String)"ADMN0050E", (Object)new Object[]{string, classNotFoundException});
            throw new AdminException(classNotFoundException, J2CAppUtils.getFormattedMessage("ADMN0050E", new Object[]{string, classNotFoundException}, "Failed introspection: Class " + string + "was not find."));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"315");
            Tr.error((TraceComponent)tc, (String)"ADMN0051E", (Object)new Object[]{string, exception});
            throw new AdminException(exception, J2CAppUtils.getFormattedMessage("ADMN0051E", new Object[]{string, exception}, "Failed to introspect the class:" + string + " with unknown exception."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadBeanProperty returns " + clazz));
        }
        return clazz;
    }

    public static List getActivationSpecProps(Class clazz, ResourcesFactory resourcesFactory, String string) throws AdminException {
        List list = null;
        list = J2CAppUtils.getDefinedProperties(clazz, resourcesFactory, string, "J2CActivationSpec");
        return list;
    }

    public static List getDefinedProperties(Class clazz, ResourcesFactory resourcesFactory, String string, String string2) throws AdminException {
        ArrayList<J2EEResourceProperty> arrayList;
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("loadBeanPropertyWithType: " + string2));
            }
            if (clazz == null) {
                Tr.error((TraceComponent)tc, (String)"ADMN0045E");
                return null;
            }
            arrayList = new ArrayList<J2EEResourceProperty>(10);
            try {
                PropertyDescriptor[] propertyDescriptorArray = null;
                if (clazz != null) {
                    BeanInfo beanInfo = null;
                    beanInfo = Introspector.getBeanInfo(clazz);
                    propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    Object var7_9 = null;
                    try {
                        var7_9 = clazz.newInstance();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"228");
                        Tr.error((TraceComponent)tc, (String)"ADMN0046E", (Object)new Object[]{string, illegalAccessException});
                        throw new AdminException(illegalAccessException, J2CAppUtils.getFormattedMessage("ADMN0046E", new Object[]{string, illegalAccessException}, "Failed to introspect the class: " + string + " Could not access the beanInfo."));
                    }
                    catch (InstantiationException instantiationException) {
                        FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"235");
                        Tr.error((TraceComponent)tc, (String)"ADMN0047E", (Object)new Object[]{string, instantiationException});
                        throw new AdminException(instantiationException, J2CAppUtils.getFormattedMessage("ADMN0047E", new Object[]{string, instantiationException}, "Failed to introspect the class: " + string + "Could not instantiated."));
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"244");
                        Tr.error((TraceComponent)tc, (String)"ADMN0051E", (Object)new Object[]{string, exception});
                        throw new AdminException(exception, J2CAppUtils.getFormattedMessage("ADMN0051E", new Object[]{string, exception}, "Failed to introspect the class:" + string + " with unknown exception."));
                    }
                    Object object = null;
                    for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                        Method method = propertyDescriptorArray[i].getReadMethod();
                        Method method2 = propertyDescriptorArray[i].getWriteMethod();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("propd[" + i + "] = " + propertyDescriptorArray[i].getName()));
                            Tr.debug((TraceComponent)tc, (String)("mtd = " + method));
                            Tr.debug((TraceComponent)tc, (String)("mtd2 = " + method2));
                        }
                        if (method == null || method2 == null) continue;
                        String string3 = propertyDescriptorArray[i].getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Introspect a new property:" + method));
                        }
                        if (string3.equalsIgnoreCase("resourceAdapter") || string3.equalsIgnoreCase("logWriter")) continue;
                        Class<?> clazz2 = propertyDescriptorArray[i].getPropertyType();
                        Class<?> clazz3 = method.getDeclaringClass();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("methd is declared by " + clazz3));
                        }
                        if (!clazz3.getName().startsWith("java.lang") && clazz3.getName().startsWith("java") || (!clazz3.getName().equals("Destination") || !string2.equals("J2CActivationSpec")) && clazz3.getName().startsWith("javax")) continue;
                        String string4 = null;
                        if (clazz2 != null) {
                            if (clazz2.isPrimitive()) {
                                string4 = J2CAppUtils.convertToType(clazz2);
                            }
                            if (var7_9 != null) {
                                try {
                                    object = method.invoke(var7_9, null);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"268");
                                    Throwable throwable = invocationTargetException.getTargetException();
                                    Tr.error((TraceComponent)tc, (String)"ADMN0048W", (Object)new Object[]{string, string3});
                                    object = null;
                                }
                            } else {
                                object = null;
                            }
                        } else {
                            Tr.debug((TraceComponent)tc, (String)(" property class " + string + "mathod : " + method + " is not object type."));
                            continue;
                        }
                        J2EEResourceProperty j2EEResourceProperty = resourcesFactory.createJ2EEResourceProperty();
                        j2EEResourceProperty.setName(string3);
                        j2EEResourceProperty.setType(clazz2.getName());
                        if (object != null) {
                            j2EEResourceProperty.setValue(object.toString());
                        } else {
                            j2EEResourceProperty.setValue(null);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Introspection a new property  name :" + string3 + " type : " + clazz2.getName() + " value: " + object));
                        }
                        arrayList.add(j2EEResourceProperty);
                    }
                    break block25;
                }
                arrayList = null;
            }
            catch (IntrospectionException introspectionException) {
                FFDCFilter.processException((Throwable)introspectionException, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"301");
                Tr.error((TraceComponent)tc, (String)"ADMN0049E", (Object)new Object[]{string, introspectionException});
                throw new AdminException(introspectionException, J2CAppUtils.getFormattedMessage("ADMN0049E", new Object[]{string, introspectionException}, "Failed to introspect the class: " + string));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.InstallRAHelper.loadBeanProperty", (String)"315");
                Tr.error((TraceComponent)tc, (String)"ADMN0051E", (Object)new Object[]{string, exception});
                throw new AdminException(exception, J2CAppUtils.getFormattedMessage("ADMN0051E", new Object[]{string, exception}, "Failed to introspect the class:" + string + " with unknown exception."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("loadBeanProperty returns " + arrayList));
        }
        return arrayList;
    }

    private static String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = nls.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (Exception exception) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
    }

    static String convertToType(Class clazz) {
        String string = clazz.getName();
        return (String)pType.get(string);
    }

    static void initpType() {
        if (pType == null) {
            pType = new HashMap(8);
        }
        pType.put("int", "java.lang.Integer");
        pType.put("boolean", "java.lang.Boolean");
        pType.put("char", "java.lang.Character");
        pType.put("byte", "java.lang.Byte");
        pType.put("short", "java.lang.Short");
        pType.put("long", "java.lang.Long");
        pType.put("double", "java.lang.Double");
        pType.put("float", "java.lang.Float");
    }

    public static List searchAppResources(String string, ConfigService configService, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("searchAppResources(" + string + "," + configService + " ," + string2 + ")"));
        }
        List list = null;
        try {
            Object object;
            AppManagement appManagement = null;
            if (configService instanceof ConfigServiceProxy) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Remote Client");
                }
                object = (ConfigServiceProxy)configService;
                appManagement = AppManagementProxy.getJMXProxyForClient(((ConfigServiceProxy)object).getAdminClient());
            } else {
                object = AdminServiceFactory.getAdminService();
                if (object == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Local");
                    }
                    appManagement = AppManagementProxy.getLocalProxy();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Server");
                    }
                    appManagement = AppManagementProxy.getJMXProxyForServer();
                }
            }
            object = new Hashtable();
            List list2 = appManagement.searchResources(string, (Hashtable)object, string2);
            list = appManagement.convertRefToConfigID(string, list2, (Hashtable)object, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.tasks.J2CAppUtils", (String)"535");
            throw new AdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("searchAppResources returns " + list));
        }
        return list;
    }

    public static String getAppSyncMarkerLocation(String string, String string2) {
        String string3;
        String string4;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppSyncMarkerLocation", (Object)new Object[]{string, string2});
            }
            string4 = null;
            string3 = null;
            try {
                Object object;
                Field field;
                Class<?> clazz = Class.forName("com.ibm.ws.sm.workspace.impl.WorkSpaceConstant");
                if (clazz != null && (field = clazz.getDeclaredField("WORKSPACE_PATH_NAME")) != null && (object = field.get(null)) instanceof String) {
                    String string5;
                    string4 = string5 = (String)object;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Result using reflection", (Object)string4);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception recieved", (Object)exception);
            }
        }
        string3 = string4 != null ? string4 + File.separator + "appsync" + File.separator + string2 + ".marker" : string + File.separator + "wstemp" + File.separator + "appsync" + File.separator + string2 + ".marker";
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppSyncMarkerLocation", (Object)new Object[]{string3});
        }
        return string3;
    }

    public static Hashtable getAppDocuments(String string) throws AdminException {
        DocumentDigest[] documentDigestArray;
        String[] stringArray;
        Tr.entry((TraceComponent)tc, (String)"getAppDocuments");
        Hashtable<String, DocumentDigest> hashtable = new Hashtable<String, DocumentDigest>();
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        String string2 = "cells/" + AdminServiceFactory.getAdminService().getCellName() + "/applications/" + string + ".ear";
        Tr.debug((TraceComponent)tc, (String)("ROOT " + string2));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("root app dir is  = " + string2));
        }
        if ((stringArray = configRepository.listResourceNames(string2, 1, Integer.MAX_VALUE)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"uri is null - so return");
            }
            return hashtable;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uris num = " + stringArray.length));
        }
        if ((documentDigestArray = configRepository.getDigest(stringArray)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"digests are null - so return");
            }
            return hashtable;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dig num = " + documentDigestArray.length));
        }
        if (stringArray.length != documentDigestArray.length) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"digests != uri, so return");
            }
            return hashtable;
        }
        hashtable = new Hashtable();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], documentDigestArray[i]);
        }
        return hashtable;
    }

    static {
        if (pType == null) {
            pType = new HashMap(8);
        }
        J2CAppUtils.initpType();
    }
}

