/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.metadata;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Properties;

public class ManagedObjectMetadataHelper {
    public static final String BASE_WAS_PRODUCT_VERSION = "com.ibm.websphere.baseProductVersion";
    public static final String NODE_OS = "com.ibm.websphere.nodeOperatingSystem";
    public static final String NODE_OS_AS400 = "os400";
    public static final String NODE_OS_AIX = "aix";
    public static final String NODE_OS_HPUX = "hpux";
    public static final String NODE_OS_LINUX = "linux";
    public static final String NODE_OS_SOLARIS = "solaris";
    public static final String NODE_OS_WINDOWS = "windows";
    public static final String NODE_OS_ZOS = "os390";
    public static final String NODE_SYSPLEX_NAME = "com.ibm.websphere.nodeSysplexName";
    public static final String NODE_DEPLOYED_FEATURES = "com.ibm.websphere.deployed.features";
    private static final char FEATURE_DELIMITER = ',';
    private ManagedObjectMetadataAccessor _metadataAccessor = null;

    public ManagedObjectMetadataHelper(ManagedObjectMetadataAccessor managedObjectMetadataAccessor) throws AdminException {
        if (managedObjectMetadataAccessor == null) {
            throw new AdminException("Invalid parameter: null ManagedObjectMetadataAccessor.");
        }
        this._metadataAccessor = managedObjectMetadataAccessor;
    }

    public ManagedObjectMetadataAccessor getAccessor() throws AdminException {
        return this._metadataAccessor;
    }

    public String getNodeMajorVersion(String string) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(BASE_WAS_PRODUCT_VERSION);
        if (string2 == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null) {
            int n = string2.indexOf(46);
            string3 = n == -1 ? string2 : string2.substring(0, n);
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Major version for node \"" + string + "\" is not available.");
        }
        return string3;
    }

    public String getNodeMinorVersion(String string) throws AdminException {
        int n;
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(BASE_WAS_PRODUCT_VERSION);
        if (string2 == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null && (n = string2.indexOf(46)) != -1) {
            int n2 = string2.indexOf(46, n + 1);
            string3 = n2 == -1 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Minor version for node \"" + string + "\" is not available.");
        }
        return string3;
    }

    public String getNodeUpdateVersion(String string) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(BASE_WAS_PRODUCT_VERSION);
        if (string2 == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null) {
            int n = string2.indexOf(46);
            if (n != -1) {
                n = string2.indexOf(46, n + 1);
            }
            if (n != -1) {
                int n2 = string2.indexOf(46, n + 1);
                string3 = n2 == -1 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
            }
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Update version for node \"" + string + "\" is not available.");
        }
        return string3;
    }

    public String getNodeServiceVersion(String string) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(BASE_WAS_PRODUCT_VERSION);
        if (string2 == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null) {
            int n = string2.indexOf(46);
            if (n != -1) {
                n = string2.indexOf(46, n + 1);
            }
            if (n != -1) {
                n = string2.indexOf(46, n + 1);
            }
            if (n != -1) {
                int n2 = string2.indexOf(46, n + 1);
                string3 = n2 == -1 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
            }
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Service version for node \"" + string + "\" is not available.");
        }
        return string3;
    }

    public String getNodeBaseProductVersion(String string) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(BASE_WAS_PRODUCT_VERSION);
        if (string2 == null) {
            throw new MetadataNotAvailableException("Base product version for node \"" + string + "\" is not available.");
        }
        return string2;
    }

    public int compareNodeVersion(String string, String string2) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string3 = properties.getProperty(BASE_WAS_PRODUCT_VERSION);
        if (string3 == null) {
            throw new MetadataNotAvailableException("Base product version info for node \"" + string + "\" is not available.");
        }
        int n = 0;
        try {
            VersionParser versionParser = new VersionParser(string2);
            VersionParser versionParser2 = new VersionParser(string3);
            while (versionParser.hasMoreComponents() && n == 0) {
                int n2 = versionParser.nextComponent();
                if (versionParser2.hasMoreComponents()) {
                    int n3 = versionParser2.nextComponent();
                    if (n3 < n2) {
                        n = -1;
                        continue;
                    }
                    if (n3 <= n2) continue;
                    n = 1;
                    continue;
                }
                throw new AdminException("Specified version contains more components than available version info.");
            }
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AdminException(illegalArgumentException, "Invalid input.  See nested exception for more information.");
        }
        return n;
    }

    public boolean isNodeZOS(String string) throws AdminException {
        boolean bl;
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(NODE_OS);
        String string3 = null;
        try {
            string3 = this.getNodeMajorVersion(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string2 != null) {
            bl = string2.equals(NODE_OS_ZOS);
        } else if (string3 != null && string3.equals("5")) {
            bl = false;
        } else {
            throw new MetadataNotAvailableException("OS for node \"" + string + "\" is not available.");
        }
        return bl;
    }

    public String getNodePlatformOS(String string) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(NODE_OS);
        if (string2 == null) {
            throw new MetadataNotAvailableException("OS for node \"" + string + "\" is not available.");
        }
        return string2;
    }

    public String getNodeSysplexName(String string) throws AdminException {
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(NODE_SYSPLEX_NAME);
        if (string2 == null) {
            throw new MetadataNotAvailableException("Sysplex for node \"" + string + "\" is not available.");
        }
        return string2;
    }

    public ArrayList getNodeDeployedFeatures(String string) throws AdminException {
        int n;
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(NODE_DEPLOYED_FEATURES);
        if (string2 == null) {
            throw new MetadataNotAvailableException("List of deployed features for node \"" + string + "\" is not available.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        do {
            String string3;
            if ((n = string2.indexOf(44, n2)) == -1) {
                string3 = string2.substring(n2).trim();
            } else {
                string3 = string2.substring(n2, n).trim();
                n2 = n + 1;
            }
            if (string3 == null || string3.length() == 0) continue;
            arrayList.add(string3);
        } while (n != -1);
        return arrayList;
    }

    private class VersionParser {
        String _inputString;
        int _inputStringLength;
        int _currIndex;
        private static final char VERSION_DELIMITER = '.';

        public VersionParser(String string) throws IllegalArgumentException {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("Invalid version: Null or empty version number.");
            }
            this._inputString = string;
            this._inputStringLength = string.length();
            this._currIndex = 0;
        }

        public boolean hasMoreComponents() {
            return this._currIndex < this._inputStringLength;
        }

        public int nextComponent() throws IllegalArgumentException, NoSuchElementException {
            String string;
            int n;
            if (this._currIndex < this._inputStringLength) {
                n = this._inputString.indexOf(46, this._currIndex);
                if (n != -1) {
                    string = this._inputString.substring(this._currIndex, n);
                    this._currIndex = n + 1;
                } else {
                    string = this._inputString.substring(this._currIndex);
                    this._currIndex = this._inputStringLength;
                }
            } else {
                throw new NoSuchElementException();
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Invalid version: Empty component in version number.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("ERROR: Component in version is not a number.");
            }
            return n;
        }
    }
}

