/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ManagedObjectMetadataAccessorFactory {
    private static TraceComponent _tc = Tr.register((Class)ManagedObjectMetadataAccessorFactory.class, (String)"Admin", null);
    private static final String ACCESSOR_IMPL_CLASS_NAME = "com.ibm.ws.management.metadata.ManagedObjectMetadataAccessorImpl";
    private static HashMap _accessorCache = new HashMap();

    public static ManagedObjectMetadataAccessor createAccessor(Properties properties) throws AdminException {
        String[] stringArray;
        Object object;
        Map<Object, Object> map;
        Object object2;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"createAccessor", (Object)("Input props: " + properties));
        }
        IllegalArgumentException illegalArgumentException = null;
        properties = properties == null ? new Properties() : (Properties)properties.clone();
        String string = "CONFIG_SESSION";
        String string2 = properties.getProperty(string);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)"configSession", (Object)string2);
        }
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.configservice.MOFUtil");
                Method method = clazz.getMethod("getMetadataHelper", String.class);
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor = (ManagedObjectMetadataAccessor)method.invoke(null, string2);
                if (_tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"createAccessor", (Object)managedObjectMetadataAccessor);
                }
                return managedObjectMetadataAccessor;
            }
            catch (Exception exception) {
                throw new AdminException(exception, "Encountered an error while attempting to create a ManagedObjectMetadataAccessor instance.");
            }
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string3 = properties.getProperty("was.repository.root");
        if (string3 == null || string3.length() == 0) {
            string3 = System.getProperty("was.repository.root");
            if (string3 == null || string3.length() == 0) {
                if (adminService == null) {
                    illegalArgumentException = new IllegalArgumentException("The property \"was.repository.root\" setting does not exist in the set of input properties or system properties or has a zero-length value.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("createAccessor: Using repository root from sys props: " + string3));
                }
                properties.setProperty("was.repository.root", string3);
            }
        }
        if (string3 != null && (string3.endsWith("/") || string3.endsWith("\\"))) {
            string3 = string3.substring(0, string3.length() - 1);
            properties.setProperty("was.repository.root", string3);
        }
        String string4 = string3;
        string3 = properties.getProperty("local.cell");
        if (illegalArgumentException == null && (string3 == null || string3.length() == 0)) {
            string3 = System.getProperty("local.cell");
            if (string3 == null || string3.length() == 0) {
                if (adminService != null) {
                    string3 = adminService.getCellName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createAccessor: Using cell name from AdminService.");
                    }
                } else {
                    object2 = null;
                    try {
                        map = new Properties();
                        ((Properties)map).setProperty("location", "local");
                        ((Properties)map).setProperty("was.repository.root", string4);
                        object = ConfigRepositoryClientFactory.getConfigRepositoryClient(map);
                        stringArray = object.listResourceNames("cells", 2, 1);
                        if (stringArray.length == 1) {
                            string3 = stringArray[0].substring(6);
                            Tr.debug((TraceComponent)_tc, (String)"createAccessor: Using cell name from repository.");
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"ManagedObjectMetadataAccessorImpl", (Object)"Mult cells in repo");
                            }
                            object2 = "Property \"local.cell\" not defined or has a zero-length value, and could not uniquely determine the cell name because more than one cell name was found in the configuration repository.";
                        }
                    }
                    catch (AdminException adminException) {
                        if (_tc.isEventEnabled()) {
                            Tr.event((TraceComponent)_tc, (String)"Could not get ConfigRepository reference.", (Object)((Object)adminException));
                        }
                        object2 = "Property \"local.cell\" not defined or has a zero-length value, and could not access configuration repository to determine the cell name.";
                    }
                    if (object2 != null) {
                        illegalArgumentException = new IllegalArgumentException((String)object2);
                    }
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"createAccessor: Using cell name system environment.");
            }
            if (string3 != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("createAccessor: cellName=" + string3));
                }
                properties.setProperty("local.cell", string3);
            }
        }
        if (illegalArgumentException != null) {
            throw new AdminException(illegalArgumentException, "Invalid input.  See nested exception for more information.");
        }
        object2 = new AccessorCacheKey(properties.getProperty("was.repository.root"), properties.getProperty("local.cell"));
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Accessor cache key: " + object2));
        }
        map = _accessorCache;
        synchronized (map) {
            object = (ManagedObjectMetadataAccessor)_accessorCache.get(object2);
            if (object != null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)_tc, (String)"createAccessor: Returning cached accessor.");
                }
                return object;
            }
            try {
                stringArray = Class.forName(ACCESSOR_IMPL_CLASS_NAME);
                Constructor constructor = stringArray.getConstructor(Properties.class);
                object = (ManagedObjectMetadataAccessor)constructor.newInstance(properties);
                _accessorCache.put(object2, object);
                if (_tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)_tc, (String)"createAccessor");
                }
                return object;
            }
            catch (Exception exception) {
                throw new AdminException(exception, "Encountered an error while attempting to create a ManagedObjectMetadataAccessor instance.");
            }
        }
    }

    private static class AccessorCacheKey {
        private static String SERVER_PROC = "///THIS_SERVER_REPO///";
        private String _repoRoot;
        private String _cellName;

        public AccessorCacheKey(String string, String string2) {
            this._repoRoot = string != null ? string : SERVER_PROC;
            this._cellName = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof AccessorCacheKey) {
                AccessorCacheKey accessorCacheKey = (AccessorCacheKey)object;
                return this._repoRoot.equals(accessorCacheKey._repoRoot) && this._cellName.equals(accessorCacheKey._cellName);
            }
            return super.equals(object);
        }

        public int hashCode() {
            return 31 * this._repoRoot.hashCode() + this._cellName.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this._repoRoot);
            stringBuffer.append(":");
            stringBuffer.append(this._cellName);
            return stringBuffer.toString();
        }
    }
}

