/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.fileservice;

import java.io.Serializable;

public class RemoteFile
implements Serializable {
    private static final long serialVersionUID = 2268200531415934166L;
    public static final String NORMAL_FILE = "NormalFile";
    public static final String DIRECTORY = "Directory";
    public static final String ROOT = "Root";
    public static final String EAR_FILE = "EARFILE";
    public static final String EJBJAR_FILE = "EJBJAR_FILE";
    public static final String WAR_FILE = "WAR_FILE";
    public static final String RAR_FILE = "RAR_FILE";
    private String name = null;
    private String absPath = null;
    private String type = null;
    private boolean hidden = false;
    private String parentDirectory = null;
    private String separator = null;

    public final String getName() {
        return this.name;
    }

    public final String getPath() {
        return this.absPath;
    }

    public final String getAbsolutePath() {
        return this.absPath;
    }

    public final String getType() {
        if (this.type == null) {
            return null;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".war")) {
            return WAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".ear")) {
            return EAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".jar")) {
            return EJBJAR_FILE;
        }
        if (this.type.equals(NORMAL_FILE) && this.absPath.endsWith(".rar")) {
            return RAR_FILE;
        }
        return this.type;
    }

    public boolean isDirectory() {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().equals(DIRECTORY);
    }

    public boolean isNormalFile() {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().equals(NORMAL_FILE);
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    public final String getParentDirectory() {
        return this.parentDirectory;
    }

    public boolean isRoot() {
        return this.getParentDirectory() == null;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void setAbsolutePath(String string) {
        this.absPath = string;
    }

    public final void setType(String string) {
        this.type = string;
    }

    public final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public final void setParentDirectory(String string) {
        this.parentDirectory = string;
    }

    public final void setSeparator(String string) {
        this.separator = string;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name:").append(this.name);
        stringBuffer.append(",absPath:").append(this.absPath);
        stringBuffer.append(",type:").append(this.type);
        stringBuffer.append(",hidden:").append(this.hidden);
        stringBuffer.append(",parentDirectory:").append(this.parentDirectory);
        stringBuffer.append(",separator:").append(this.separator);
        return stringBuffer.toString();
    }
}

