/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class SimpleCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register((Class)SimpleCommandProvider.class, (String)"SimpleCommandProvider", (String)"com.ibm.websphere.management.cmdframework.provider");
    protected HashMap methodTable;

    protected SimpleCommandProvider() {
        Class<?> clazz = this.getClass();
        Method[] methodArray = clazz.getMethods();
        this.methodTable = new HashMap(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            this.methodTable.put(methodArray[i].getName(), methodArray[i]);
        }
    }

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        String string = commandMetadata.getName();
        if (!this.methodTable.containsKey(string)) {
            throw new CommandNotFoundException(string);
        }
        return new SimpleAdminCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        SimpleAdminCommand simpleAdminCommand;
        try {
            simpleAdminCommand = new SimpleAdminCommand(commandData);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            throw commandNotFoundException;
        }
        catch (CommandLoadException commandLoadException) {
            throw commandLoadException;
        }
        catch (Exception exception) {
            throw new CommandLoadException(exception);
        }
        return simpleAdminCommand;
    }

    protected void execute(SimpleAdminCommand simpleAdminCommand) {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            simpleAdminCommand.validate();
            CommandMetadata commandMetadata = simpleAdminCommand.getCommandMetadata();
            Method method = (Method)this.methodTable.get(simpleAdminCommand.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Method to execute is " + method.getName()));
            }
            Object object = method.invoke((Object)this, simpleAdminCommand);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Result is " + object + " " + object.getClass()));
            }
            commandResultImpl.setResult(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception thrown when invocation command");
            }
            commandResultImpl.setException(invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception thrown when execute command");
            }
            commandResultImpl.setException(throwable);
        }
        simpleAdminCommand.setCommandResult(commandResultImpl);
    }
}

