/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.LocalCommandMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractTaskCommand
extends AbstractAdminCommand
implements TaskCommand {
    private static TraceComponent tc = Tr.register((Class)AbstractTaskCommand.class, (String)"AbstractTaskCommand", (String)"com.ibm.websphere.management.cmdframework");
    private Map steps = new HashMap();
    private int currentStepIndex = 0;
    private boolean isLocal;
    private AbstractCommandStep currentStep = null;

    public AbstractTaskCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AbstractTaskCommand", (Object)taskCommandMetadata);
        }
        if (CommandMgr.getCommandMgr() instanceof LocalCommandMgr) {
            this.isLocal = true;
        }
        this.contructSteps();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AbstractTaskCommand");
        }
    }

    protected void contructSteps() throws CommandNotFoundException {
        TaskCommandData taskCommandData = this.getTaskCommandData();
        TaskCommandMetadata taskCommandMetadata = this.getTaskCommandMetadata();
        EList eList = taskCommandMetadata.getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)iterator.next();
            if (this.isLocal && (!commandStepMetadata.isSupportLocalMode() || !this.isLocal)) continue;
            String string = commandStepMetadata.getName();
            CommandProvider commandProvider = CommandMetadataMgr.getInstance().getCommandProvider(this.getName(), string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"stepName", (Object)string);
            }
            AbstractCommandStep abstractCommandStep = commandProvider.createCommandStep(this, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"step", (Object)abstractCommandStep);
            }
            this.addStep(abstractCommandStep, commandProvider.commandStepPosition(this, string));
        }
    }

    public AbstractTaskCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AbstractTaskCommand", (Object)commandData);
        }
        TaskCommandData taskCommandData = this.getTaskCommandData();
        EList eList = taskCommandData.getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            String string = commandStepData.getName();
            CommandProvider commandProvider = CommandMetadataMgr.getInstance().getCommandProvider(this.getName(), string);
            AbstractCommandStep abstractCommandStep = commandProvider.loadCommandStep(this, commandStepData);
            this.steps.put(string, abstractCommandStep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AbstractTaskCommand");
        }
    }

    protected CommandData initCommandData() {
        return CommandDataFactory.eINSTANCE.createTaskCommandData();
    }

    public CommandStep getCurrentStep(int n) {
        if (tc.isDebugEnabled() && this.currentStep != null) {
            Tr.debug((TraceComponent)tc, (String)"currentstep", (Object)this.currentStep.getName());
        }
        return this.getCurrentStep(n, "");
    }

    public CommandStep getCurrentStep(int n, String string) {
        if (tc.isDebugEnabled() && this.currentStep != null) {
            Tr.debug((TraceComponent)tc, (String)"currentstep", (Object)this.currentStep.getName());
        }
        return this.currentStep;
    }

    public void setCurrentStep(AbstractCommandStep abstractCommandStep) {
        this.currentStep = abstractCommandStep;
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public void setCurrentStepIndex(int n) {
        this.currentStepIndex = n;
    }

    public final String[] listCommandSteps() {
        EList eList = this.getTaskCommandData().getSteps();
        String[] stringArray = new String[eList.size()];
        for (int i = 0; i < eList.size(); ++i) {
            stringArray[i] = ((CommandStepData)eList.get(i)).getName();
        }
        return stringArray;
    }

    public final CommandStep nextStep() throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextStep");
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(0);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        } else {
            this.commandParamsModified();
        }
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("1. Step data list is " + eList));
        }
        int n = eList.size();
        AbstractCommandStep abstractCommandStep = null;
        for (int i = this.currentStepIndex; i < n; ++i) {
            CommandStepData commandStepData = (CommandStepData)eList.get(i);
            if (!commandStepData.isEnabled()) continue;
            abstractCommandStep = (AbstractCommandStep)this.steps.get(commandStepData.getName());
            this.currentStepIndex = i + 1;
            break;
        }
        if (abstractCommandStep == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Next step not available ");
            }
            throw new NoSuchElementException();
        }
        this.currentStep = abstractCommandStep;
        abstractCommandStep.initStep();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nextStep", (Object)abstractCommandStep.getName());
        }
        return abstractCommandStep;
    }

    public final CommandStep previousStep() throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"previousStep");
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(1);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        }
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("3. Step data list is " + eList));
        }
        int n = eList.size();
        AbstractCommandStep abstractCommandStep = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current stepindex is " + this.currentStepIndex));
        }
        for (int i = this.currentStepIndex - 1; i > 0; --i) {
            if (i <= 0) {
                throw new NoSuchElementException();
            }
            CommandStepData commandStepData = (CommandStepData)eList.get(i - 1);
            if (!commandStepData.isEnabled()) continue;
            abstractCommandStep = (AbstractCommandStep)this.steps.get(commandStepData.getName());
            this.currentStepIndex = i;
            if (!tc.isDebugEnabled()) break;
            Tr.debug((TraceComponent)tc, (String)("index is  " + i));
            break;
        }
        if (abstractCommandStep == null) {
            throw new NoSuchElementException();
        }
        this.currentStep = abstractCommandStep;
        abstractCommandStep.initStep();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"previousStep", (Object)abstractCommandStep.getName());
        }
        return abstractCommandStep;
    }

    public final boolean hasNextStep() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasNextStep");
        }
        EList eList = this.getTaskCommandData().getSteps();
        int n = eList.size();
        boolean bl = false;
        for (int i = this.currentStepIndex; i < n; ++i) {
            CommandStepData commandStepData = (CommandStepData)eList.get(i);
            if (!commandStepData.isEnabled()) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("hasNextStep," + bl));
        }
        return bl;
    }

    public final boolean hasPreviousStep() {
        EList eList = this.getTaskCommandData().getSteps();
        int n = eList.size();
        boolean bl = false;
        for (int i = this.currentStepIndex - 2; i >= 0; --i) {
            CommandStepData commandStepData;
            if (i < 0 || !(commandStepData = (CommandStepData)eList.get(i)).isEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public final CommandStep gotoStep(String string) throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"gotoStep", (Object)string);
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(2, string);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        }
        TaskCommandData taskCommandData = this.getTaskCommandData();
        CommandStepData commandStepData = taskCommandData.getStepData(string);
        AbstractCommandStep abstractCommandStep = null;
        if (commandStepData == null || !commandStepData.isEnabled()) {
            throw new NoSuchElementException();
        }
        this.currentStepIndex = taskCommandData.getSteps().indexOf((Object)commandStepData) + 1;
        abstractCommandStep = (AbstractCommandStep)this.steps.get(commandStepData.getName());
        this.currentStep = abstractCommandStep;
        abstractCommandStep.initStep();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("gotoStep " + abstractCommandStep));
        }
        return abstractCommandStep;
    }

    public final CommandStep getCommandStep(String string) throws CommandNotFoundException {
        CommandStep commandStep;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCommandStep", (Object)string);
        }
        if ((commandStep = (CommandStep)this.steps.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCommandStep");
            }
            throw new CommandNotFoundException("Command Step " + string + " not found");
        }
        ((AbstractCommandStep)commandStep).initStep();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCommandStep", (Object)commandStep.getName());
        }
        return commandStep;
    }

    public final TaskCommandData getTaskCommandData() {
        return (TaskCommandData)this.getCommandData();
    }

    public final TaskCommandMetadata getTaskCommandMetadata() {
        return (TaskCommandMetadata)this.getCommandMetadata();
    }

    private void addStep(AbstractCommandStep abstractCommandStep, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addStep", (Object)new Object[]{abstractCommandStep, new Integer(n)});
        }
        this.steps.put(abstractCommandStep.getName(), abstractCommandStep);
        TaskCommandData taskCommandData = this.getTaskCommandData();
        EList eList = taskCommandData.getSteps();
        CommandStepData commandStepData = taskCommandData.getStepData(abstractCommandStep.getName());
        if (commandStepData != null) {
            eList.remove(commandStepData);
        }
        if (n < 0 || n > eList.size()) {
            eList.add(abstractCommandStep.getCommandData());
        } else {
            eList.add(n, abstractCommandStep.getCommandData());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addStep");
        }
    }

    public void resetCommandData(CommandData commandData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetCommandData", (Object)commandData);
        }
        super.resetCommandData(commandData);
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"step data list is  ", (Object)eList);
        }
        for (int i = 0; i < eList.size(); ++i) {
            AbstractCommandStep abstractCommandStep;
            CommandStepData commandStepData = (CommandStepData)eList.get(i);
            String string = commandStepData.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"steps are ", (Object)this.steps);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"step Name is ", (Object)string);
            }
            if ((abstractCommandStep = (AbstractCommandStep)this.steps.get(string)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"reload step comanddata", (Object)commandStepData);
                }
                abstractCommandStep.resetCommandData(commandStepData);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"create new step", (Object)commandStepData);
            }
            TaskCommandMetadata taskCommandMetadata = this.getTaskCommandMetadata();
            CommandStepMetadata commandStepMetadata = null;
            Iterator iterator = taskCommandMetadata.getSteps().iterator();
            while (iterator.hasNext()) {
                CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)iterator.next();
                if (!commandStepMetadata2.getName().equals(string)) continue;
                commandStepMetadata = commandStepMetadata2;
                break;
            }
            if (commandStepMetadata == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"unable to create step", commandStepMetadata);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"stepMetadata", commandStepMetadata);
            }
            abstractCommandStep = new AbstractCommandStep(this, commandStepMetadata);
            abstractCommandStep.resetCommandData(commandStepData);
            this.addStep(abstractCommandStep, i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetCommandData");
        }
    }

    public void validate() throws CommandValidationException {
        super.validate();
        EList eList = this.getTaskCommandData().getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.steps.get(commandStepData.getName());
            if (!abstractCommandStep.isEnabled()) continue;
            abstractCommandStep.validate();
        }
    }

    protected void beforeStepsExecuted() {
    }

    protected void afterStepsExecuted() {
    }

    protected void taskCommandExecuted(boolean bl) {
    }

    protected void stepModified(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stepModified");
        }
        EList eList = this.getTaskCommandData().getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string2 = ((CommandStepData)iterator.next()).getName();
            if (string2.equals(string)) continue;
            try {
                AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.getCommandStep(string2);
                abstractCommandStep.stepModified(string);
            }
            catch (CommandNotFoundException commandNotFoundException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.error((TraceComponent)tc, (String)commandNotFoundException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stepModified");
        }
    }

    public void commandParamsModified() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commandParamsModified");
        }
        EList eList = this.getTaskCommandData().getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string = ((CommandStepData)iterator.next()).getName();
            try {
                AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.getCommandStep(string);
                abstractCommandStep.commandParamModified();
            }
            catch (CommandNotFoundException commandNotFoundException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.error((TraceComponent)tc, (String)commandNotFoundException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commandParamsModified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() {
        block20: {
            Iterator iterator;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"execute");
            }
            TaskCommandResultImpl taskCommandResultImpl = new TaskCommandResultImpl();
            this.setCommandResult(taskCommandResultImpl);
            EList eList = this.getTaskCommandData().getSteps();
            ArrayList<String> arrayList = new ArrayList<String>(eList.size());
            boolean bl = true;
            try {
                block19: {
                    this.validate();
                    this.beforeStepsExecuted();
                    if (!taskCommandResultImpl.isSuccessful()) {
                        bl = false;
                        break block19;
                    }
                    Iterator iterator2 = eList.iterator();
                    while (iterator2.hasNext()) {
                        CommandStepData commandStepData = (CommandStepData)iterator2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"stepData", (Object)commandStepData);
                        }
                        AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.getCommandStep(commandStepData.getName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"step", (Object)abstractCommandStep);
                        }
                        abstractCommandStep.executeStep();
                        CommandResult commandResult = abstractCommandStep.getCommandResult();
                        taskCommandResultImpl.setStepResult(abstractCommandStep.getName(), commandResult);
                        arrayList.add(abstractCommandStep.getName());
                        if (taskCommandResultImpl.isSuccessful()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("task command " + this.getName() + " failed on step " + abstractCommandStep.getName()));
                        }
                        bl = false;
                        break;
                    }
                    if (!bl) break block19;
                    this.afterStepsExecuted();
                }
                Object var10_10 = null;
                EList eList2 = this.getTaskCommandData().getSteps();
                iterator = eList2.iterator();
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                EList eList3 = this.getTaskCommandData().getSteps();
                Iterator iterator3 = eList3.iterator();
                while (iterator3.hasNext()) {
                    Object object2222;
                    String string = ((CommandStepData)iterator3.next()).getName();
                    try {
                        object2222 = (AbstractCommandStep)this.getCommandStep(string);
                        ((AbstractCommandStep)object2222).taskCommandExecuted(taskCommandResultImpl.isSuccessful(), arrayList.contains(string));
                    }
                    catch (CommandNotFoundException object2222) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.error((TraceComponent)tc, (String)object2222.getMessage());
                    }
                }
                this.taskCommandExecuted(taskCommandResultImpl.isSuccessful());
                throw throwable;
            }
            while (iterator.hasNext()) {
                Object object3222;
                String string = ((CommandStepData)iterator.next()).getName();
                try {
                    object3222 = (AbstractCommandStep)this.getCommandStep(string);
                    ((AbstractCommandStep)object3222).taskCommandExecuted(taskCommandResultImpl.isSuccessful(), arrayList.contains(string));
                }
                catch (CommandNotFoundException object3222) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.error((TraceComponent)tc, (String)object3222.getMessage());
                }
            }
            this.taskCommandExecuted(taskCommandResultImpl.isSuccessful());
            {
                break block20;
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception thrown during command validation");
                    }
                    taskCommandResultImpl.setException(throwable);
                    Object var10_11 = null;
                    EList eList4 = this.getTaskCommandData().getSteps();
                    Iterator iterator4 = eList4.iterator();
                    while (iterator4.hasNext()) {
                        Object object4222;
                        String string = ((CommandStepData)iterator4.next()).getName();
                        try {
                            object4222 = (AbstractCommandStep)this.getCommandStep(string);
                            ((AbstractCommandStep)object4222).taskCommandExecuted(taskCommandResultImpl.isSuccessful(), arrayList.contains(string));
                        }
                        catch (CommandNotFoundException object4222) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.error((TraceComponent)tc, (String)object4222.getMessage());
                        }
                    }
                    this.taskCommandExecuted(taskCommandResultImpl.isSuccessful());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"execute");
        }
    }

    public TaskCommandResult getTaskCommandResult() {
        return (TaskCommandResult)this.getCommandResult();
    }

    public void listAllStepParamsData() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listAllStepParamsData", (Object)this.getTaskCommandData());
        }
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"step data list is  ", (Object)eList);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            String string = commandStepData.getName();
            EList eList2 = commandStepData.getCmdParams();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Parameters are " + eList2));
            }
            EObject eObject = null;
            for (int i = 0; i < eList2.size(); ++i) {
                eObject = (EObject)eList2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"paraData name is ", (Object)eObject);
                }
                EClass eClass = eObject.eClass();
                Iterator iterator2 = eClass.getEAllAttributes().iterator();
                while (iterator2.hasNext()) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"feature", (Object)eStructuralFeature);
                    }
                    if (!eObject.eIsSet(eStructuralFeature)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setted feature is " + eStructuralFeature.getName()));
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("setted feature value is " + eObject.eGet(eStructuralFeature)));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listAllStepParamsData");
        }
    }
}

