/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataPackage;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class CommandHistory {
    private static TraceComponent tc = Tr.register((Class)CommandHistory.class, (String)"CommandHistory", (String)"com.ibm.websphere.management.cmdframework");
    private int size = 20;
    private Vector history;

    public CommandHistory() {
        this(20);
    }

    public CommandHistory(int n) {
        this.size = n;
        this.history = new Vector(this.size);
    }

    public void add(CommandData commandData) {
        if (this.history.size() >= this.size) {
            this.history.remove(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("commanddata added is " + commandData));
        }
        this.history.add(commandData);
    }

    public void clear() {
        this.history.clear();
    }

    public Collection getHistory() {
        ArrayList<AbstractAdminCommand> arrayList = new ArrayList<AbstractAdminCommand>();
        for (int i = 0; i < this.history.size(); ++i) {
            try {
                CommandData commandData = (CommandData)this.history.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("commanddata got is " + commandData));
                }
                String string = commandData.getName();
                AbstractAdminCommand abstractAdminCommand = CommandMetadataMgr.getInstance().getCommandProvider(string).loadCommand(commandData);
                arrayList.add(abstractAdminCommand);
                continue;
            }
            catch (CommandNotFoundException commandNotFoundException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Command not found " + ((CommandData)this.history.get(i)).getName()));
                continue;
            }
            catch (CommandLoadException commandLoadException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Command cannot be loaded " + ((CommandData)this.history.get(i)).getName()));
            }
        }
        return arrayList;
    }

    public void save(OutputStream outputStream) {
        block4: {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            XMIResourceImpl xMIResourceImpl = new XMIResourceImpl();
            xMIResourceImpl.setURI(URI.createURI((String)"History.xmi"));
            EList eList = xMIResourceImpl.getContents();
            for (int i = 0; i < this.history.size(); ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("\nHistory to save is " + ((CommandData)this.history.get(i)).getName()));
                }
                eList.add((CommandData)this.history.get(i));
            }
            try {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("DECLARE_XML", Boolean.TRUE);
                xMIResourceImpl.save(outputStream, hashMap);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.error((TraceComponent)tc, (String)iOException.getMessage());
            }
        }
    }

    public void load(InputStream inputStream) {
        block4: {
            CommandDataPackage commandDataPackage = CommandDataPackage.eINSTANCE;
            try {
                ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                XMIResourceImpl xMIResourceImpl = new XMIResourceImpl();
                xMIResourceImpl.setURI(URI.createURI((String)"History.xmi"));
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("DECLARE_XML", Boolean.FALSE);
                xMIResourceImpl.load(inputStream, hashMap);
                EList eList = xMIResourceImpl.getContents();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("\nSize of stored history is " + eList.size() + "\n"));
                }
                for (int i = 0; i < eList.size(); ++i) {
                    this.add((CommandData)eList.get(i));
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.error((TraceComponent)tc, (String)iOException.getMessage());
            }
        }
    }
}

