/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractSqlParseTreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Expression;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Variable
extends AbstractSqlParseTreeNode
implements Expression {
    private static final long serialVersionUID = -6952245338367050023L;
    private static String ParmMarkerValue;
    private String varName;
    private Object varValue;

    public Variable() {
    }

    public Variable(String string) {
        this.name(string);
    }

    public Variable(String string, Object[] objectArray) {
        this.name(string);
        this.value(objectArray);
    }

    public Variable(String string, Object object) {
        this.name(string);
        this.value(object);
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (this.isNotSet()) {
            if (this.isUsingParmMarkers()) {
                stringBuffer.append(Variable.parmMarker());
            } else {
                stringBuffer.append(this.name());
            }
            return;
        }
        if (this.isSingletonValue()) {
            if (!this.isUsingParmMarkers()) {
                stringBuffer.append(this.value());
                return;
            }
            if (!this.isColumnValue()) {
                stringBuffer.append(this.value());
            } else {
                stringBuffer.append(Variable.parmMarker());
            }
            return;
        }
        stringBuffer.append("(");
    }

    public boolean hasValue() {
        return this.value() == null;
    }

    public boolean isColumnValue() {
        return this.value() instanceof RDBColumn;
    }

    public boolean isNotSet() {
        return this.value() == null;
    }

    public boolean isNull() {
        return this.isNullString(this.value());
    }

    public boolean isSingletonValue() {
        return !(this.value() instanceof List);
    }

    public static boolean usingParmMarkers() {
        return QueryEngineInfo.singleton().generateParmMarkers();
    }

    public boolean isVariable() {
        return true;
    }

    public String name() {
        return this.varName;
    }

    public void name(String string) {
        this.varName = string;
    }

    public static String parmMarker() {
        if (ParmMarkerValue == null) {
            ParmMarkerValue = "?";
        }
        return ParmMarkerValue;
    }

    public static void parmMarker(char c) {
        ParmMarkerValue = String.valueOf(c);
    }

    public static void parmMarker(String string) {
        ParmMarkerValue = string;
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.name());
        if (this.hasValue()) {
            stringBuffer.append("-");
            stringBuffer.append(this.value());
        }
    }

    public Object reduce(Object[] objectArray) {
        return this.reduceSet(new StSet(objectArray));
    }

    public Object reduce(Object object) {
        return object;
    }

    public Object reduce(List list) {
        return this.reduceSet(new StSet(list));
    }

    public Object reduceSet(StSet stSet) {
        if (stSet.size() == 1) {
            return stSet.first();
        }
        return stSet.asVector();
    }

    public boolean removeNulls() {
        if (this.isNotSet() || this.isSingletonValue()) {
            return false;
        }
        List list = (List)this.value();
        int n = list.size();
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isNullString(e)) continue;
            arrayList.add(e);
        }
        this.value(arrayList);
        return n > arrayList.size();
    }

    public void resetValue() {
        this.value(null);
    }

    public void setValueToName() {
        this.value(this.name());
    }

    public void unsetValueOn(StringBuffer stringBuffer) {
        if (this.isUsingParmMarkers()) {
            stringBuffer.append(Variable.parmMarker());
        } else {
            stringBuffer.append(this.name());
        }
    }

    public Object value() {
        return this.varValue;
    }

    public void value(Object object) {
        this.varValue = this.reduce(object);
    }
}

