/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.StSet;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBTable;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnsClause;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.TableInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ForUpdateClause
extends ColumnsClause {
    private static final long serialVersionUID = -9217325766620553203L;
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String FORUPDATE = " FOR UPDATE ";
    private static final String OF = " OF ";
    private static final String KEEPLOCKS_RS = " WITH RS KEEP UPDATE LOCKS";
    private static final String KEEPLOCKS_RR = " WITH RR KEEP UPDATE LOCKS";
    private SelectStatement fSelectStmt;

    public ForUpdateClause(SelectStatement selectStatement) {
        this.selectStatement(selectStatement);
    }

    public void addAllColumns() {
        TableInfo tableInfo = new TableInfo((RDBTable)this.selectStatement().firstFromClause().tables().get(0));
        Iterator iterator = tableInfo.nonPKColumns().iterator();
        StSet stSet = StSet.setOn(this.selectStatement().getColumns());
        while (iterator.hasNext()) {
            RDBColumn rDBColumn = (RDBColumn)iterator.next();
            if (!stSet.contains(rDBColumn)) continue;
            this.basicAddColumn(rDBColumn);
        }
    }

    public void addSingleColumn() {
        List list = this.selectStatement().firstFromClause().tables();
        if (list.isEmpty()) {
            return;
        }
        TableInfo tableInfo = new TableInfo((RDBTable)list.get(0));
        RDBColumn rDBColumn = tableInfo.someSimpleColumn();
        if (rDBColumn != null) {
            this.basicAddColumn(rDBColumn);
        }
    }

    public boolean addColumn(RDBColumn rDBColumn) {
        StSet stSet = new StSet();
        stSet.addAll((Collection)this.selectStatement().firstFromClause().tables());
        if (!stSet.contains(rDBColumn.getOwningTable())) {
            return false;
        }
        return this.basicAddColumn(rDBColumn);
    }

    public boolean basicAddColumn(RDBColumn rDBColumn) {
        return super.addColumn(rDBColumn);
    }

    public boolean hasForUpdateClause() {
        return (this.isOracle() && !this.selectStatement().hasSetOperations() || this.selectStatement().isSingleTable()) && !this.isSQLJ();
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        if (QueryEngineInfo.isSQLServer()) {
            return;
        }
        if (this.hasForUpdateClause()) {
            this.doNotQualify();
            stringBuffer.append(FORUPDATE);
            if (!this.columns().isEmpty()) {
                stringBuffer.append(OF);
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    ((ColumnName)iterator.next()).evaluateOn(stringBuffer);
                    if (!iterator.hasNext()) continue;
                    if (this.useExtraSpaces()) {
                        stringBuffer.append(", ");
                        continue;
                    }
                    stringBuffer.append(",");
                }
            }
        }
        if (this.isOS390() && !this.selectStatement().isSelectInto()) {
            stringBuffer.append(KEEPLOCKS_RS);
        }
    }

    public SelectStatement selectStatement() {
        return this.fSelectStmt;
    }

    public void selectStatement(SelectStatement selectStatement) {
        this.fSelectStmt = selectStatement;
    }
}

