/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.Function;
import com.ibm.ObjectQuery.crud.util.NameFunction;
import com.ibm.ObjectQuery.crud.util.NamedCollection;
import com.ibm.ObjectQuery.crud.util.TwoValuedFunction;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractSqlStatementClause;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.BasicAssignment;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Update;
import java.util.Iterator;
import java.util.List;

public class AssignmentClause
extends AbstractSqlStatementClause {
    private static final long serialVersionUID = 5027601322784779590L;
    private NamedCollection fAssignments;
    private Update fStatement;

    public AssignmentClause(Update update) {
        this.statement(update);
    }

    public void add(RDBColumn rDBColumn) {
        if (!this.includesColumn(rDBColumn)) {
            this.assignments().add(this.createAssignment(rDBColumn));
        }
    }

    public void add(RDBColumn rDBColumn, Object object) {
        BasicAssignment basicAssignment = (BasicAssignment)this.assignments().named(rDBColumn.getName());
        if (basicAssignment == null) {
            basicAssignment = this.createAssignment(rDBColumn);
            this.assignments().add(basicAssignment);
        }
        basicAssignment.value(object);
    }

    public void statement(Update update) {
        this.fStatement = update;
    }

    public Update statement() {
        return this.fStatement;
    }

    public void addAll(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.add((RDBColumn)iterator.next());
        }
    }

    public NamedCollection assignments() {
        if (this.fAssignments == null) {
            NameFunction nameFunction = new NameFunction(){

                public String nameof(Object object) {
                    return ((BasicAssignment)object).name();
                }
            };
            this.fAssignments = new NamedCollection(nameFunction);
        }
        return this.fAssignments;
    }

    public List children() {
        return this.assignments().toList();
    }

    public List columns() {
        return this.assignments().collect(new ColumnNameFunction());
    }

    public BasicAssignment createAssignment(RDBColumn rDBColumn) {
        return new BasicAssignment(rDBColumn);
    }

    public void doNotQualify() {
        Iterator iterator = this.assignments().iterator();
        while (iterator.hasNext()) {
            ((BasicAssignment)iterator.next()).doNotQualify();
        }
    }

    public void evaluateOn(StringBuffer stringBuffer) {
        Iterator iterator = this.assignments().iterator();
        stringBuffer.append(" SET ");
        while (iterator.hasNext()) {
            BasicAssignment basicAssignment = (BasicAssignment)iterator.next();
            basicAssignment.evaluateOn(stringBuffer);
            if (!iterator.hasNext()) continue;
            if (this.useExtraSpaces()) {
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append(" ");
        }
    }

    public void evaluateOn(StringBuffer stringBuffer, List list) {
        if (list.isEmpty()) {
            this.resetValues();
        } else {
            this.values(list);
        }
        this.evaluateOn(stringBuffer);
    }

    public void gatherVariableColumnsInOrderOn(List list) {
        Iterator iterator = this.assignments().iterator();
        while (iterator.hasNext()) {
            ((BasicAssignment)iterator.next()).gatherVariableColumnsInOrderOn(list);
        }
    }

    public void gatherVariablesInOrderOn(List list) {
        Iterator iterator = this.assignments().iterator();
        while (iterator.hasNext()) {
            ((BasicAssignment)iterator.next()).gatherVariablesInOrderOn(list);
        }
    }

    public boolean includesColumn(RDBColumn rDBColumn) {
        return this.assignments().includesName(rDBColumn.getName());
    }

    public boolean includesColumn(ColumnName columnName) {
        return this.assignments().includesName(columnName.columnName());
    }

    public Iterator iterator() {
        return this.columns().iterator();
    }

    public void printDetailOn(StringBuffer stringBuffer) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((BasicAssignment)iterator.next()).columnName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    public void resetValues() {
        Iterator iterator = this.assignments().iterator();
        while (iterator.hasNext()) {
            ((BasicAssignment)iterator.next()).resetValue();
        }
    }

    public List values() {
        return this.assignments().collect(new GetValueFunction());
    }

    public void values(List list) {
        this.assignments().applyWith(list, (TwoValuedFunction)new SetValueFunction());
    }

    public int assignmentSize() {
        return this.assignments().size();
    }

    private class SetValueFunction
    implements TwoValuedFunction {
        private SetValueFunction() {
        }

        public Object value(Object object, Object object2) {
            ((BasicAssignment)object).value(object2);
            return object;
        }
    }

    private class GetValueFunction
    implements Function {
        private GetValueFunction() {
        }

        public Object value(Object object) {
            return ((BasicAssignment)object).value();
        }
    }

    private class ColumnNameFunction
    implements Function {
        private ColumnNameFunction() {
        }

        public Object value(Object object) {
            return ((BasicAssignment)object).name();
        }
    }
}

