/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.MultiIterator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineInfo;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractNullCastSpec;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.AbstractSqlParseTreeNode;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ResultSetElement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Variable;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSqlStatement
extends AbstractSqlParseTreeNode {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Boolean useAliasesForSingleTableStmtsFlag;
    private int varCounter;
    private List fArgNamesAndColumns;

    public void doNoUseAliases() {
        this.useAliasesForSingleTableStmtsFlag = new Boolean(false);
    }

    public boolean isQualifyingColumnNames() {
        return QueryEngineInfo.singleton().useTableNameAsQualifier();
    }

    public boolean isQualifyingTableNames() {
        return QueryEngineInfo.singleton().useQualifiedTableNames();
    }

    public abstract boolean isSingleTable();

    public boolean isUsingAliases() {
        if (this.useAliasesForSingleTableStmtsFlag == null) {
            this.useAliasesForSingleTableStmtsFlag = new Boolean(QueryEngineInfo.singleton().useAliasesForSingleTableStmts());
        }
        return this.useAliasesForSingleTableStmtsFlag;
    }

    public void useAliases() {
        this.useAliasesForSingleTableStmtsFlag = new Boolean(true);
    }

    private int nextNumber() {
        return ++this.varCounter;
    }

    private String nextVariableName(ResultSetElement resultSetElement) {
        if (this.isUsingParmMarkers()) {
            return Variable.parmMarker();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.argIndicator());
        if (this.isUsingColumnNames()) {
            if (resultSetElement instanceof AbstractNullCastSpec) {
                stringBuffer.append(((AbstractNullCastSpec)resultSetElement).column().getName());
            } else {
                stringBuffer.append(((ColumnName)resultSetElement).name());
            }
        } else {
            stringBuffer.append(this.variablePrefix());
            stringBuffer.append(this.nextNumber());
        }
        return stringBuffer.toString();
    }

    private void resetVariableGeneration() {
        this.fArgNamesAndColumns = new ArrayList();
        this.varCounter = 0;
    }

    public void generateVariableNames() {
        this.resetVariableGeneration();
        List list = this.gatherVariablesInOrder();
        List list2 = this.gatherVariableColumnsInOrder();
        MultiIterator multiIterator = new MultiIterator(list, list2);
        while (multiIterator.hasNext()) {
            Object[] objectArray = (Object[])multiIterator.next();
            ResultSetElement resultSetElement = (ResultSetElement)objectArray[1];
            if (!(resultSetElement instanceof ColumnName) || !((ColumnName)resultSetElement).isIncludedInInput()) continue;
            String string = this.nextVariableName(resultSetElement);
            ((Variable)objectArray[0]).name(string);
            Object object = resultSetElement instanceof ColumnName ? ((ColumnName)resultSetElement).value() : resultSetElement.column();
            this.basicArgNamesAndColumns().add(new Association(object, string));
        }
    }

    public List argNamesAndColumns() {
        if (this.basicArgNamesAndColumns() == null) {
            this.generateVariableNames();
        }
        return this.basicArgNamesAndColumns();
    }

    public List basicArgNamesAndColumns() {
        return this.fArgNamesAndColumns;
    }

    public String argNameAt(int n) {
        if (this.isUsingParmMarkers()) {
            return Variable.parmMarker();
        }
        if (this.basicArgNamesAndColumns() == null) {
            this.generateVariableNames();
        }
        return (String)((Association)this.basicArgNamesAndColumns().get(n - 1)).value();
    }
}

