/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc.queryengine;

import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResultDescriptor;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectBuilder;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectStatementCreator;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBColumn;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.schema.RDBSchema;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.BasicPredicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.ColumnName;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Literal;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.Predicate;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SelectStatement;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.sqlquerytree.SqlStatement;

public class UniqueKeySelectBuilder
extends SelectBuilder {
    private Predicate fSearchCondition;

    public UniqueKeySelectBuilder() {
    }

    public UniqueKeySelectBuilder(Metadata metadata, RDBSchema rDBSchema) throws QueryEngineException {
        this.setMetadata(metadata);
        this.setSchema(rDBSchema);
        this.initialize();
    }

    public UniqueKeySelectBuilder(Metadata metadata) throws QueryEngineException {
        this(metadata, new RDBSchema(metadata));
    }

    public SqlStatement defaultStatement() throws QueryEngineException {
        SelectStatementCreator selectStatementCreator = new SelectStatementCreator();
        selectStatementCreator.setSingle();
        selectStatementCreator.resultColumns(this.resultDescriptor().resultSetElements());
        if (this.searchCondition() != null) {
            selectStatementCreator.extraSearchCondition(this.searchCondition());
        }
        selectStatementCreator.forUpdate();
        SelectStatement selectStatement = selectStatementCreator.build();
        return selectStatement;
    }

    public void initialize() throws QueryEngineException {
        ColumnName columnName = new ColumnName((RDBColumn)this.getSchema().uniqueKeyTable().getPrimaryKey().getMembers().get(0));
        Literal literal = new Literal(new Integer(1));
        this.searchCondition(BasicPredicate.equality(columnName, literal));
        super.initialize();
    }

    public void searchCondition(Predicate predicate) {
        this.fSearchCondition = predicate;
    }

    public Predicate searchCondition() {
        return this.fSearchCondition;
    }

    public QueryResultDescriptor createResultDescriptor() {
        return new QueryResultDescriptor(this.getSchema().uniqueKeyTable());
    }
}

