/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.OCCException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.GraphChange;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.GraphBuilderUtil;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResult;
import commonj.sdo.DataObject;
import java.sql.ResultSet;
import java.util.List;

public class Update
extends GraphChange {
    DataObject copy;
    List changes;

    public Update(Metadata metadata, QueryEngine queryEngine, DataObject dataObject) {
        super(metadata, queryEngine, dataObject);
    }

    public void applyChange() throws DBException {
        QueryResult queryResult = this.queryEngine.executeUpdate(this.dataObject);
        this.checkException(queryResult, "update");
        if (this.isOptimisicCollsion(queryResult)) {
            throw new OCCException(this.originalCopyFor(this.dataObject), this.dataObject, this.dbVersion());
        }
    }

    public boolean isInsert() {
        return false;
    }

    public boolean isUpdate() {
        return true;
    }

    public boolean isDelete() {
        return false;
    }

    private boolean isOptimisicCollsion(QueryResult queryResult) {
        return queryResult.rowsAffected() < 1;
    }

    private DataObject dbVersion() throws DBException {
        QueryResult queryResult = this.queryEngine.executeFindByPrimaryKeyOn(this.dataObject);
        this.checkException(queryResult, "FindByPrimaryKeyOn");
        ResultSet resultSet = (ResultSet)queryResult.getResults().get(0);
        DataObject dataObject = null;
        try {
            dataObject = GraphBuilderUtil.createIsolatedDataObject(this.metadata, this.dataObject, resultSet);
        }
        catch (JDBCMediatorException jDBCMediatorException) {
            this.ffdcFilter(jDBCMediatorException, "applyChange", "1");
            throw new Error("Exception when building DO: " + jDBCMediatorException);
        }
        return dataObject;
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, (String)stringBuffer.toString(), (String)string2, (Object)this);
    }
}

