/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.JDBCMediator;
import com.ibm.websphere.sdo.mediator.ResultSetInfo;
import com.ibm.websphere.sdo.mediator.exception.MediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.ConnectionWrapper;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.InvalidMetadataException;
import com.ibm.websphere.sdo.mediator.jdbc.exception.JDBCMediatorException;
import com.ibm.websphere.sdo.mediator.jdbc.metadata.Metadata;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl;
import com.ibm.ws.sdo.mediator.jdbc.GraphChanges;
import com.ibm.ws.sdo.mediator.jdbc.UniqueKeys;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.PagedGraphInfo;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.RelationalGraphBuilder;
import com.ibm.ws.sdo.mediator.jdbc.graphbuilder.RelationalGraphBuilderFactory;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngine;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineException;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryEngineFactoryImpl;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryResult;
import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public class MediatorImpl
implements JDBCMediator {
    private EClass suppliedSchema;
    private String suppliedQuery;
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$sdo$mediator$jdbc$MediatorImpl == null ? (class$com$ibm$ws$sdo$mediator$jdbc$MediatorImpl = MediatorImpl.class$("com.ibm.ws.sdo.mediator.jdbc.MediatorImpl")) : class$com$ibm$ws$sdo$mediator$jdbc$MediatorImpl), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private QueryEngine queryEngine;
    private Metadata metadata;
    private RelationalGraphBuilder graphBuilder;
    private ConnectionWrapperImpl connectionWrapper;
    private int pageSize;
    private UniqueKeys uniqueKeys;
    private ResultSetInfo resultSetInfo;
    static /* synthetic */ Class class$com$ibm$ws$sdo$mediator$jdbc$MediatorImpl;

    public MediatorImpl(Metadata metadata, ConnectionWrapper connectionWrapper) {
        this.metadata = metadata;
        this.connectionWrapper = (ConnectionWrapperImpl)connectionWrapper;
        this.initialize();
    }

    public MediatorImpl(Metadata metadata, EClass eClass, String string, ConnectionWrapper connectionWrapper) {
        this(metadata, connectionWrapper);
        this.suppliedSchema = eClass;
        this.suppliedQuery = string;
    }

    public MediatorImpl(Metadata metadata, String string, ConnectionWrapper connectionWrapper) {
        this(metadata, connectionWrapper);
        this.suppliedQuery = string;
    }

    public MediatorImpl(Metadata metadata, EClass eClass, ConnectionWrapper connectionWrapper) {
        this(metadata, connectionWrapper);
        this.suppliedSchema = eClass;
    }

    private void initialize() {
        QueryEngineFactoryImpl queryEngineFactoryImpl = QueryEngineFactoryImpl.soleInstance();
        if (!this.connectionWrapper.isNullWrapper()) {
            this.queryEngine = queryEngineFactoryImpl.createQueryEngine(this.metadata, this, this.connectionWrapper.getDBType());
        }
        this.pageSize = 0;
    }

    public void applyChanges(boolean bl, DataObject dataObject) throws JDBCMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"applyChanges");
        }
        this.applyChanges(bl, dataObject.getDataGraph().getChangeSummary());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"applyChanges");
        }
    }

    public void applyChanges(DataObject dataObject) throws JDBCMediatorException {
        this.applyChanges(true, dataObject);
    }

    public void applyChanges(boolean bl, ChangeSummary changeSummary) throws JDBCMediatorException {
        GraphChanges graphChanges = new GraphChanges(this.metadata, this.queryEngine, changeSummary, bl);
        try {
            this.connectionWrapper.start();
            graphChanges.applyChanges();
            this.connectionWrapper.commit();
            changeSummary.getChangedDataObjects().clear();
        }
        catch (DBException dBException) {
            Tr.debug((TraceComponent)tc, (String)"DBException: {0}", (Object)dBException);
            this.ffdcFilter(dBException, "applyChanges", "1");
            this.connectionWrapper.rollback();
            throw dBException;
        }
    }

    public DataObject getGraph(DataObject dataObject) throws MediatorException {
        if (this.suppliedQuery == null) {
            return this.getGraph((Map)dataObject);
        }
        try {
            if (this.resultSetInfo != null) {
                this.graphBuilder().setResultSetInfo(this.resultSetInfo);
            }
            return this.graphBuilder().graph(this.getResultSets(dataObject));
        }
        catch (SQLException sQLException) {
            Tr.error((TraceComponent)tc, (String)"SQL Exception: {0}", (Object)sQLException);
            sQLException.printStackTrace();
            throw new JDBCMediatorException("SQL Exception", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject getGraph(Map map) throws JDBCMediatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGraph", (Object)new Object[]{map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelect(map);
            this.checkException(queryResult, "select");
            DataObject dataObject = this.graphBuilder().graph(queryResult.getResults(), queryResult.getResultDescriptors());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGraph");
            }
            DataObject dataObject2 = dataObject;
            return dataObject2;
        }
        finally {
            this.cleanup(queryResult);
        }
    }

    private DataObject getRoot() throws JDBCMediatorException {
        try {
            if (this.resultSetInfo != null) {
                this.graphBuilder().setResultSetInfo(this.resultSetInfo);
            }
            DataObject dataObject = this.graphBuilder().graph(this.getResultSets());
            return dataObject;
        }
        catch (SQLException sQLException) {
            throw new JDBCMediatorException("SQL Exception", sQLException);
        }
    }

    private List getResultSets() throws SQLException {
        return Collections.singletonList(this.connectionWrapper.executeDirectQuery(this.suppliedQuery));
    }

    private List getResultSets(DataObject dataObject) throws SQLException {
        return Collections.singletonList(this.connectionWrapper.executeDirectQuery(this.suppliedQuery, dataObject));
    }

    public DataObject getGraph() throws JDBCMediatorException {
        if (this.suppliedQuery != null) {
            return this.getRoot();
        }
        return this.getGraph(Collections.EMPTY_MAP);
    }

    public DataObject getEmptyGraph() throws JDBCMediatorException {
        return this.graphBuilder().emptyGraph();
    }

    public EClass getSchema() throws JDBCMediatorException {
        return this.graphBuilder().schema();
    }

    public long getKey() throws MediatorException {
        return this.uniqueKeys().getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PagedGraphInfo nextPage(int n, Map map) throws JDBCMediatorException {
        PagedGraphInfo pagedGraphInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextPage", (Object)new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "select");
            PagedGraphInfo pagedGraphInfo2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"nextPage");
            }
            pagedGraphInfo = pagedGraphInfo2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return pagedGraphInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject nextGenericPage(int n, Map map) throws JDBCMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextGenericPage", (Object)new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "nextGenericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"nextGenericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject genericPage(int n, Map map) throws JDBCMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"genericPage", (Object)new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectNextPage(map, n);
            this.checkException(queryResult, "genericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"genericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataObject previousGenericPage(int n, Map map) throws JDBCMediatorException {
        DataObject dataObject;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"previousGenericPage", (Object)new Object[]{new Integer(n), map});
        }
        QueryResult queryResult = null;
        try {
            queryResult = this.queryEngine.executeSelectPreviousPage(map, n);
            this.checkException(queryResult, "previousGenericPage");
            DataObject dataObject2 = this.graphBuilder().pagedGraph(queryResult.getResults(), queryResult.getResultDescriptors(), this.pageSize);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"previousGenericPage");
            }
            dataObject = dataObject2;
        }
        catch (Throwable throwable) {
            this.cleanup(queryResult);
            throw throwable;
        }
        this.cleanup(queryResult);
        return dataObject;
    }

    private UniqueKeys uniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new UniqueKeys(this, this.metadata);
        }
        return this.uniqueKeys;
    }

    protected void setPageSize(int n) {
        this.pageSize = n;
        this.queryEngine.setPageSize(n);
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    private RelationalGraphBuilder graphBuilder() throws InvalidMetadataException {
        if (this.graphBuilder == null) {
            this.graphBuilder = RelationalGraphBuilderFactory.getRelationalGraphBuilder(this.metadata, this.suppliedSchema);
        }
        return this.graphBuilder;
    }

    private void cleanup(QueryResult queryResult) throws DBException {
        try {
            this.connectionWrapper.commit();
            if (queryResult != null) {
                queryResult.discard();
            }
        }
        catch (QueryEngineException queryEngineException) {
            this.ffdcFilter(queryEngineException, "cleanup", "2");
            throw new DBException("Error in finally:QE: " + queryEngineException, queryEngineException);
        }
    }

    private void checkException(QueryResult queryResult, String string) throws DBException {
        if (queryResult.hasException()) {
            QueryEngineException queryEngineException = queryResult.getException();
            throw new DBException("QE " + string + ":" + queryEngineException, queryEngineException);
        }
    }

    public void setConnectionWrapper(ConnectionWrapper connectionWrapper) {
        this.connectionWrapper = (ConnectionWrapperImpl)connectionWrapper;
    }

    public ConnectionWrapper getConnectionWrapper() {
        return this.connectionWrapper;
    }

    protected QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, (String)stringBuffer.toString(), (String)string2, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rowCount(Map map) throws DBException {
        try {
            long l = this.queryEngine.executeCount(map);
            return l;
        }
        finally {
            this.connectionWrapper.commit();
        }
    }

    public DataObject getParameterDataObject() throws InvalidMetadataException {
        if (this.suppliedQuery == null) {
            return this.graphBuilder().getParameterDataObject();
        }
        return this.graphBuilder().getParameterDataObject(this.suppliedQuery);
    }

    public void setResultSetInfo(ResultSetInfo resultSetInfo) throws MediatorException {
        this.resultSetInfo = resultSetInfo;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

