/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.mediator.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sdo.mediator.jdbc.ConnectionWrapper;
import com.ibm.websphere.sdo.mediator.jdbc.exception.DBException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.mediator.jdbc.JDBCAdapter;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.QueryPredicates;
import com.ibm.ws.sdo.mediator.jdbc.queryengine.SelectPredicates;
import commonj.sdo.DataObject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionWrapperImpl
implements ConnectionWrapper {
    protected static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$sdo$mediator$jdbc$ConnectionWrapperImpl == null ? (class$com$ibm$ws$sdo$mediator$jdbc$ConnectionWrapperImpl = ConnectionWrapperImpl.class$("com.ibm.ws.sdo.mediator.jdbc.ConnectionWrapperImpl")) : class$com$ibm$ws$sdo$mediator$jdbc$ConnectionWrapperImpl), (String)"JDBCMediator", (String)"jdbcmediator.properties");
    private static Map dbTypes;
    private String dbType;
    private Connection connection;
    private boolean managesTx;
    private final JDBCAdapter adapter;
    static /* synthetic */ Class class$com$ibm$ws$sdo$mediator$jdbc$ConnectionWrapperImpl;

    private static Map getDbTypes() {
        if (dbTypes == null) {
            ConnectionWrapperImpl.initializeDBTypes();
        }
        return dbTypes;
    }

    private static void initializeDBTypes() {
        dbTypes = new HashMap();
        dbTypes.put("DB2", "DB2UDBNT_V8");
        dbTypes.put("DBMS:db2j", "CLOUDSCAPE_V50");
        dbTypes.put("Cloudscape", "CLOUDSCAPE_V50");
        dbTypes.put("Apache Derby", "CLOUDSCAPE_V50");
        dbTypes.put("Microsoft SQL Server", "MSSQLSERVER_2000");
        dbTypes.put("Oracle", "ORACLE_V9");
        dbTypes.put("Informix Dynamic Server", "INFORMIX_V94");
        dbTypes.put("DSN", "DB2UDBOS390_V7");
        dbTypes.put("DSN07010", "DB2UDBOS390_V7");
        dbTypes.put("Sybase SQL Server", "SYBASE_V12");
        dbTypes.put("Adaptive Server Enterprise", "SYBASE_V12");
        dbTypes.put("default", "DB2UDBNT_V8");
    }

    public ConnectionWrapperImpl(Connection connection) {
        this.connection = connection;
        this.managesTx = true;
        this.adapter = new JDBCAdapter(this);
    }

    public boolean managesTx() {
        return this.managesTx;
    }

    public void manageTx() {
        this.managesTx = true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void tearDown() {
        this.connection = null;
    }

    public void commit() throws DBException {
        if (this.managesTx) {
            try {
                this.connection.commit();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl.start()", (String)"1", (Object)this);
                throw new DBException("Exception when commiting" + sQLException, sQLException);
            }
        }
    }

    public void rollback() throws DBException {
        if (this.managesTx) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl.rollback()", (String)"2", (Object)this);
                throw new DBException("Exception when rolling back" + sQLException, sQLException);
            }
        }
    }

    public void start() throws DBException {
        if (this.managesTx) {
            try {
                boolean bl = this.connection.getAutoCommit();
                if (bl) {
                    throw new DBException("AutoCommit is true but Mediator requires it to be false");
                }
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.wdo.mediator.rdb.ConnectionWrapperImpl.start()", (String)"3", (Object)this);
                throw new DBException("Could not getAutoCommit()" + sQLException, sQLException);
            }
        }
    }

    public boolean isNullWrapper() {
        return false;
    }

    public void dontManageTransaction() {
        this.managesTx = false;
    }

    public void discardResultSet(ResultSet resultSet) throws SQLException {
        this.adapter.discardResultSet(resultSet);
    }

    public int executeUpdate(String string, QueryPredicates queryPredicates) throws SQLException {
        return this.adapter.executeUpdate(string, queryPredicates);
    }

    public ResultSet executeSelect(String string, SelectPredicates selectPredicates) throws SQLException {
        return this.adapter.executeSelect(string, selectPredicates);
    }

    public ResultSet executeDirectQuery(String string) throws SQLException {
        return this.adapter.executeDirectQuery(string);
    }

    public ResultSet executeDirectQuery(String string, DataObject dataObject) throws SQLException {
        return this.adapter.executeDirectquery(string, dataObject);
    }

    public int executeDirectUpdate(String string) throws SQLException {
        return this.adapter.executeDirectUpdate(string);
    }

    public String getDBType() {
        if (this.dbType == null) {
            try {
                this.initializeDbType();
            }
            catch (DBException dBException) {
                Tr.error((TraceComponent)tc, (String)"Could not determine database type: {0}", (Object)dBException);
            }
        }
        return this.dbType;
    }

    private void initializeDbType() throws DBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeDbType");
        }
        String string = null;
        String string2 = null;
        try {
            DatabaseMetaData databaseMetaData = this.connection.getMetaData();
            string2 = databaseMetaData.getDatabaseProductName();
            string = string2.startsWith("DB2") ? "DB2" : (string2.startsWith("DSN") ? "DSN07010" : string2);
        }
        catch (SQLException sQLException) {
            this.ffdcFilter(sQLException, "getDBType", "1");
            throw new DBException("Unable to retrieve Product or version name");
        }
        if (!ConnectionWrapperImpl.getDbTypes().containsKey(string)) {
            throw new DBException("Not a recognized database type => " + string2);
        }
        this.dbType = (String)ConnectionWrapperImpl.getDbTypes().get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDbType", (Object)new Object[]{string2, this.dbType});
        }
    }

    private void ffdcFilter(Exception exception, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(".").append(string);
        FFDCFilter.processException((Throwable)exception, (String)stringBuffer.toString(), (String)string2, (Object)this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ConnectionWrapperImpl.initializeDBTypes();
    }
}

