/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import java.util.ArrayList;
import java.util.List;

public class VapStringReader {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Object lock;
    private String str = new String();
    private int length;
    private int next = 0;

    protected VapStringReader() {
        this.lock = this;
    }

    public VapStringReader(String string) {
        this.lock = this;
        if (string == null) {
            this.length = 0;
            return;
        }
        this.str = string;
        this.length = string.length();
    }

    public List asBlankDelimitedSubstrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.skipSpaces();
        while (!this.atEnd()) {
            arrayList.add(this.gatherUntil(' '));
            this.skipSpaces();
        }
        return arrayList;
    }

    public List asDelimitedSubstrings(char[] cArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.skipChar(cArray);
        while (!this.atEnd()) {
            arrayList.add(this.gatherUntil(cArray));
            this.skipChar(cArray);
        }
        return arrayList;
    }

    public List asDelimitedSubstrings(char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.skipChar(c);
        while (!this.atEnd()) {
            arrayList.add(this.gatherUntil(c));
            this.skipChar(c);
        }
        return arrayList;
    }

    public boolean atEnd() {
        if (this.str.length() == 0) {
            return true;
        }
        int n = this.read();
        if (n != -1) {
            this.backup();
        }
        return n == -1;
    }

    public long backup() {
        return this.skip(-1L);
    }

    public long backup(int n) {
        return this.skip(-1 * n);
    }

    public void close() {
        this.str = null;
        this.reset();
    }

    public String gatherUntil(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char c = this.next();
            if (this.isOneOf(c, cArray)) {
                --this.next;
                return stringBuffer.toString();
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String gatherUntil(String string) {
        return this.gatherUntil(string.toCharArray());
    }

    public String gatherUntil(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char c2 = this.next();
            if (c2 == c) {
                --this.next;
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public boolean hasNext() {
        return !this.atEnd();
    }

    public boolean isOneOf(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return true;
        }
        return false;
    }

    public char next() {
        int n = this.read();
        if (n == -1) {
            throw new RuntimeException("reading beyond end of string");
        }
        return (char)n;
    }

    public String next(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = this.read();
            if (n2 == -1) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public String nextAlphaNumeric() {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char c = this.next();
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            this.backup();
            break;
        }
        return stringBuffer.toString();
    }

    public String nextBalancedChunkFrom(char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        if (this.peek() != c) {
            throw new RuntimeException("unexpected token");
        }
        stringBuffer.append(this.next());
        int n = 1;
        while (n != 0) {
            if (this.atEnd()) {
                throw new RuntimeException("unbalanced parens");
            }
            char c3 = this.next();
            if (c3 == c2) {
                --n;
            }
            if (c3 == c) {
                ++n;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public String nextDoubleQuotedChunk() {
        char c = '\"';
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        if (this.peek() != c) {
            throw new RuntimeException("unexpected token");
        }
        stringBuffer.append(this.next());
        boolean bl = false;
        while (!bl) {
            if (this.atEnd()) {
                throw new RuntimeException("unbalanced quotes");
            }
            char c2 = this.next();
            if (c2 == c) {
                if (this.atEnd()) {
                    bl = true;
                } else if (this.peek() == c) {
                    stringBuffer.append(this.next());
                } else {
                    bl = true;
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public Object nextElement() {
        return new Character(this.next());
    }

    public String nextHostVarChar() {
        String string = "@_!.?$";
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char c = this.next();
            if (Character.isLetterOrDigit(c) || string.indexOf(c) > -1) {
                stringBuffer.append(c);
                continue;
            }
            this.backup();
            break;
        }
        return stringBuffer.toString();
    }

    public int occurrencesOf(char c) {
        int n = 0;
        while (this.hasNext()) {
            if (this.next() != c) continue;
            ++n;
        }
        return n;
    }

    public char peek() {
        int n = this.read();
        if (n == -1) {
            throw new RuntimeException("peeking beyond end of string");
        }
        this.backup();
        return (char)n;
    }

    public String peek(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n && (n2 = this.read()) != -1; ++i) {
            stringBuffer.append((char)n2);
        }
        this.backup(stringBuffer.length());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return -1;
            }
            int n3 = Math.min(this.length - this.next, n2);
            this.str.getChars(this.next, this.next + n3, cArray, n);
            this.next += n3;
            return n3;
        }
    }

    public void remove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.next = 0;
        }
    }

    public long skip() {
        return this.skip(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) {
        Object object = this.lock;
        synchronized (object) {
            if (l > 0L && this.next >= this.length) {
                return 0L;
            }
            long l2 = Math.min((long)(this.length - this.next), l);
            int n = this.next;
            this.next = (int)((long)this.next + l2);
            if (this.next < 0) {
                this.next = 0;
                return n;
            }
            return l2;
        }
    }

    public void skipChar(char[] cArray) {
        while (!this.atEnd()) {
            if (this.isOneOf(this.next(), cArray)) continue;
            --this.next;
            return;
        }
    }

    public void skipChar(String string) {
        this.skipChar(string.toCharArray());
    }

    public void skipChar(char c) {
        while (!this.atEnd()) {
            if (c == this.next()) continue;
            --this.next;
            return;
        }
    }

    public void skipSpaces() {
        while (!this.atEnd()) {
            if (Character.isSpaceChar(this.next())) continue;
            --this.next;
            return;
        }
    }

    public int skipUpTo(char c) {
        int n = 0;
        while (!this.atEnd()) {
            char c2 = this.next();
            if (c2 == c) {
                this.backup();
                break;
            }
            ++n;
        }
        return n;
    }

    public String upTo(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char c2 = this.next();
            if (c2 == c) {
                this.backup();
                break;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String upToEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.atEnd()) {
            stringBuffer.append(this.next());
        }
        return stringBuffer.toString();
    }
}

