/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.OutputDevice;
import com.ibm.ObjectQuery.crud.util.Printable;
import com.ibm.ObjectQuery.crud.util.TraceBuffer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;

public class Trace {
    private static Trace soleInstance = new Trace();
    private int level = 0;
    private boolean logFlag = false;
    private boolean includeThreadFlag = false;
    private Vector queryLog = new Vector();
    private Printable out = new OutputDevice();
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999";

    public void basicLog(Object object) {
        if (this.isLoggingOn() && object != null) {
            this.getQueryLog().addElement(object);
        }
    }

    public int basicLogSize() {
        return this.getQueryLog().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow() {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.getOut().println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                stringBuffer.append(string);
                stringBuffer.append("[");
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(fArray[i]);
                    if (i == n - 1) {
                        stringBuffer.append("]");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
                this.getOut().println(stringBuffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                stringBuffer.append(string);
                stringBuffer.append("[");
                int n = nArray == null ? 0 : nArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(nArray[i]);
                    if (i == n - 1) continue;
                    stringBuffer.append(" ");
                }
                stringBuffer.append("]");
                this.getOut().println(stringBuffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                stringBuffer.append(string);
                stringBuffer.append("[");
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(lArray[i]);
                    if (i == n - 1) {
                        stringBuffer.append("]");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
                this.getOut().println(stringBuffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                stringBuffer.append(string);
                stringBuffer.append("[");
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (objectArray[i] == null) {
                        stringBuffer.append("null");
                    } else {
                        stringBuffer.append(objectArray[i].toString());
                    }
                    if (i == n - 1) {
                        stringBuffer.append("]");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
                this.getOut().println(stringBuffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                stringBuffer.append(string);
                stringBuffer.append("[");
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(blArray[i]);
                    if (i == n - 1) {
                        stringBuffer.append("]");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
                this.getOut().println(stringBuffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, Object object) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                this.getOut().print(string);
                if (object == null) {
                    this.getOut().println("null");
                } else {
                    this.getOut().println(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShow(String string, Enumeration enumeration) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                this.getOut().println(string);
                while (enumeration.hasMoreElements()) {
                    this.getOut().println(enumeration.nextElement().toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicShowException(Throwable throwable, Object object, String string, boolean bl) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printThread();
                StringBuffer stringBuffer = this.getExceptionOccurredBuffer();
                if (object != null) {
                    stringBuffer.append(ClassShortName.name(object));
                }
                stringBuffer.append(">>");
                if (string == null) {
                    stringBuffer.append("<unknown method>");
                } else {
                    stringBuffer.append(string);
                }
                this.basicShowException(throwable, stringBuffer, bl);
            }
        }
    }

    private void basicShowException(Throwable throwable, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = stringBuffer == null ? this.getExceptionOccurredBuffer() : stringBuffer;
        stringBuffer2.append(" ");
        if (throwable == null) {
            stringBuffer2.append("<unknown error>");
        } else {
            stringBuffer2.append(throwable.getMessage());
        }
        this.getOut().println(stringBuffer2.toString());
        if (bl) {
            this.dumpStack(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShowLine() {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.getOut().println("_________________________________________________________");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShowSection(String string) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.printSection(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicShowStack(Exception exception) {
        if (this.isTraceOn()) {
            Trace trace = this;
            synchronized (trace) {
                this.dumpStack(exception);
            }
        }
    }

    public void basicShowWithClass(String string, Object object, Object object2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(object));
        stringBuffer.append(": ");
        stringBuffer.append(string);
        Trace.getTrace().basicShow(stringBuffer.toString(), object2 == null ? "" : object);
    }

    public void basicStartLog() {
        this.logFlagOn();
        this.resetQueryLog();
    }

    public void basicStopLog() {
        this.logFlagOff();
        this.resetQueryLog();
    }

    public void clearLog() {
        this.resetQueryLog();
    }

    public static void close() {
        if (Trace.getTrace().isUsingBuffer()) {
            Trace.getTrace().closeOut();
            return;
        }
        if (!Trace.getTrace().isUsingSystemOut()) {
            Trace.getTrace().closeOut();
        }
    }

    public void closeOut() {
        this.getOut().close();
    }

    public static void doNotIncludeThread() {
        Trace.getTrace().doNotIncludeThreadInTrace();
    }

    public void doNotIncludeThreadInTrace() {
        this.includeThreadFlag = false;
    }

    private void dumpStack(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        this.getOut().println(stringWriter.toString());
    }

    public static void error() {
        throw new RuntimeException();
    }

    public static void error(String string) {
        throw new RuntimeException(string);
    }

    private StringBuffer getExceptionOccurredBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXCEPTION OCCURRED => ");
        return stringBuffer;
    }

    private int getLevel() {
        return this.level;
    }

    private boolean getLogFlag() {
        return this.logFlag;
    }

    public Printable getOut() {
        return this.out;
    }

    public Vector getQueryLog() {
        if (this.queryLog == null) {
            this.queryLog = new Vector();
        }
        return this.queryLog;
    }

    protected String getThreadName() {
        Thread thread = Thread.currentThread();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(thread.getName());
        stringBuffer.append("-");
        stringBuffer.append(thread.getPriority());
        if (thread.getThreadGroup() != null) {
            stringBuffer.append("-");
            stringBuffer.append(thread.getThreadGroup().getName());
        }
        stringBuffer.append(" <hc ");
        stringBuffer.append(thread.hashCode());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static synchronized Trace getTrace() {
        if (soleInstance == null) {
            soleInstance = new Trace();
        }
        return soleInstance;
    }

    public static int getTraceLevel() {
        return Trace.getTrace().getLevel();
    }

    public static void halt() {
        throw new RuntimeException("halting");
    }

    public static void includeThread() {
        Trace.getTrace().includeThreadInTrace();
    }

    public void includeThreadInTrace() {
        this.includeThreadFlag = true;
    }

    public boolean isIncludingThreadInTrace() {
        return this.includeThreadFlag;
    }

    public static boolean isLevelOne() {
        return Trace.getTrace().getLevel() >= 1;
    }

    public static boolean isLevelThree() {
        return Trace.getTrace().getLevel() >= 3;
    }

    public static boolean isLevelTwo() {
        return Trace.getTrace().getLevel() >= 2;
    }

    public boolean isLoggingOn() {
        return this.getLogFlag();
    }

    public static boolean isOn() {
        return Trace.getTrace().isTraceOn();
    }

    public boolean isTraceOn() {
        return this.getLevel() > 0;
    }

    public boolean isUsingBuffer() {
        return this.getOut() instanceof TraceBuffer;
    }

    public boolean isUsingSystemOut() {
        return this.getOut().isUsingSystemOut();
    }

    public void levelOne() {
        this.setLevel(1);
    }

    public void levelThree() {
        this.setLevel(3);
    }

    public void levelTwo() {
        this.setLevel(2);
    }

    public static void log(Object object) {
        Trace.getTrace().basicLog(object);
    }

    public void logFlagOff() {
        this.setLogFlag(false);
    }

    public void logFlagOn() {
        this.setLogFlag(true);
    }

    public static int logSize() {
        return Trace.getTrace().basicLogSize();
    }

    public static void main(String[] stringArray) {
        if (stringArray[0].equalsIgnoreCase("on")) {
            Trace.traceOn();
            Trace.show("trace_is_now_on");
        } else {
            Trace.show("turning_trace_off");
            Trace.traceOff();
        }
    }

    public void noTrace() {
        this.setLevel(0);
    }

    public static void openTraceFile(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Trace.getTrace().setOut(fileOutputStream);
    }

    public void printSection(String string) {
        int n;
        String string2 = string == null ? "" : string;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = (80 - string2.length()) / 2;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("=");
        }
        stringBuffer.append(string2);
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("=");
        }
        this.getOut().println(stringBuffer.toString());
    }

    public void printThread() {
        if (!this.isIncludingThreadInTrace()) {
            return;
        }
        Thread thread = Thread.currentThread();
        this.getOut().print("[");
        this.getOut().print(thread);
        this.getOut().print(" <");
        this.getOut().print(thread.hashCode());
        this.getOut().print(">] ");
    }

    public static void reset() {
        Trace.close();
        soleInstance = null;
    }

    private void resetQueryLog() {
        this.queryLog = null;
    }

    private void setLevel(int n) {
        this.level = n;
    }

    private void setLogFlag(boolean bl) {
        this.logFlag = bl;
    }

    public void setOut(Printable printable) {
        this.out = printable;
    }

    public void setOut(FileOutputStream fileOutputStream) {
        this.out = new OutputDevice(fileOutputStream);
    }

    public void setOut(PrintStream printStream) {
        this.out = new OutputDevice(printStream);
    }

    public void setOut(StringBuffer stringBuffer) {
        this.out = new OutputDevice(stringBuffer);
    }

    public void setToSystemOut() {
        this.setOut(System.out);
    }

    public void setToTraceBuffer() {
        this.setOut(new TraceBuffer());
    }

    public void setToTraceBuffer(FileOutputStream fileOutputStream) {
        this.setOut(new TraceBuffer(fileOutputStream));
    }

    public void setToTraceBuffer(PrintStream printStream) {
        this.setOut(new TraceBuffer(printStream));
    }

    public void setToTraceBuffer(StringBuffer stringBuffer) {
        this.setOut(new TraceBuffer(stringBuffer));
    }

    public void setTraceOff() {
        this.setLevel(0);
    }

    public void setTraceOn() {
        this.setLevel(1);
    }

    public static void show() {
        Trace.getTrace().basicShow();
    }

    public static void show(byte[] byArray) {
        Trace.getTrace().basicShow("", (Object)byArray);
    }

    public static void show(byte[] byArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", (Object)byArray);
        }
    }

    public static void show(char[] cArray) {
        Trace.getTrace().basicShow("", (Object)cArray);
    }

    public static void show(char[] cArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", (Object)cArray);
        }
    }

    public static void show(double[] dArray) {
        Trace.getTrace().basicShow("", (Object)dArray);
    }

    public static void show(double[] dArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", (Object)dArray);
        }
    }

    public static void show(float[] fArray) {
        Trace.getTrace().basicShow("", fArray);
    }

    public static void show(float[] fArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", fArray);
        }
    }

    public static void show(int[] nArray) {
        Trace.getTrace().basicShow("", nArray);
    }

    public static void show(int[] nArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", nArray);
        }
    }

    public static void show(long[] lArray) {
        Trace.getTrace().basicShow("", lArray);
    }

    public static void show(long[] lArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", lArray);
        }
    }

    public static void show(Object[] objectArray) {
        Trace.getTrace().basicShow("", objectArray);
    }

    public static void show(Object[] objectArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", objectArray);
        }
    }

    public static void show(char c) {
        Trace.getTrace().basicShow("", new Character(c));
    }

    public static void show(char c, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", new Character(c));
        }
    }

    public static void show(double d) {
        Trace.getTrace().basicShow("", new Double(d));
    }

    public static void show(double d, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", new Double(d));
        }
    }

    public static void show(float f) {
        Trace.getTrace().basicShow("", new Float(f));
    }

    public static void show(float f, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", new Float(f));
        }
    }

    public static void show(int n) {
        Trace.getTrace().basicShow("", new Integer(n));
    }

    public static void show(int n, int n2) {
        if (Trace.getTrace().getLevel() >= n2) {
            Trace.getTrace().basicShow("", new Integer(n));
        }
    }

    public static void show(long l) {
        Trace.getTrace().basicShow("", new Long(l));
    }

    public static void show(long l, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", new Long(l));
        }
    }

    public static void show(Exception exception) {
        Trace.showException(exception, null, null, false);
    }

    public static void show(Object object) {
        Trace.getTrace().basicShow("", object);
    }

    public static void show(Object object, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", object);
        }
    }

    public static void show(String string, byte[] byArray) {
        Trace.getTrace().basicShow(string, (Object)byArray);
    }

    public static void show(String string, byte[] byArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, (Object)byArray);
        }
    }

    public static void show(String string, char[] cArray) {
        Trace.getTrace().basicShow(string, (Object)cArray);
    }

    public static void show(String string, char[] cArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, (Object)cArray);
        }
    }

    public static void show(String string, double[] dArray) {
        Trace.getTrace().basicShow(string, (Object)dArray);
    }

    public static void show(String string, double[] dArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, (Object)dArray);
        }
    }

    public static void show(String string, float[] fArray) {
        Trace.getTrace().basicShow(string, fArray);
    }

    public static void show(String string, float[] fArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, fArray);
        }
    }

    public static void show(String string, int[] nArray) {
        Trace.getTrace().basicShow(string, nArray);
    }

    public static void show(String string, int[] nArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, nArray);
        }
    }

    public static void show(String string, long[] lArray) {
        Trace.getTrace().basicShow(string, lArray);
    }

    public static void show(String string, long[] lArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, lArray);
        }
    }

    public static void show(String string, Object[] objectArray) {
        Trace.getTrace().basicShow(string, objectArray);
    }

    public static void show(String string, Object[] objectArray, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, objectArray);
        }
    }

    public static void show(String string, char c) {
        Trace.getTrace().basicShow(string, new Character(c));
    }

    public static void show(String string, char c, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, new Character(c));
        }
    }

    public static void show(String string, double d) {
        Trace.getTrace().basicShow(string, new Double(d));
    }

    public static void show(String string, double d, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, new Double(d));
        }
    }

    public static void show(String string, float f) {
        Trace.getTrace().basicShow(string, new Float(f));
    }

    public static void show(String string, float f, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, new Float(f));
        }
    }

    public static void show(String string, int n) {
        Trace.getTrace().basicShow(string, new Integer(n));
    }

    public static void show(String string, int n, int n2) {
        if (Trace.getTrace().getLevel() >= n2) {
            Trace.getTrace().basicShow(string, new Integer(n));
        }
    }

    public static void show(String string, long l) {
        Trace.getTrace().basicShow(string, new Long(l));
    }

    public static void show(String string, long l, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, new Long(l));
        }
    }

    public static void show(String string, Object object) {
        Trace.getTrace().basicShow(string, object);
    }

    public static void show(String string, Object object, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, object);
        }
    }

    public static void show(String string, Enumeration enumeration) {
        Trace.getTrace().basicShow(string, enumeration);
    }

    public static void show(String string, boolean bl) {
        Trace.getTrace().basicShow(string, new Boolean(bl));
    }

    public static void show(String string, boolean bl, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow(string, new Boolean(bl));
        }
    }

    public static void show(Enumeration enumeration) {
        Trace.getTrace().basicShow("", enumeration);
    }

    public static void show(boolean bl) {
        Trace.getTrace().basicShow("", new Boolean(bl));
    }

    public static void show(boolean bl, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShow("", new Boolean(bl));
        }
    }

    public static void showException(Exception exception, Object object, String string) {
        Trace.showException(exception, object, string, false);
    }

    public static void showException(Exception exception, Object object, String string, boolean bl) {
        Trace.getTrace().basicShowException(exception, object, string, bl);
    }

    public static void showException(Exception exception, String string, boolean bl) {
        Trace.getTrace().basicShowException(exception, null, string, bl);
    }

    public static void showLine() {
        Trace.getTrace().basicShowLine();
    }

    public static void showSection(String string) {
        Trace.getTrace().basicShowSection(string);
    }

    public static void showStack(Exception exception) {
        Trace.getTrace().basicShowStack(exception);
    }

    public static void showWithClass(String string, Object object, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShowWithClass(string, object, null);
        }
    }

    public static void showWithClass(String string, Object object, Object object2, int n) {
        if (Trace.getTrace().getLevel() >= n) {
            Trace.getTrace().basicShowWithClass(string, object, object2);
        }
    }

    public static void startLog() {
        Trace.getTrace().basicStartLog();
    }

    public static void stopLog() {
        Trace.getTrace().basicStopLog();
    }

    public static void traceLevelOne() {
        Trace.getTrace().levelOne();
    }

    public static void traceLevelThree() {
        Trace.getTrace().levelThree();
    }

    public static void traceLevelTwo() {
        Trace.getTrace().levelTwo();
    }

    public static synchronized void traceOff() {
        Trace.getTrace().setTraceOff();
    }

    public static synchronized void traceOn() {
        Trace.getTrace().setTraceOn();
    }

    public static void useSystemOut() {
        Trace.getTrace().setToSystemOut();
    }

    public static void useTraceBuffer() {
        Trace.getTrace().setToTraceBuffer();
    }

    public static void useTraceBuffer(FileOutputStream fileOutputStream) {
        Trace.getTrace().setToTraceBuffer(fileOutputStream);
    }

    public static void useTraceBuffer(PrintStream printStream) {
        Trace.getTrace().setToTraceBuffer(printStream);
    }

    public static void useTraceBuffer(StringBuffer stringBuffer) {
        Trace.getTrace().setToTraceBuffer(stringBuffer);
    }
}

