/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.Association;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.PairwiseIterator;
import com.ibm.ObjectQuery.crud.util.StLookupTable;
import com.ibm.ObjectQuery.crud.util.VapStringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class SymbolTable {
    public static int DEFAULT = -1;
    private StLookupTable table;

    public SymbolTable(Object[] objectArray) {
        this.initialize(new PairwiseIterator(objectArray));
    }

    public SymbolTable(String string) {
        List list = new VapStringReader(string).asBlankDelimitedSubstrings();
        this.initialize(new PairwiseIterator(list));
    }

    public SymbolTable(List list) {
        this.initialize(new PairwiseIterator(list));
    }

    public String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getTable().associationElements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            stringBuffer.append(" ");
            stringBuffer.append((String)association.key());
            stringBuffer.append(" ");
            stringBuffer.append((String)association.value());
        }
        return stringBuffer.toString();
    }

    public int get(String string) {
        Object object = this.getTable().get(string);
        if (object == null) {
            return DEFAULT;
        }
        return (Integer)object;
    }

    public String getSymbol(int n) {
        return (String)this.getTable().get(new Integer(n));
    }

    protected StLookupTable getTable() {
        if (this.table == null) {
            this.table = new StLookupTable();
        }
        return this.table;
    }

    public void initialize(PairwiseIterator pairwiseIterator) {
        while (pairwiseIterator.hasNext()) {
            Association association = (Association)pairwiseIterator.next();
            int n = Integer.parseInt((String)association.second());
            this.getTable().put(association.first(), n);
            this.getTable().put(n, association.first());
        }
    }

    public void put(String string, int n) {
        this.getTable().put((Object)string, (Object)new Integer(n));
    }

    public List symbols() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getTable().keys().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Integer) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        if (this.getTable().size() - 1 < 100) {
            this.getTable().toStringForSmallOn(stringBuffer);
        } else {
            this.getTable().toStringForLargeOn(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public List values() {
        return this.getTable().values();
    }
}

