/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ArrayIterator;
import com.ibm.ObjectQuery.crud.util.EqualityRelation;
import com.ibm.ObjectQuery.crud.util.HashFunction;
import com.ibm.ObjectQuery.crud.util.NullValue;
import com.ibm.ObjectQuery.crud.util.SetEnumerator;
import com.ibm.ObjectQuery.crud.util.StCollection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class StSet
extends StCollection
implements Set {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int elementCount;
    private Object[] elementsArray;

    public StSet() {
    }

    public StSet(int n) {
        this.initialize(Math.max(n + n, StCollection.minimumSize()));
    }

    public StSet(EqualityRelation equalityRelation) {
        super(equalityRelation);
    }

    public StSet(HashFunction hashFunction) {
        super(hashFunction);
    }

    public StSet(HashFunction hashFunction, EqualityRelation equalityRelation) {
        super(hashFunction, equalityRelation);
    }

    public StSet(Object object) {
        this.initialize(1);
        this.add(object);
    }

    public StSet(Object object, Object object2) {
        this.initialize(2);
        this.add(object);
        this.add(object2);
    }

    public StSet(Object object, Object object2, Object object3) {
        this.initialize(3);
        this.add(object);
        this.add(object2);
        this.add(object3);
    }

    public StSet(Object object, Object object2, Object object3, Object object4) {
        this.initialize(4);
        this.add(object);
        this.add(object2);
        this.add(object3);
        this.add(object4);
    }

    public static StSet setOn(Collection collection) {
        StSet stSet = new StSet();
        stSet.addAll(collection);
        return stSet;
    }

    public static StSet setOn(Object[] objectArray) {
        StSet stSet = new StSet();
        stSet.addAll(objectArray);
        return stSet;
    }

    public static StSet setOn(String[] stringArray) {
        StSet stSet = new StSet();
        stSet.addAll(stringArray);
        return stSet;
    }

    public boolean add(char c) {
        return this.add(new Character(c));
    }

    public boolean add(int n) {
        return this.add(new Integer(n));
    }

    public boolean add(Object object) {
        Object object2;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        Object object3 = this.wrapNull(object);
        for (n2 = n = this.hashIndex(object3); n2 < n3; ++n2) {
            object2 = this.elementsArray[n2];
            if (object2 == null) {
                this.elementsArray[n2] = object3;
                if (this.elementCount++ > n3 / 2) {
                    this.expand();
                }
                return true;
            }
            if (!this.eq(object2, object3)) continue;
            return false;
        }
        for (n2 = 0; n2 < n; ++n2) {
            object2 = this.elementsArray[n2];
            if (object2 == null) {
                this.elementsArray[n2] = object3;
                if (this.elementCount++ > n3 / 2) {
                    this.expand();
                }
                return true;
            }
            if (!this.eq(object2, object3)) continue;
            return false;
        }
        this.expand().add(object3);
        return true;
    }

    public boolean addAll(Object[] objectArray) {
        this.primAddAll(new ArrayIterator(objectArray), objectArray.length);
        return true;
    }

    public boolean addAll(Collection collection) {
        this.primAddAll(collection.iterator(), collection.size());
        return true;
    }

    public StSet addNonNull(Object object) {
        if (object != null) {
            this.add(object);
        }
        return this;
    }

    private Object addUnique(Object object) {
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        Object object2 = this.wrapNull(object);
        for (n2 = n = this.hashIndex(object2); n2 < n3; ++n2) {
            if (this.elementsArray[n2] != null) continue;
            this.elementsArray[n2] = object2;
            ++this.elementCount;
            if (this.elementCount > n3 / 2) {
                this.expand();
            }
            return object2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.elementsArray[n2] != null) continue;
            this.elementsArray[n2] = object2;
            ++this.elementCount;
            if (this.elementCount > n3 / 2) {
                this.expand();
            }
            return object2;
        }
        return this.expand().addUnique(object2);
    }

    public Object[] asArray() {
        Object[] objectArray = new Object[this.elementCount];
        int n = 0;
        for (int i = 0; i < this.elementsArray.length; ++i) {
            if (this.elementsArray[i] == null) continue;
            objectArray[n++] = this.elementsArray[i];
        }
        return objectArray;
    }

    public Vector asVector() {
        Vector<Object> vector = new Vector<Object>(this.elementCount);
        for (int i = 0; i < this.elementsArray.length; ++i) {
            if (this.elementsArray[i] == null) continue;
            vector.addElement(this.elementsArray[i]);
        }
        return vector;
    }

    public void clear() {
        for (int i = 0; i < this.elementsArray.length; ++i) {
            this.elementsArray[i] = null;
        }
        this.elementCount = 0;
    }

    public Enumeration elements() {
        return new SetEnumerator(this);
    }

    private StSet expand() {
        return this.rehash(this.elementsArray.length + this.elementsArray.length);
    }

    public Object[] getElementsArray() {
        return this.elementsArray;
    }

    private int hashIndex(Object object) {
        return this.hashIndex(object, this.elementsArray.length);
    }

    private int hashIndex(Object object, int n) {
        return (this.hashFunction().hashValue(object) & Integer.MAX_VALUE) % n;
    }

    public boolean includes(int n) {
        return this.includes(new Integer(n));
    }

    public boolean includes(Object object) {
        Object object2;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        Object object3 = this.wrapNull(object);
        for (n2 = n = this.hashIndex(object3); n2 < n3; ++n2) {
            object2 = this.elementsArray[n2];
            if (object2 == null) {
                return false;
            }
            if (!this.eq(object2, object3)) continue;
            return true;
        }
        for (n2 = 0; n2 < n; ++n2) {
            object2 = this.elementsArray[n2];
            if (object2 == null) {
                return false;
            }
            if (!this.eq(object2, object3)) continue;
            return true;
        }
        return false;
    }

    public void initialize(int n) {
        super.initialize(n);
        this.elementCount = 0;
        this.elementsArray = new Object[n];
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Iterator iterator() {
        return new SetEnumerator(this);
    }

    public boolean notEmpty() {
        return this.elementCount != 0;
    }

    public int occurrences(Object object) {
        if (this.includes(object)) {
            return 1;
        }
        return 0;
    }

    private void primAddAll(Iterator iterator, int n) {
        int n2 = n * 2;
        if (n2 > this.elementsArray.length) {
            this.rehash(n2);
        }
        int n3 = this.elementsArray.length;
        int n4 = n3 / 2;
        while (iterator.hasNext()) {
            Object object = this.wrapNull(iterator.next());
            int n5 = this.hashIndex(object);
            boolean bl = false;
            while (!bl) {
                Object object2 = this.elementsArray[n5];
                if (object2 == null) {
                    this.elementsArray[n5] = object;
                    if (++this.elementCount > n4) {
                        this.expand();
                        n3 = this.elementsArray.length;
                        n4 = n3 / 2;
                    }
                    bl = true;
                    continue;
                }
                bl = this.eq(object2, object);
                if (bl || ++n5 < this.elementsArray.length) continue;
                n5 = 0;
            }
        }
    }

    private void primRemoveAll(Iterator iterator, int n) {
        int n2 = this.elementsArray.length;
        int n3 = -1;
        Object object = new Object();
        if (n >= this.elementCount / 2) {
            int[] nArray = new int[n];
            while (iterator.hasNext()) {
                Object object2 = this.wrapNull(iterator.next());
                int n4 = this.hashIndex(object2);
                boolean bl = false;
                while (!bl) {
                    Object object3;
                    if (n4 >= this.elementsArray.length) {
                        n4 = 0;
                    }
                    if ((object3 = this.elementsArray[n4]) == null) {
                        for (int i = 0; i < n3; ++i) {
                            this.elementsArray[i] = null;
                        }
                        this.elementCount -= n3;
                        if (this.elementCount == 0) {
                            this.initialize(StSet.minimumSize());
                        } else {
                            this.rehash(this.elementCount + this.elementCount);
                        }
                        throw new RuntimeException("object not found => " + object2.toString());
                    }
                    bl = this.eq(object2, object3);
                    ++n4;
                }
                this.elementsArray[n4] = object;
                nArray[++n3] = n4;
            }
            for (int i = 0; i < n3; ++i) {
                nArray[i] = -1;
            }
            this.elementCount -= n3;
            if (this.elementCount == 0) {
                this.initialize(StSet.minimumSize());
            } else {
                this.rehash(this.elementCount + this.elementCount);
            }
        } else {
            while (iterator.hasNext()) {
                Object object4 = this.wrapNull(iterator.next());
                int n5 = this.hashIndex(object4);
                boolean bl = false;
                while (!bl) {
                    Object object5;
                    if (n5 >= this.elementsArray.length) {
                        n5 = 0;
                    }
                    if ((object5 = this.elementsArray[n5]) == null) {
                        throw new RuntimeException("object not found => " + object4.toString());
                    }
                    bl = this.eq(object4, object5);
                    ++n5;
                }
                this.rehashTo(n5);
                --this.elementCount;
            }
        }
    }

    public StSet rehash() {
        return this.rehash(this.elementsArray.length);
    }

    private StSet rehash(int n) {
        Object[] objectArray = new Object[n];
        if (this.elementCount > 0) {
            for (int i = 0; i < this.elementsArray.length; ++i) {
                Object object = this.elementsArray[i];
                if (object == null) continue;
                int n2 = this.hashIndex(object, n);
                if (n2 > n - 1) {
                    n2 = 0;
                }
                while (objectArray[n2] != null) {
                    if (++n2 <= n - 1) continue;
                    n2 = 0;
                }
                objectArray[n2] = object;
            }
        }
        this.elementsArray = objectArray;
        return this;
    }

    private void rehashTo(int n) {
        int n2 = n;
        int n3 = n;
        int n4 = this.elementsArray.length;
        if (++n2 >= n4) {
            n2 = 0;
        }
        Object object = this.elementsArray[n2];
        while (object != null) {
            int n5 = this.hashIndex(object);
            if (!(n2 >= n3 ? n5 > n3 && n5 <= n2 : n5 > n3 || n5 <= n2)) {
                this.elementsArray[n3] = object;
                n3 = n2;
            }
            if (++n2 >= n4) {
                n2 = 0;
            }
            object = this.elementsArray[n2];
        }
        this.elementsArray[n3] = null;
    }

    public boolean remove(int n) {
        return this.remove(new Integer(n));
    }

    public boolean remove(Object object) {
        Object object2;
        int n;
        int n2;
        int n3 = this.elementsArray.length;
        Object object3 = this.wrapNull(object);
        for (n2 = n = this.hashIndex(object3); n2 < n3; ++n2) {
            object2 = this.elementsArray[n2];
            if (object2 == null) {
                return false;
            }
            if (!this.eq(object2, object3)) continue;
            this.rehashTo(n2);
            --this.elementCount;
            return true;
        }
        for (n2 = 0; n2 < n; ++n2) {
            object2 = this.elementsArray[n2];
            if (object2 == null) {
                return false;
            }
            if (!this.eq(object2, object3)) continue;
            this.rehashTo(n2);
            --this.elementCount;
            return true;
        }
        return false;
    }

    public void removeAll(Object[] objectArray) {
        this.primRemoveAll(new ArrayIterator(objectArray), objectArray.length);
    }

    public boolean removeAll(Collection collection) {
        int n = this.size();
        this.primRemoveAll(collection.iterator(), collection.size());
        return n - collection.size() == this.size();
    }

    public int size() {
        return this.elementCount;
    }

    private Object wrapNull(Object object) {
        return object == null ? NullValue.singleton() : object;
    }
}

