/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.AutoWrap;
import com.ibm.ObjectQuery.crud.util.BooleanIntFunction;
import com.ibm.ObjectQuery.crud.util.ClassShortName;
import com.ibm.ObjectQuery.crud.util.CollectionWrapper;
import com.ibm.ObjectQuery.crud.util.IntArrayEnumerator;
import com.ibm.ObjectQuery.crud.util.IntFunction;
import com.ibm.ObjectQuery.crud.util.StSet;
import java.util.Enumeration;
import java.util.Vector;

public class IntArray
extends CollectionWrapper {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int[] fValue;

    public IntArray() {
    }

    public IntArray(int[] nArray) {
        this.value(nArray);
    }

    public IntArray(int n) {
        this.value(new int[n]);
    }

    public static int[] array(int n) {
        int[] nArray = new int[]{n};
        return nArray;
    }

    public static int[] array(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    public static int[] array(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2};
        nArray[2] = n3;
        return nArray;
    }

    public static int[] array(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n2};
        nArray[2] = n3;
        nArray[3] = n4;
        return nArray;
    }

    public int at(int n) {
        if (n >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.value().length);
        }
        try {
            return this.value()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public float avg() {
        return this.sum() / this.size();
    }

    public int[] collect(IntFunction intFunction) {
        int[] nArray = new int[this.value().length];
        for (int i = 0; i < this.value().length; ++i) {
            nArray[i] = intFunction.value(this.value()[i]);
        }
        return nArray;
    }

    public int[] concatenate(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.value().length + nArray.length];
        for (n = 0; n < this.value().length - 1; ++n) {
            nArray2[n] = this.value()[n];
        }
        for (n = this.value().length + 1; n < this.value().length + nArray.length - 1; ++n) {
            nArray2[n] = nArray[n];
        }
        return nArray2;
    }

    public boolean conform(BooleanIntFunction booleanIntFunction) {
        for (int i = 0; i < this.value().length; ++i) {
            if (booleanIntFunction.value(this.value()[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public void copyInto(int[] nArray) {
        int n = this.value().length;
        while (n-- > 0) {
            nArray[n] = this.value()[n];
        }
    }

    public Enumeration elements() {
        return new IntArrayEnumerator(this.value());
    }

    public boolean equals(int[] nArray) {
        if (this.value().length != nArray.length) {
            return false;
        }
        for (int i = 0; i < this.value().length; ++i) {
            if (this.value()[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    public int first() {
        return this.value()[0];
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        for (int i = n2; i < this.value().length; ++i) {
            if (n != this.value()[i]) continue;
            return i;
        }
        return -1;
    }

    public int last() {
        return this.value()[this.value().length - 1];
    }

    public int[] reverse() {
        int n = this.value().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.value()[n - (i - 1)];
        }
        return nArray;
    }

    public int[] select(BooleanIntFunction booleanIntFunction) {
        int[] nArray = new int[this.value().length];
        int n = 0;
        for (int i = 0; i < this.value().length; ++i) {
            if (!booleanIntFunction.value(this.value()[i])) continue;
            nArray[n++] = this.value()[i];
        }
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public void set(int n, int n2) {
        if (n2 >= this.value().length) {
            throw new ArrayIndexOutOfBoundsException(n2 + " >= " + this.value().length);
        }
        this.value()[n2] = n;
    }

    public void setAll(int n) {
        for (int i = 0; i < this.value().length; ++i) {
            this.set(n, i);
        }
    }

    public int size() {
        return this.value().length;
    }

    public int sum() {
        int n = 0;
        for (int i = 0; i < this.value().length; ++i) {
            n += this.value()[i];
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassShortName.name(this));
        stringBuffer.append(" {");
        stringBuffer.append(this.value().toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public StSet toStSet() {
        StSet stSet = new StSet();
        IntArrayEnumerator intArrayEnumerator = new IntArrayEnumerator(this.value());
        while (intArrayEnumerator.hasMoreElements()) {
            stSet.add(intArrayEnumerator.nextElement());
        }
        return stSet;
    }

    public Vector toVector() {
        int n = this.value().length;
        Vector<Object> vector = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            vector.addElement(AutoWrap.wrap(this.value()[i]));
        }
        return vector;
    }

    public int[] value() {
        if (this.fValue == null) {
            this.fValue = new int[0];
        }
        return this.fValue;
    }

    public void value(int[] nArray) {
        this.fValue = nArray;
    }
}

