/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ObjectQuery.crud.util;

import com.ibm.ObjectQuery.crud.util.ListWrapper;
import com.ibm.ObjectQuery.crud.util.ReadBeyondEnd;
import java.util.Enumeration;
import java.util.Vector;

public class ArrayReader
implements Enumeration {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Object lock;
    private Object[] array = new Object[0];
    private int length;
    private int next = -1;

    protected ArrayReader() {
        this.lock = this;
    }

    public ArrayReader(Object[] objectArray) {
        this.lock = this;
        this.array = objectArray;
        this.length = objectArray.length;
    }

    public boolean atEnd() {
        if (this.array.length == 0) {
            return true;
        }
        Object object = this.read();
        if (!(object instanceof ReadBeyondEnd)) {
            this.backup();
        }
        return object instanceof ReadBeyondEnd;
    }

    public long backup() {
        return this.skip(-1L);
    }

    public void close() {
        this.array = new Object[0];
        this.reset();
    }

    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    public Object next() {
        Object object = this.read();
        if (object instanceof ReadBeyondEnd) {
            throw new RuntimeException("read past end of array");
        }
        return object;
    }

    public Object nextElement() {
        return this.next();
    }

    public Object peek() {
        Object object = this.read();
        if (object instanceof ReadBeyondEnd) {
            throw new RuntimeException("peeking past end of array");
        }
        this.backup();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read() {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length - 1) {
                return new ReadBeyondEnd();
            }
            ++this.next;
            return this.array[this.next];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.next = 0;
        }
    }

    public long skip() {
        return this.skip(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) {
        Object object = this.lock;
        synchronized (object) {
            if (l > 0L && this.next >= this.length) {
                return 0L;
            }
            long l2 = Math.min((long)(this.length - this.next), l);
            int n = this.next;
            this.next = (int)((long)this.next + l2);
            if (this.next < 0) {
                this.next = -1;
                return n;
            }
            return l2;
        }
    }

    public int skipUpTo(Object object) {
        int n = 0;
        while (!this.atEnd()) {
            Object object2 = this.next();
            if (object2.equals(object)) {
                this.backup();
                break;
            }
            ++n;
        }
        return n;
    }

    public Object[] upTo(Object object) {
        int n = 0;
        Vector<Object> vector = new Vector<Object>();
        while (!this.atEnd()) {
            Object object2 = this.next();
            vector.addElement(object2);
            if (object2.equals(object)) {
                this.backup();
                break;
            }
            ++n;
        }
        return new ListWrapper(vector).toArray();
    }

    public Object[] upToEnd() {
        Object[] objectArray;
        int n = 0;
        if (!this.atEnd()) {
            objectArray = new Object[this.length - this.next + 1];
        } else {
            return new Object[0];
        }
        while (!this.atEnd()) {
            objectArray[n] = this.next();
            ++n;
        }
        return objectArray;
    }
}

