/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dump;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.Date;

class DumpReader {
    static final int HEADERSIZE = 64;
    static final int BLOCKSIZE = 4160;
    static final boolean USE_JRIO = false;
    String filename;
    RandomAccessFile raf;
    Object rarf;
    Method seekMethod;
    Method readMethod;
    Method closeMethod;
    int fp;
    int[] fpos = new int[8];
    int blockSize;
    int recordsPerBlock;
    int lowerLimit;
    boolean debug = false;
    ThreadLocalMvsDumpReader mvsDumpReaderWrapper = new ThreadLocalMvsDumpReader();
    String title;
    String time;

    DumpReader(String string) throws Exception {
        try {
            this.raf = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = System.getProperty("svcdump.libpath");
            if (string2 == null) {
                try {
                    System.loadLibrary("svcdump");
                }
                catch (Throwable throwable) {
                    if (System.getProperty("os.arch").equals("390")) {
                        throw new FileNotFoundException("file " + string + " not found in HFS and no svcdump.libpath set");
                    }
                    throw new FileNotFoundException("file " + string + " not found");
                }
            } else {
                System.load(string2 + System.getProperty("file.separator") + "libsvcdump.so");
            }
            this.open("//'" + string + "'");
            Dump.Assert(this.recordsPerBlock == this.blockSize / 4160);
        }
        this.seek(0);
        byte[] byArray = new byte[4160];
        this.read(byArray);
        int n = DumpReader.getInt(byArray, 0);
        if (n != -992349888 && n != -992349632) {
            this.close();
            if (n == 1146237216 || n == 1146237472) {
                System.out.println("");
                System.out.println("*** Error ***");
                System.out.println("");
                System.out.println("Found an ascii version of the magic number. This means that the dump must");
                System.out.println("have been transferred in ftp ascii mode. Please transfer again using binary mode.");
                System.out.println("");
            }
            throw new Exception("bad magic: " + Dump.hex(n));
        }
        byte[] byArray2 = new byte[100];
        System.arraycopy(byArray, 88, byArray2, 0, 100);
        this.title = Dump.getEbcdicString(byArray2);
        long l = DumpReader.getInt(byArray, 18);
        long l2 = DumpReader.getInt(byArray, 19);
        Date date = AddressSpace.mvsClockToDate(l << 32 | l2 & 0xFFFFFFFFL);
        this.time = date.toString();
        this.seek(0);
    }

    DumpReader(File file) throws Exception {
        this(file.getPath());
    }

    void seek(int n) throws IOException {
        if (this.debug) {
            System.out.println("enter seek: " + n);
        }
        if (this.raf != null) {
            long l = (long)n * 4160L;
            try {
                this.raf.seek(l);
            }
            catch (Exception exception) {
                System.out.println("fatal error, could not seek to " + l);
                System.exit(1);
            }
        } else {
            this.setpos(n);
        }
        if (this.debug) {
            System.out.println("exit seek: " + n);
        }
    }

    void read(byte[] byArray) throws IOException {
        Dump.Assert(byArray.length == 4160);
        if (this.debug) {
            System.out.println("enter read");
        }
        if (this.raf != null) {
            this.raf.readFully(byArray);
        } else {
            int n = this.fread(byArray);
            if (n <= 0) {
                throw new EOFException();
            }
        }
        if (this.debug) {
            System.out.println("exit read");
        }
    }

    int readInt() throws IOException {
        byte[] byArray = new byte[4160];
        this.read(byArray);
        return DumpReader.getInt(byArray, 0);
    }

    static int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public native void open(String var1);

    public native void setpos(int var1);

    public native int fread(byte[] var1);

    class MvsDumpReader {
        MvsDumpReader(String string) {
        }
    }

    class ThreadLocalMvsDumpReader
    extends ThreadLocal {
        ThreadLocalMvsDumpReader() {
        }

        protected Object initialValue() {
            return new MvsDumpReader(DumpReader.this.filename);
        }
    }
}

