/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.Hashtable;

public class Dsa
extends Base {
    public int address;
    Dsa previous;
    Dsa next;
    AddressSpace space;
    Tcb tcb;
    int[] registers;
    int returnAddress;
    int realReturnAddress;
    int entryPoint;
    String function;
    String simpleFunction;
    String program;
    String service;
    static int micb = 0;
    boolean foundPrevious;
    boolean downstack;
    int prevCount;
    boolean foundPrevCount;
    boolean is118;
    boolean transition;
    boolean isBrasl;
    int hack;
    int depth;
    static int numArgs = SvcdumpProperties.getIntProperty("svcdump.numargs", 4);
    static boolean derefArgs = SvcdumpProperties.getBooleanProperty("svcdump.deref.args", false);
    boolean verbose;
    static String[] knownFunctions = new String[]{"CEEOPEF", "pthread exit forced", "CEEHSGL", "raise a condition", "CEEOSIGG", "deliver signal", "CEEOPCT", "pthread_cond_timedwait", "CEEOPML2", "pthread_mutex_lock", "CEEOPMU2", "pthread_mutex_unlock", "CEEPMDEL", "delete a load module", "CEEVGSTR", "get main storage", "CEEOPGS", "pthread_getspecific", "CEECZLOD", "process level load under CICS", "CEEPVDEL", "delete a module", "CEEVGQP", "get heap pool storage", "CEEOPCS", "pthread_cond_signal", "CEEOPMI", "pthread_mutex_init", "CEEPVLOD", "load module", "CEEVFQP", "free heap pool storage", "CEEVSTLO", "get heap latch", "CEEVCZST", "realloc", "CEEHDSP", "exception dispatcher", "CEEOPMD", "pthread_mutex_destroy", "CEEHHDLR", "register user condition handler", "CEEVGTST", "get heap storage", "CEEVGTSI", "extend stack", "CEEVFSTR", "free main storage", "CEEPTLC", "load dll", "CEEBTERM", "batch termination", "CEEM@MOU", "output MVS message", "CEEV#GTS", "get heap storage", "CEEOGLAT", "get contended latch", "CEEORLAT", "release contended latch", "CEEBBEXT", "bootstrap routine", "CEEOTERM", "posix termination", "CEEZRET", "thread termination", "EDCZMINV", "main invocation event handler", "CEEHSFXS", "stack frame exit schedule", "mmipSelectInvokeJavaMethod", "java", "mmipSelectInvokeSynchronizedJavaMethod", "java", "mmipInvokeJavaMethod", "java", "mmipInvokeSynchronizedJavaMethod", "java"};
    static Hashtable knownFunctionsTable = new Hashtable();
    boolean testxplink;

    public int stackPointer() {
        return this.address;
    }

    public String functionName() {
        return this.function();
    }

    public Dsa(Tcb tcb, int n, boolean bl) throws Exception {
        this(tcb, null, n, false, bl, 0, true);
    }

    Dsa(Tcb tcb, Dsa dsa, int n, boolean bl, boolean n2, int n3, boolean bl2) throws Exception {
        block56: {
            int n4;
            this.registers = new int[16];
            this.prevCount = -1;
            this.verbose = false;
            if (n3 > 200) {
                throw new Exception("Dsa with improbable depth!");
            }
            this.verbose = tcb.verbose;
            this.next = dsa;
            this.depth = n3;
            this.downstack = n2;
            if (n2 != 0) {
                tcb.usesXplink = true;
            }
            this.transition = bl;
            this.testxplink = bl2;
            this.tcb = tcb;
            this.space = tcb.space;
            this.address = n;
            try {
                this.registers[14] = this.space.readInt(n + 12);
                this.returnAddress = this.registers[14] & Integer.MAX_VALUE;
                this.registers[15] = this.space.readInt(n + 16);
                for (n4 = 0; n4 < 14; ++n4) {
                    this.registers[n4] = this.space.readInt(n + 20 + n4 * 4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2) {
                int n5;
                int n6;
                if (this.verbose) {
                    System.out.println("creating dsa " + Dsa.hex(n));
                }
                n4 = n2;
                boolean bl3 = false;
                if (n2 == 0) {
                    n6 = this.space.readInt(n + 4);
                    if (this.verbose) {
                        System.out.println("non-xplink prev = " + Dsa.hex(n6));
                    }
                    if (n6 == -1) {
                        long l;
                        n5 = this.space.readInt(n + 100);
                        if (this.verbose) {
                            System.out.println("downtoup = " + Dsa.hex(n5));
                        }
                        if ((l = this.space.readLong(n5)) == -4262966190934661929L) {
                            if (this.verbose) {
                                System.out.println("downtoup eye catcher found");
                            }
                            n6 = this.space.readInt(n5 + 48);
                            this.realReturnAddress = this.space.readInt(n5 + 60) & Integer.MAX_VALUE;
                            n4 = 1;
                            bl3 = true;
                            this.entryPoint = this.space.readInt(n5 + 28) & Integer.MAX_VALUE;
                            if (this.verbose) {
                                System.out.println("entryPoint = " + Dsa.hex(this.entryPoint));
                            }
                        } else if (this.verbose) {
                            System.out.println("Error! no downtoup eye catcher found " + Long.toHexString(l));
                        }
                    } else {
                        this.realReturnAddress = this.returnAddress;
                    }
                } else {
                    n5 = n + 2048;
                    this.returnAddress = this.space.readInt(n5 + 12) & Integer.MAX_VALUE;
                    this.entryPoint = this.space.readInt(n5 + 8) & Integer.MAX_VALUE;
                    n6 = this.space.readInt(n5);
                    n = n5;
                    if (this.verbose) {
                        System.out.println("xplink dsa " + Dsa.hex(n) + " prev = " + Dsa.hex(n6) + " ret " + Dsa.hex(this.returnAddress) + " ep " + Dsa.hex(this.entryPoint));
                    }
                    if (this.returnAddress == 0 && n6 == -472268331) {
                        int n7 = this.space.readInt(n5 + 56);
                        long l = this.space.readLong(n7);
                        if (l == -1956845001504266539L) {
                            if (this.verbose) {
                                System.out.println("uptodown eye catcher found");
                            }
                            n6 = this.space.readInt(n7 + 48);
                            n4 = 0;
                            bl3 = true;
                            this.returnAddress = this.space.readInt(n7 + 60) & Integer.MAX_VALUE;
                            this.entryPoint = this.space.readInt(n7 + 28) & Integer.MAX_VALUE;
                            if (this.space.readInt(this.entryPoint - 16) != 12779717) {
                                throw new Exception("bad entry point eyecatcher: " + Dsa.hex(this.space.readInt(this.entryPoint - 16)));
                            }
                        } else if (this.verbose) {
                            System.out.println("Error! no uptodown eye catcher found");
                        }
                    } else {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        boolean bl4 = false;
                        if (this.isBRAS(this.returnAddress)) {
                            if (this.verbose) {
                                System.out.println("found a BRAS!");
                            }
                            n11 = this.returnAddress - 4;
                            n10 = this.space.readShort(n11 + 2);
                            this.entryPoint = n11 + (n10 << 1);
                            bl4 = true;
                        } else if (this.verbose) {
                            System.out.println("no BRAS");
                        }
                        n11 = 0;
                        try {
                            n11 = this.space.readInt(this.returnAddress);
                        }
                        catch (Exception exception) {
                            if (this.verbose) {
                                System.out.println("could not read returnAddress " + Dsa.hex(this.returnAddress));
                            }
                            throw exception;
                        }
                        n10 = n11 >> 16 & 0xF;
                        if (n10 == 0) {
                            if (bl4) {
                                throw new Exception("isBras!");
                            }
                        } else if (n10 == 1) {
                            if (!bl4) {
                                throw new Exception("not isBras!");
                            }
                        } else if (n10 == 2) {
                            n9 = this.returnAddress - 4;
                            n8 = this.space.readInt(n9);
                            this.entryPoint = n9 + (n8 << 1);
                            if (bl4) {
                                throw new Exception("isBras!");
                            }
                            this.isBrasl = true;
                        } else {
                            throw new Exception("Unknown call type: " + Dsa.hex(n11));
                        }
                        try {
                            if (this.space.readInt(this.entryPoint - 16) != 12779717) {
                                throw new Exception("bad entry point eyecatcher: " + Dsa.hex(this.space.readInt(this.entryPoint - 16)));
                            }
                            n9 = this.space.readInt(this.entryPoint - 4);
                            if ((n9 & 4) == 0) {
                                n8 = n9 & 0xFFFFFFF0;
                                n6 = n - 2048 + n8;
                            }
                        }
                        catch (Exception exception) {
                            if (this.verbose) {
                                System.out.println("could not read entryPoint " + Dsa.hex(this.entryPoint));
                            }
                            throw exception;
                        }
                    }
                    this.realReturnAddress = this.returnAddress;
                }
                this.foundPrevious = true;
                if (n6 != 0 && n6 != n) {
                    try {
                        if (tcb.caa == null || tcb.caa.bottomDsa() != n) {
                            if (this.verbose) {
                                if (tcb.caa == null) {
                                    System.out.println("about to get previous dsa, caa is null");
                                } else {
                                    System.out.println("about to get previous dsa, caa bottom dsa is " + Dsa.hex(tcb.caa.bottomDsa()));
                                }
                            }
                            this.previous = new Dsa(tcb, this, n6, bl3, n4 != 0, n3 + 1, bl2);
                        } else if (this.verbose) {
                            System.out.println("hit bottomDsa " + Dsa.hex(tcb.caa.bottomDsa()));
                        }
                    }
                    catch (Exception exception) {
                        if (!this.verbose) break block56;
                        System.out.println("caught exception: " + exception);
                    }
                }
            }
        }
    }

    boolean isBRAS(int n) {
        n -= 2;
        try {
            int n2 = this.space.readUnsignedShort(n);
            if (n2 == 3446) {
                return false;
            }
            n2 = this.space.readUnsignedShort(n -= 2);
            if (n2 == 42869) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    Dsa(Tcb tcb, int n, int n2) throws Exception {
        this(tcb, null, n, false, false, n2, true);
    }

    Dsa(Tcb tcb, int n) throws Exception {
        this(tcb, n, 0);
    }

    public Dsa previous() {
        if (!this.foundPrevious) {
            this.foundPrevious = true;
            try {
                int n = this.space.readInt(this.address + 4);
                if (n != 0 && n != this.address) {
                    this.space.readInt(n);
                    if (this.tcb.caa == null || this.tcb.caa.bottomDsa() != this.address) {
                        this.previous = new Dsa(this.tcb, n, this.depth + 1);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.previous;
    }

    public int getMdata() {
        return this.registers[4] & Integer.MAX_VALUE;
    }

    public boolean isJitFrame() throws Exception {
        int n = this.space.readInt(this.getMdata());
        return n != 0;
    }

    public boolean isMmiFrame() throws Exception {
        return this.tcb.jvm.isMmiFrame(this);
    }

    public Dsa jitFramePrevious() throws Exception {
        Dsa dsa = this.previous();
        while (this.space.readByte(dsa.address) != 16) {
            dsa = dsa.previous();
        }
        return dsa;
    }

    public int prevJavaFrame() throws Exception {
        return this.space.readInt(this.address + 188);
    }

    public static String function(AddressSpace addressSpace, int n) throws Exception {
        String string;
        block9: {
            int n2;
            string = null;
            int n3 = addressSpace.readInt(n + 4);
            if (n3 == 0xC3C5C5 || n3 == 29607365) {
                n2 = n + addressSpace.readInt(n + 12);
                int n4 = addressSpace.readUnsignedByte(n2);
                if (n3 == 29607365) {
                    n4 <<= 1;
                }
                string = Dsa.readFunctionName(addressSpace, n2, n4);
                break block9;
            }
            if ((n3 & 0xFF0000) == 0xCE0000) {
                n2 = n;
                int n5 = n3 >>> 24;
                string = Dsa.readFunctionName(addressSpace, n2, n5);
                break block9;
            }
            if ((addressSpace.readInt(n) & 0xFFFFF000) == 1206972416) {
                int n6;
                n2 = addressSpace.readUnsignedByte(n + 4);
                byte[] byArray = new byte[n2];
                for (n6 = 0; n6 < n2; ++n6) {
                    byArray[n6] = (byte)addressSpace.readUnsignedByte(n + 5 + n6);
                }
                string = Dump.getEbcdicString(byArray);
                for (n6 = 0; n6 < string.length(); ++n6) {
                    char c = string.charAt(n6);
                    if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c)) continue;
                    string = "(unknown)";
                    break block9;
                }
                break block9;
            }
            string = addressSpace.xplinkFunction(n);
        }
        String string2 = (String)knownFunctionsTable.get(string);
        if (string2 != null && !string2.equals("java")) {
            string = string + "    (" + string2 + ")";
        }
        return string;
    }

    public String function() {
        int n;
        if (this.function != null) {
            return this.function;
        }
        if (this.isBrasl) {
            throw new Error("Need to check isBrasl!");
        }
        this.function = "(unknown)";
        int n2 = this.entryPoint();
        if (n2 == 0) {
            return this.function;
        }
        String string = this.function;
        try {
            string = this.function = Dsa.function(this.space, n2);
            if (Dump.printArgs) {
                this.function = this.function + "(";
                for (n = 0; n < numArgs; ++n) {
                    try {
                        int n3 = this.getArg(n);
                        this.function = this.function + Dsa.hex(n3);
                        if (derefArgs) {
                            try {
                                n3 = this.space.readInt(n3);
                                this.function = this.function + "(->" + Dsa.hex(n3) + ")";
                            }
                            catch (Exception exception) {
                                this.function = this.function + "(->?)";
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.function = this.function + "?";
                    }
                    this.function = n == numArgs - 1 ? this.function + ") " : this.function + ", ";
                }
            }
            if (this.verbose) {
                this.function = this.function + " (ep = " + Dsa.hex(n2) + ")";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string.equals("clInitClass")) {
            try {
                n = this.getArg(1);
                String string2 = this.tcb.jvm.cbName(n);
                this.function = this.function + " (class = " + string2 + ")";
            }
            catch (Exception exception) {
                this.function = this.function + " (error reading class: " + exception + ")";
            }
        }
        if (this.hack != 0) {
            this.function = this.function + " our dsa = " + Dsa.hex(this.hack);
        }
        return this.function;
    }

    int getArg(int n) throws Exception {
        if (this.downstack) {
            return this.space.readInt(this.previous().address + 2112 + (n << 2));
        }
        int n2 = this.previous().registers[1];
        return this.space.readInt(n2 + (n << 2));
    }

    public String simpleFunction() {
        if (this.simpleFunction != null) {
            return this.simpleFunction;
        }
        this.simpleFunction = "(unknown)";
        int n = this.entryPoint();
        if (n == 0) {
            return this.simpleFunction;
        }
        try {
            this.simpleFunction = Dsa.function(this.space, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.simpleFunction;
    }

    String program(int n) throws Exception {
        int n2;
        int n3 = this.space.readUnsignedByte(n + 3);
        if (n3 != 12) {
            n3 = this.space.readUnsignedByte(n + 7);
        }
        if ((n2 = this.space.readUnsignedShort(n + n3)) > 1000) {
            throw new Exception("bad length: " + n2);
        }
        return this.space.getString(n + n3 + 2, n2);
    }

    String xpProgram() {
        this.program = "";
        try {
            int n = this.entryPoint() - 16;
            int n2 = this.space.readInt(n + 8);
            int n3 = n + n2;
            int n4 = n3 + this.space.readInt(n3 + 4);
            int n5 = this.space.readInt(n4 + 8);
            if (n5 != 0) {
                int n6 = n4 + n5;
                this.program = this.program(n6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.program;
    }

    public String program() {
        if (this.program != null) {
            return this.program;
        }
        if (this.downstack) {
            return this.xpProgram();
        }
        this.program = "";
        try {
            int n = this.entryPoint();
            int n2 = this.space.readInt(n + 4);
            if (n2 == 0xC3C5C5 || n2 == 29607365) {
                int n3 = n + this.space.readInt(n + 12);
                if (n2 == 29607365) {
                    int n4 = n + this.space.readInt(n3 + 4);
                    int n5 = this.space.readInt(n4 + 8);
                    if (n5 != 0) {
                        int n6 = n4 + n5;
                        this.program = this.program(n6);
                    }
                } else {
                    int n7 = this.space.readInt(n3 + 4);
                    int n8 = this.space.readInt(n7 + 8);
                    if (n8 != 0) {
                        int n9 = this.space.readUnsignedShort(n8 + 12);
                        Dsa.Assert(n9 < 1000);
                        this.program = this.space.getString(n8 + 14, n9);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.program;
    }

    public String service() {
        if (this.service != null) {
            return this.service;
        }
        try {
            int n = this.entryPoint();
            int n2 = this.space.readInt(n + 4);
            if (n2 == 0xC3C5C5 || n2 == 29607365) {
                int n3 = n + this.space.readInt(n + 12);
                if (n2 == 29607365) {
                    int n4 = n + this.space.readInt(n3 + 4);
                    int n5 = n4 + this.space.readInt(n4 + 12);
                    int n6 = this.space.readUnsignedShort(n5 + 20);
                    byte[] byArray = new byte[n6];
                    for (int i = 0; i < n6; ++i) {
                        byArray[i] = (byte)this.space.readUnsignedByte(n5 + 22 + i);
                    }
                    this.service = Dump.getEbcdicString(byArray);
                } else {
                    int n7 = this.space.readInt(n3 + 4);
                    int n8 = this.space.readInt(n7 + 12);
                }
            } else if ((n2 & 0xFF0000) == 0xCE0000) {
                int n9 = n;
                int n10 = this.space.readInt(n9 + 4);
                n = this.space.readInt(n10 + 16);
                this.service = Dsa.function(this.space, n);
            } else {
                this.service = "(unknown)";
            }
        }
        catch (Exception exception) {
            this.service = "(unknown)";
        }
        return this.service;
    }

    public static Dsa findTop(Tcb tcb, int n) throws Exception {
        int n2 = n;
        try {
            int n3;
            while (tcb.space.readInt((n3 = tcb.space.readInt(n2 + 76)) + 4) == n2) {
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Dsa(tcb, n2, 0);
    }

    public static Dsa findStack(Tcb tcb, int n) {
        Dsa dsa = null;
        for (int i = n; i > n - 4096; i -= 4) {
            try {
                int n2 = tcb.space.readInt(i + 76);
                if (tcb.space.readInt(n2 + 4) != i) continue;
                Dsa dsa2 = Dsa.findTop(tcb, i);
                if (dsa != null && dsa.prevCount() >= dsa2.prevCount()) continue;
                dsa = dsa2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dsa;
    }

    public int prevCount() {
        if (this.verbose) {
            System.out.println("prevCount begin");
        }
        if (!this.foundPrevCount) {
            this.foundPrevCount = true;
            for (Dsa dsa = this; dsa != null; dsa = dsa.previous()) {
                ++this.prevCount;
                if (this.prevCount <= 1000) continue;
                if (this.verbose) {
                    System.out.println("bad prevCount, probably loop");
                }
                this.prevCount = -1;
                break;
            }
        }
        if (this.verbose) {
            System.out.println("prevCount end");
        }
        return this.prevCount;
    }

    boolean badName(String string) {
        if (string.equals(".")) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isIdentifierIgnorable(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public String method() {
        this.function();
        String string = "";
        if (this.downstack) {
            return string;
        }
        try {
            if (this.function.startsWith("mmipInvoke") || this.function.startsWith("mmisInvoke") || this.function.startsWith("mmipSelectInvoke")) {
                string = this.cbName(false) + "." + this.mbName(false);
            } else if (this.function.equals("EXECJAVA") && this.badName(string = this.cbName(false) + "." + this.mbName(false)) && this.badName(string = this.cbName(true) + "." + this.mbName(true))) {
                string = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static String readFunctionName(AddressSpace addressSpace, int n, int n2) throws Exception {
        int n3 = addressSpace.readUnsignedShort(n + n2);
        if (n3 > 500) {
            throw new Exception("Impossibly long name: " + n3);
        }
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray[i] = (byte)addressSpace.readUnsignedByte(n + n2 + 2 + i);
        }
        return Dump.getEbcdicString(byArray);
    }

    HeapMethod mb() {
        try {
            int n = this.space.readInt(this.address + 172);
            if (n == 0) {
                return null;
            }
            Dsa.Assert(n == this.previous().registers[6]);
            try {
                return new HeapMethod(this.tcb.jvm, n);
            }
            catch (Exception exception) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("bad read " + exception);
        }
    }

    int last_pc() {
        try {
            return this.space.readInt(this.address + 192);
        }
        catch (Exception exception) {
            throw new Error("bad read " + exception);
        }
    }

    String mbName(boolean bl) {
        String string = "";
        try {
            int n;
            int n2;
            int n3 = 0;
            if (bl) {
                n2 = this.previous().registers[1];
                int n4 = this.space.readInt(n2);
                n = this.space.readInt(n4 + 8);
                int n5 = this.space.readInt(n + 0);
                n3 = this.space.readInt(n5 + 4);
            } else {
                n3 = this.previous().registers[6];
            }
            n2 = this.space.readInt(n3 + 8);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = this.space.readUnsignedByte(n2++)) != 0) {
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    String cbName(boolean bl) {
        String string = "";
        try {
            int n;
            int n2 = 0;
            if (bl) {
                n = this.previous().registers[1];
                int n3 = this.space.readInt(n);
                int n4 = this.space.readInt(n3 + 8);
                int n5 = this.space.readInt(n4 + 0);
                n2 = this.space.readInt(n5 + 4);
            } else {
                n2 = this.previous().registers[6];
            }
            n = this.space.readInt(n2);
            string = this.tcb.jvm.cbName(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public int entryPoint() {
        if (this.entryPoint != 0) {
            return this.entryPoint;
        }
        if (this.previous() == null) {
            return 0;
        }
        if (this.previous().address == this.tcb.failingDsa(this.previous().downstack)) {
            try {
                int n = this.space.readInt(this.previous().address + 76);
                int n2 = this.space.readInt(n + 16);
                this.entryPoint = n2 & Integer.MAX_VALUE;
                return this.entryPoint;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.entryPoint = this.previous().registers[15] & Integer.MAX_VALUE;
        return this.entryPoint;
    }

    public int address() {
        return this.address;
    }

    public int returnAddress() {
        if (this.downstack && this.next != null) {
            return this.next.realReturnAddress;
        }
        return this.returnAddress;
    }

    public int offset() {
        int n;
        if (this.address == this.tcb.failingDsa(this.downstack) && (n = this.tcb.failingPsw()) != 0) {
            return n - this.entryPoint();
        }
        return this.returnAddress() - this.entryPoint() - 2;
    }

    public int reg(int n) {
        return this.registers[n];
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    public String toString() {
        return Dsa.hex(this.address);
    }

    static {
        for (int i = 0; i < knownFunctions.length; i += 2) {
            knownFunctionsTable.put(knownFunctions[i], knownFunctions[i + 1]);
        }
    }
}

