/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.PrintClient;
import com.ibm.jvm.findroots.SimpleGraph;
import com.ibm.jvm.findroots.StrongComponentsGraph;
import com.ibm.jvm.findroots.Vertex;
import com.ibm.jvm.findroots.Visitor;
import com.ibm.jvm.util.BitSetArray;
import com.ibm.jvm.util.IntEnumeration;
import com.ibm.jvm.util.IntegerArray;
import com.ibm.jvm.util.IntegerStack;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.BitSet;
import java.util.Vector;

public final class ReachabilityGraph
extends SimpleGraph {
    int[] dagIndex;
    int[] reach;
    StrongComponentsGraph dag;
    BitSet visited;
    int maxdepth = SvcdumpProperties.getIntProperty("findroots.depth", 1000);
    int maxroots = 20;
    int prune = SvcdumpProperties.getIntProperty("findroots.prune", this.sizeMatters ? 10000 : 1000);
    boolean calculateReachability = true;
    static int logFreq = 4096;
    BitSetArray domChildren;

    public ReachabilityGraph() {
        this.maxroots = SvcdumpProperties.getIntProperty("findroots.maxroots", 20);
        this.calculateReachability = SvcdumpProperties.getBooleanProperty("findroots.calculate.reachability", true);
    }

    String className() {
        return "ReachabilityGraph";
    }

    public int reachFrom(int n) {
        if (this.visited == null) {
            this.visited = new BitSet();
        }
        return this.reachFrom(n, this.visited);
    }

    public int reachFrom(Vertex vertex) {
        return this.reachFrom(vertex.id());
    }

    public boolean reachGreaterThan(Vertex vertex, int n) {
        this.complete();
        class ReachVisitor
        extends Visitor {
            int n = 0;
            boolean greater;
            int target;

            ReachVisitor(int n) {
                this.target = n;
            }

            public boolean continueSearch(int n, int n2) {
                return !this.greater;
            }

            public void enterNode(int n, int n2) {
                if (++this.n > this.target) {
                    this.greater = true;
                }
            }

            public Object result() {
                return new Boolean(this.greater);
            }
        }
        Boolean bl = (Boolean)this.dfs(new ReachVisitor(n), vertex.index);
        return bl;
    }

    public int reachableVertices(int n) {
        ReachabilityGraph.Assert(false);
        return 0;
    }

    public int reachableSize(int n) {
        ReachabilityGraph.Assert(false);
        return 0;
    }

    int reach(int n) {
        if (this.reach == null) {
            this.findStrongComponents();
            this.printUsage("after findStrongComponents");
            ReachabilityGraph.freeze(this.vertexIds, "vertexIds");
            this.vertexIds = null;
            ReachabilityGraph.freeze(this.vertexSizes, "vertexSizes");
            this.vertexSizes = null;
            ReachabilityGraph.freeze(this.dagIndex, "dagIndex");
            this.dagIndex = null;
            this.stepper = null;
            this.dag.transitiveClosure();
            this.vertexIds = (IntegerArray)ReachabilityGraph.unfreeze("vertexIds");
            this.vertexSizes = (IntegerArray)ReachabilityGraph.unfreeze("vertexSizes");
            this.dagIndex = (int[])ReachabilityGraph.unfreeze("dagIndex");
            this.printUsage("after transitiveClosure");
            this.reach = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.reach[i] = this.dag.reach[this.dagIndex[i]];
            }
            this.dag = null;
            this.dagIndex = null;
            this.log("finished calculating reachability");
        }
        return this.reach[n];
    }

    void printNode(int n, int n2, boolean bl) {
        int n3 = this.vertexIds.get(n);
        for (int i = 0; i < n2; ++i) {
            System.out.print("   ");
        }
        if (this.reach == null) {
            System.out.println("0x" + ReachabilityGraph.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
        } else {
            System.out.println(this.reach[n] + " 0x" + ReachabilityGraph.hex(n3) + " " + this.client.getName(n3) + (bl ? "" : " (already visited)"));
        }
    }

    void printTree(int n) {
        this.complete();
        int n2 = this.idToIndex(n);
        this.log("begin printTree");
        this.printNode(n2, 0, true);
        this.dfs(new Visitor(){
            int count = 0;

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (ReachabilityGraph.this.reach != null && ReachabilityGraph.this.reach[n2] < ReachabilityGraph.this.prune) {
                    return;
                }
                ReachabilityGraph.this.printNode(n2, n3, bl);
            }

            public boolean continueSearch(int n, int n2) {
                return n2 < ReachabilityGraph.this.maxdepth && (ReachabilityGraph.this.reach == null || ReachabilityGraph.this.reach[n] > ReachabilityGraph.this.prune);
            }

            public int getCount(int n) {
                return ReachabilityGraph.this.reach == null ? 0 : ReachabilityGraph.this.reach[n];
            }

            public boolean sort() {
                return true;
            }
        }, n2);
        this.log("end printTree");
    }

    void printTree(PrintClient printClient, int n) {
        this.client = printClient;
        this.reach(0);
        this.printTree(n);
    }

    ReachabilityGraph findDominators(int n) {
        int n2;
        this.calculateImmediateDominators(n);
        ReachabilityGraph reachabilityGraph = new ReachabilityGraph();
        for (n2 = 0; n2 < this.size; ++n2) {
            reachabilityGraph.idToIndex(this.vertexIds.get(n2));
        }
        n2 = this.idToIndex(n);
        for (int i = 0; i < this.size; ++i) {
            if (i == n2) continue;
            int n3 = this.vertexIds.get(this.idom[i]);
            int n4 = this.vertexIds.get(i);
            reachabilityGraph.addEdge(n3, n4);
            reachabilityGraph.vertexSizes.put(i, this.vertexSizes.get(i));
        }
        reachabilityGraph.complete();
        return reachabilityGraph;
    }

    BitSetArray edges() {
        return this.domChildren == null ? super.edges() : this.domChildren;
    }

    void treeReach(int n) {
        int n2 = this.idToIndex(n);
        this.dfs(new Visitor(){
            int cnt = 0;

            public void enterNode(int n, int n2) {
                block0: {
                    ReachabilityGraph.this.reach[n] = this.cnt++;
                    if (!ReachabilityGraph.this.exact && !ReachabilityGraph.this.sizeMatters) break block0;
                    this.cnt += ReachabilityGraph.this.vertexSizes.get(n);
                }
            }

            public void exitNode(int n) {
                ReachabilityGraph.this.reach[n] = this.cnt - ReachabilityGraph.this.reach[n];
            }
        }, n2);
    }

    void printUsage(String string) {
        if (ReachabilityGraph.verbose()) {
            super.printUsage(string);
            System.out.println("ReachabilityGraph usage " + string + ":");
            if (this.dagIndex != null) {
                System.out.println("    dagIndex " + this.dagIndex.length * 4);
            }
            if (this.reach != null) {
                System.out.println("    reach " + this.reach.length * 4);
            }
            if (this.dag != null) {
                this.dag.printUsage(string);
            }
        }
    }

    void findDominatorEdges(int n) {
        this.log("begin findDominatorEdges");
        this.calculateImmediateDominators(n);
        this.domChildren = new BitSetArray(this.size, "Dominator children");
        for (int i = 0; i < this.size; ++i) {
            if (this.idom[i] == -1) continue;
            this.domChildren.set(this.idom[i], i);
        }
        this.log("calculate tree reachability");
        this.treeReach(n);
        this.log("end findDominatorEdges");
    }

    StrongComponentsGraph findStrongComponents() {
        int n;
        int n2;
        this.log("begin findStrongComponents");
        int[] nArray = (int[])this.dfs(new Visitor(){
            IntegerStack s = new IntegerStack();
            IntegerStack path = new IntegerStack();
            int[] pre;
            int[] sc;
            int cnt0;
            int cnt1;
            {
                this.pre = new int[ReachabilityGraph.this.size];
                this.sc = new int[ReachabilityGraph.this.size];
                this.cnt0 = 0;
                this.cnt1 = 1;
            }

            public void init() {
                for (int i = 0; i < ReachabilityGraph.this.size; ++i) {
                    this.sc[i] = -1;
                }
            }

            public void enterNode(int n, int n2) {
                ++this.cnt0;
                this.s.push(n);
                this.path.push(n);
                ReachabilityGraph.this.trace("enter node " + n + " at depth " + n2);
            }

            public void visitChild(int n, int n2, boolean bl, int n3) {
                if (!bl && this.sc[n2] == -1) {
                    while (this.pre[this.path.peek()] > this.pre[n2]) {
                        this.path.pop();
                    }
                }
            }

            public void exitNode(int n) {
                if (this.path.peek() == n) {
                    int n2;
                    this.path.pop();
                    do {
                        n2 = this.s.pop();
                        this.sc[n2] = this.cnt1++;
                    } while (n2 != n);
                }
            }

            public Object result() {
                return this.sc;
            }
        });
        this.log("create dag");
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (nArray[n2] <= n3) continue;
            n3 = nArray[n2];
        }
        this.dag = new StrongComponentsGraph();
        this.dag.setRecordParents(true);
        this.dagIndex = new int[this.size];
        this.dag.idToIndex(0);
        if (optinterval) {
            for (n2 = 1; n2 <= n3; ++n2) {
                this.dag.idToIndex(n2);
            }
        }
        this.dag.isNotRoot.set(0);
        IntEnumeration intEnumeration = this.edges.elements(0);
        for (n = 0; n < this.size; ++n) {
            int n4;
            if (this.deleted.get(n)) continue;
            this.trace("doing dag stuff for " + n);
            this.dagIndex[n] = n4 = this.dag.idToIndex(nArray[n]);
            this.dag.vertexSizes.put(n4, this.dag.vertexSizes.get(n4) + this.vertexSizes.get(n));
            this.dag.dagSizes.put(n4, this.dag.dagSizes.get(n4) + 1);
            IntEnumeration intEnumeration2 = this.edges.elements(n, intEnumeration);
            while (intEnumeration2.hasMoreElements()) {
                int n5 = intEnumeration2.nextInt();
                this.dagIndex[n5] = this.dag.idToIndex(nArray[n5]);
                if (nArray[n] == nArray[n5]) continue;
                this.dag.addEdge(nArray[n], nArray[n5]);
                this.dag.isNotRoot.set(this.dagIndex[n5]);
            }
        }
        for (n = 1; n < this.dag.size; ++n) {
            this.dag.vertexSizes.put(n, this.dag.vertexSizes.get(n) - 1);
            if (this.dag.isNotRoot.get(n)) continue;
            this.dag.addEdgeByIndex(0, n);
        }
        this.dag.complete();
        this.log("end findStrongComponents");
        return this.dag;
    }

    int dagIdToId(int n) {
        return this.dagIdToIds(n)[0];
    }

    int[] dagIdToIds(int n) {
        IntegerArray integerArray = new IntegerArray();
        int n2 = this.dag.idToIndex(n);
        for (int i = 0; i < this.size; ++i) {
            if (this.deleted.get(i) || this.dagIndex[i] != n2) continue;
            integerArray.add(this.vertexIds.get(i));
        }
        return integerArray.toArray();
    }

    boolean isRoot(int n) {
        return !this.dag.isNotRoot.get(this.dagIndex[n]);
    }

    public void print(PrintClient printClient) {
        this.complete();
        this.log("begin analysis");
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        for (int i = 0; i < this.maxroots; ++i) {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (i > 0) {
                System.out.println("");
            }
            System.out.println("*** doing root " + i + " ***");
            System.out.println("");
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            for (n = 0; n < this.size; ++n) {
                this.reach[n] = this.dag.reach[this.dagIndex[n]];
            }
            this.dag = null;
            this.log("after trans closure");
            for (n = 0; n < this.vertexIds.size(); ++n) {
                int n4 = this.reach[n];
                if (n4 <= n3) continue;
                n3 = n4;
                n2 = n;
                this.log("new max " + n4 + " at " + n);
            }
            if (n3 == 0) {
                this.log("no more roots!");
                break;
            }
            n = this.vertexIds.get(n2);
            this.log("max reach = " + n3 + " for vertex " + ReachabilityGraph.hex(n) + " " + printClient.getName(n));
            this.printTree(n);
            this.deleteTree(n2);
        }
    }

    public void print(PrintClient printClient, int n) {
        this.complete();
        this.client = printClient;
        this.log("number of vertexes = " + this.vertexIds.size());
        if (this.calculateReachability) {
            this.findStrongComponents();
            this.dag.transitiveClosure();
            this.reach = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.reach[i] = this.dag.reach[this.dagIndex[i]];
            }
            this.dag = null;
        }
        this.printTree(n);
    }

    public Vertex[] getRoots() {
        this.complete();
        this.findStrongComponents();
        this.dag.transitiveClosure();
        this.reach = this.dag.reach;
        Vector<Vertex> vector = new Vector<Vertex>();
        for (int i = 1; i < this.size; ++i) {
            if (!this.isRoot(i)) continue;
            Vertex vertex = new Vertex(this, i);
            vector.add(vertex);
        }
        return vector.toArray(new Vertex[0]);
    }

    int getBiggestRoot() {
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < this.size; ++i) {
            int n3 = this.reach(i);
            if (n3 <= n) continue;
            n = n3;
            n2 = i;
        }
        if (n2 == -1) {
            return -1;
        }
        return this.id(n2);
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        ReachabilityGraph reachabilityGraph;
        int n2;
        for (n2 = 0; n2 < 3; ++n2) {
            int n3;
            System.out.println("doing " + n2);
            reachabilityGraph = new ReachabilityGraph();
            reachabilityGraph.setRecordParents(true);
            reachabilityGraph.random(n2, 100, 150);
            n = reachabilityGraph.getBiggestRoot();
            if (n == -1) continue;
            reachabilityGraph = (ReachabilityGraph)reachabilityGraph.getSubgraph(n);
            int n4 = reachabilityGraph.idToIndex(n);
            Integer n5 = (Integer)reachabilityGraph.dfs(new Visitor(){
                int n = -1;

                public void enterNode(int n, int n2) {
                    this.n = n;
                }

                public Object result() {
                    return new Integer(this.n);
                }
            }, n4);
            int n6 = reachabilityGraph.vertexIds.get(n5);
            BitSetArray bitSetArray = reachabilityGraph.findDominators(n, n6);
            object = reachabilityGraph.getDominators(n, n6);
            IntEnumeration intEnumeration = bitSetArray.elements();
            while (intEnumeration.hasMoreElements()) {
                n3 = intEnumeration.nextInt();
                n3 = reachabilityGraph.vertexIds.get(n3);
            }
            intEnumeration = ((BitSetArray)object).elements();
            while (intEnumeration.hasMoreElements()) {
                n3 = intEnumeration.nextInt();
                n3 = reachabilityGraph.vertexIds.get(n3);
            }
            if (!bitSetArray.equals(object)) {
                throw new Error("no match!");
            }
            System.out.println("done " + n2);
        }
        n2 = 1;
        while (true) {
            reachabilityGraph = new ReachabilityGraph();
            n = 10000;
            if (stringArray.length > 0) {
                try {
                    n = Integer.parseInt(stringArray[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reachabilityGraph.random(n2, n, n * 3 / 2);
            reachabilityGraph.findStrongComponents();
            reachabilityGraph.dag.uselessmemory = false;
            reachabilityGraph.dag.usebranches = false;
            reachabilityGraph.dag.usecomplex = false;
            reachabilityGraph.dag.onlymedium = false;
            reachabilityGraph.dag.exact = true;
            long l = System.currentTimeMillis();
            reachabilityGraph.dag.transitiveClosure();
            long l2 = System.currentTimeMillis();
            object = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.uselessmemory = true;
            reachabilityGraph.dag.transitiveClosure();
            long l3 = System.currentTimeMillis();
            int[] nArray = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.uselessmemory = false;
            reachabilityGraph.dag.usebranches = true;
            reachabilityGraph.dag.transitiveClosure();
            long l4 = System.currentTimeMillis();
            int[] nArray2 = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.usebranches = false;
            reachabilityGraph.dag.usecomplex = true;
            reachabilityGraph.dag.transitiveClosure();
            long l5 = System.currentTimeMillis();
            int[] nArray3 = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.usecomplex = false;
            reachabilityGraph.dag.onlymedium = true;
            reachabilityGraph.dag.transitiveClosure();
            long l6 = System.currentTimeMillis();
            int[] nArray4 = reachabilityGraph.dag.reach;
            reachabilityGraph.dag.onlymedium = false;
            for (int i = 0; i < reachabilityGraph.dag.size; ++i) {
                if (reachabilityGraph.dag.ignoreNode(i)) continue;
                if (object[i] != nArray[i]) {
                    throw new Error("mismatch at " + i + "! " + (int)object[i] + " compared with " + nArray[i]);
                }
                if (object[i] != nArray2[i]) {
                    // empty if block
                }
                if (object[i] != nArray3[i]) {
                    System.out.println("dag:");
                    System.out.println(reachabilityGraph.dag.toString());
                    throw new Error("mismatch at " + i + "! " + (int)object[i] + " compared with " + nArray3[i]);
                }
                if (object[i] == nArray4[i]) continue;
                System.out.println("dag:");
                System.out.println(reachabilityGraph.dag.toString());
                throw new Error("mismatch at " + i + "! " + (int)object[i] + " compared with " + nArray4[i]);
            }
            System.out.println("done " + n2 + " fast: " + (l2 - l) + " ms, slow: " + (l3 - l2) + " ms, medium: " + (l6 - l5) + " ms, complex: " + (l5 - l4) + " ms, dag size " + reachabilityGraph.dag.size);
            ++n2;
        }
    }
}

