/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PortableHeapDumpListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.Vector;

public class HeapdumpReader
extends Base {
    String filename;
    DataInputStream dis;
    long lastAddress;
    long[] classAddressCache = new long[4];
    int classAddressCacheIndex;
    int totalObjects;
    int totalRefs;
    int version;
    int random1;
    int random2;
    Vector classNames = new Vector();
    PortableHeapDumpListener listener;
    int dumpFlags;
    String full_version = "unknown";
    boolean dbg = false;

    public HeapdumpReader(String string) {
        this.filename = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.dis = new DataInputStream(bufferedInputStream);
            String string2 = this.dis.readUTF();
            if (string2.equals("portable heap dump")) {
                this.version = this.dis.readInt();
                if (this.version != 4) {
                    throw new Error("unexpected version: " + this.version);
                }
            } else {
                throw new Error("bad header in " + string + "!");
            }
            this.dumpFlags = this.dis.readInt();
            int n = this.dis.readUnsignedByte();
            HeapdumpReader.Assert(n == 1);
            if (this.dbg) {
                System.out.println("read start of header tag");
            }
            block8: do {
                n = this.dis.readUnsignedByte();
                switch (n) {
                    case 1: {
                        if (this.dbg) {
                            System.out.println("read totals tag");
                        }
                        this.totalObjects = this.dis.readInt();
                        this.totalRefs = this.dis.readInt();
                        break;
                    }
                    case 2: {
                        if (!this.dbg) continue block8;
                        System.out.println("read end of header tag");
                        break;
                    }
                    case 3: {
                        if (this.dbg) {
                            System.out.println("read hashcodes tag");
                        }
                        this.random1 = this.dis.readInt();
                        this.random2 = this.dis.readInt();
                        break;
                    }
                    case 4: {
                        if (this.dbg) {
                            System.out.println("read full version tag");
                        }
                        this.full_version = this.dis.readUTF();
                        break;
                    }
                    default: {
                        throw new Error("unrecognized tag: " + n);
                    }
                }
            } while (n != 2);
            n = this.dis.readUnsignedByte();
            HeapdumpReader.Assert(n == 2);
            if (this.dbg) {
                System.out.println("read start of dump tag");
            }
        }
        catch (Exception exception) {
            throw new Error("unexpected error: " + exception);
        }
    }

    public String full_version() {
        return this.full_version;
    }

    public int version() {
        return this.version;
    }

    int Handle2Hash(long l) {
        return (int)(l >>> 3);
    }

    int ROTATE(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    int MANGLE(int n) {
        return (this.ROTATE(n ^ this.random1, 17) ^ this.random2) >>> 1;
    }

    int getHashCode(long l, int n) throws Exception {
        if (this.dbg) {
            System.out.println("request to getHashCode");
        }
        if ((this.dumpFlags & 4) != 0) {
            return this.dis.readShort();
        }
        if (n != 0) {
            return this.dis.readInt();
        }
        return this.MANGLE(this.Handle2Hash(l));
    }

    long readWord() throws Exception {
        if ((this.dumpFlags & 1) != 0) {
            return this.dis.readLong();
        }
        return this.dis.readInt();
    }

    long[] readRefs(long l, int n, int n2) throws Exception {
        long[] lArray = new long[n];
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            l2 = n2 == 0 ? (long)(this.dis.readByte() << 3) : (n2 == 1 ? (long)(this.dis.readShort() << 3) : (n2 == 2 ? (long)(this.dis.readInt() << 3) : this.dis.readLong() << 3));
            lArray[i] = l + l2;
            if (!this.dbg) continue;
            System.out.println("read ref with gap " + HeapdumpReader.hex(l2));
        }
        return lArray;
    }

    long getRelativeAddress(int n) {
        try {
            switch (n) {
                case 0: {
                    return this.lastAddress + (long)(this.dis.readByte() << 3);
                }
                case 1: {
                    return this.lastAddress + (long)(this.dis.readShort() << 3);
                }
                case 2: {
                    return this.lastAddress + (long)(this.dis.readInt() << 3);
                }
                case 3: {
                    return this.lastAddress + (this.dis.readLong() << 3);
                }
            }
        }
        catch (Exception exception) {
            throw new Error("unexpected error: " + exception);
        }
        throw new Error("impossible");
    }

    public void parse(PortableHeapDumpListener portableHeapDumpListener) {
        this.listener = portableHeapDumpListener;
        long l = 0L;
        long l2 = 0L;
        long[] lArray = null;
        try {
            while (true) {
                int n;
                int n2;
                int n3 = this.dis.readUnsignedByte();
                if (this.dbg) {
                    System.out.println("read tag " + HeapdumpReader.hex(n3));
                }
                if ((n3 & 0x80) != 0) {
                    long l3 = this.classAddressCache[(n3 &= 0x7F) >> 5];
                    n2 = n3 >> 3 & 3;
                    int n4 = n3 & 3;
                    l = this.getRelativeAddress(n3 >> 2 & 1);
                    n = this.getHashCode(l, 0);
                    lArray = this.readRefs(l, n2, n4);
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": short object, class = " + HeapdumpReader.hex(l3));
                    }
                    portableHeapDumpListener.objectDump(l, l3, 0, n, lArray);
                } else if ((n3 & 0x40) != 0) {
                    long l4;
                    int n5 = (n3 &= 0x3F) >> 3;
                    int n6 = n3 & 3;
                    l = this.getRelativeAddress(n3 >> 2 & 1);
                    this.classAddressCache[this.classAddressCacheIndex] = l4 = this.readWord();
                    this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
                    n = this.getHashCode(l, 0);
                    lArray = this.readRefs(l, n5, n6);
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": medium object");
                    }
                    portableHeapDumpListener.objectDump(l, l4, 0, n, lArray);
                } else if ((n3 & 0x20) != 0) {
                    int n7 = n3 >> 2 & 7;
                    int n8 = n3 & 3;
                    l = this.getRelativeAddress(n8);
                    n2 = 0;
                    n2 = n8 == 0 ? this.dis.readUnsignedByte() : (n8 == 1 ? this.dis.readUnsignedShort() : (n8 == 2 ? this.dis.readInt() : (int)this.dis.readLong()));
                    int n9 = this.getHashCode(l, 0);
                    if (this.dbg) {
                        System.out.println(HeapdumpReader.hex(l) + ": primitive array of length " + n2);
                    }
                    portableHeapDumpListener.primitiveArrayDump(l, n7, n2, 0, n9);
                } else {
                    switch (n3) {
                        case 3: {
                            return;
                        }
                        case 4: {
                            long l5;
                            int n10 = this.dis.readUnsignedByte();
                            l = this.getRelativeAddress(n10 >> 6 & 3);
                            this.classAddressCache[this.classAddressCacheIndex] = l5 = this.readWord();
                            this.classAddressCacheIndex = (this.classAddressCacheIndex + 1) % 4;
                            int n11 = this.getHashCode(l, n10 & 2);
                            n = this.dis.readInt();
                            int n12 = n10 >> 4 & 3;
                            if (this.dbg) {
                                System.out.println(HeapdumpReader.hex(l) + ": long object, hash code = " + HeapdumpReader.hex(n11) + " flags = " + HeapdumpReader.hex(n10) + " class = " + HeapdumpReader.hex(l5) + " numRefs = " + n);
                            }
                            lArray = this.readRefs(l, n, n12);
                            portableHeapDumpListener.objectDump(l, l5, 0, n11, lArray);
                            break;
                        }
                        case 5: {
                            int n13 = this.dis.readUnsignedByte();
                            l = this.getRelativeAddress(n13 >> 6 & 3);
                            long l6 = this.readWord();
                            int n14 = this.getHashCode(l, n13 & 2);
                            n = this.dis.readInt();
                            int n15 = n13 >> 4 & 3;
                            if (this.dbg) {
                                System.out.println(HeapdumpReader.hex(l) + ": object array, num refs = " + n);
                            }
                            lArray = this.readRefs(l, n, n15);
                            portableHeapDumpListener.objectArrayDump(l, l6, 0, n14, lArray);
                            break;
                        }
                        case 6: {
                            int n16 = this.dis.readUnsignedByte();
                            l = this.getRelativeAddress(n16 >> 6 & 3);
                            int n17 = this.dis.readInt();
                            n2 = this.getHashCode(l, n16 & 8);
                            long l7 = this.readWord();
                            if (this.dbg) {
                                System.out.println(HeapdumpReader.hex(l) + ": class flags = " + HeapdumpReader.hex(n16) + " instanceSize = " + n17 + " hashCode = " + HeapdumpReader.hex(n2) + " superAddress = " + HeapdumpReader.hex(l7));
                            }
                            String string = this.dis.readUTF();
                            if (this.dbg) {
                                System.out.println(HeapdumpReader.hex(l) + ": class " + string);
                            }
                            int n18 = this.dis.readInt();
                            int n19 = n16 >> 4 & 3;
                            lArray = this.readRefs(l, n18, n19);
                            portableHeapDumpListener.classDump(l, l7, string, n17, 0, n2, lArray);
                            break;
                        }
                        case 7: {
                            int n20 = this.dis.readUnsignedByte();
                            int n21 = n20 >>> 5;
                            n2 = 0;
                            if ((n20 & 0x10) == 0) {
                                l = this.lastAddress + (long)(this.dis.readByte() << 3);
                                n2 = this.dis.readUnsignedByte();
                            } else {
                                l = this.lastAddress + (this.readWord() << 3);
                                n2 = (int)this.readWord();
                            }
                            int n22 = this.getHashCode(l, n20 & 2);
                            if (this.dbg) {
                                System.out.println(HeapdumpReader.hex(l) + ": primitive array");
                            }
                            portableHeapDumpListener.primitiveArrayDump(l, n21, n2, 0, n22);
                            break;
                        }
                        default: {
                            throw new Error("unexpected tag: " + n3);
                        }
                    }
                }
                this.lastAddress = l;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("unexpected error: " + exception);
        }
    }

    String className() {
        return "HeapdumpReader";
    }
}

