/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;

public abstract class Base {
    static DateFormat df = DateFormat.getTimeInstance();
    static boolean xml = false;
    static boolean verbose = false;
    static boolean debug = false;
    static HashMap frozenObjects = new HashMap();

    public final void log(String string) {
        Base._log(string);
    }

    static final void _log(String string) {
        if (!Base.verbose()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        String string2 = df.format(calendar.getTime());
        if (xml) {
            System.out.println("<log time='" + string2 + "'>" + string + "</log>");
        } else {
            System.out.println(string2 + ": " + string);
        }
    }

    public static boolean verbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static boolean debug() {
        return debug;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public final void trace(String string) {
        if (!Base.debug()) {
            return;
        }
        System.out.println(string);
    }

    public static void Assert(boolean bl) {
        if (!bl) {
            throw new Error("assert failed!");
        }
    }

    public static String hex(int n) {
        return Integer.toHexString(n);
    }

    public static String hex(long l) {
        return Long.toHexString(l);
    }

    String[] options() {
        return null;
    }

    String[] optionDescriptions() {
        return null;
    }

    boolean parseOption(String string, String string2) {
        return false;
    }

    abstract String className();

    void usage() {
        int n;
        System.err.print("Usage: java com.ibm.jvm.findroots." + this.className());
        if (this.options() != null) {
            for (n = 0; n < this.options().length; ++n) {
                System.err.print(" " + this.options()[n]);
            }
        }
        System.err.println(" <filename>");
        if (this.options() != null && this.optionDescriptions() != null) {
            for (n = 0; n < this.options().length; ++n) {
                System.err.println("\t" + this.options()[n] + "\t" + this.optionDescriptions()[n]);
            }
        }
        System.exit(1);
    }

    void parseOptions(String[] stringArray) {
        if (stringArray.length == 0) {
            this.usage();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) != '-') continue;
            if (stringArray[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (this.parseOption(stringArray[i], stringArray[i + 1])) continue;
            this.usage();
        }
    }

    static void freeze(Object object, String string) {
        Base._log("freeze " + string);
        try {
            File file = File.createTempFile("tmp", ".freeze");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            frozenObjects.put(string, file);
            Base._log("freeze " + string + " complete");
        }
        catch (Exception exception) {
            throw new Error("Error freezing object: " + exception);
        }
    }

    static Object unfreeze(String string) {
        Base._log("unfreeze " + string);
        try {
            File file = (File)frozenObjects.get(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            frozenObjects.remove(string);
            file.delete();
            Base._log("unfreeze " + string + " complete");
            return object;
        }
        catch (Exception exception) {
            throw new Error("Error unfreezing object: " + exception);
        }
    }
}

