/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class SdffStd {
    public long sectionLen;
    public long sectionType;
    public byte[] sectionEye = new byte[8];
    public long sectionVer;

    public static long getSize() {
        return 32L;
    }

    public SdffStd(long l, long l2) {
        String[] stringArray = new String[]{SdffConstants.SEGMENT_Eye_SdffHead, SdffConstants.SEGMENT_Eye_SdffPrth, SdffConstants.SEGMENT_Eye_SdffMmem, SdffConstants.SEGMENT_Eye_SdffMem, SdffConstants.SEGMENT_Eye_SdffRas};
        this.sectionType = l;
        this.sectionEye = stringArray[(int)l].getBytes();
        this.sectionVer = l2;
    }

    public SdffStd(byte[] byArray) throws IOException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.sectionLen = dataInputStream.readLong();
            this.sectionType = dataInputStream.readLong();
            dataInputStream.readFully(this.sectionEye);
            this.sectionVer = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            System.out.println("\nIn IOException for SdffStd");
            throw iOException;
        }
    }

    public boolean checkMatch() {
        DvUtils.writetoTrace(" SdffStd:checkMatch entry");
        boolean bl = true;
        String string = new String(this.sectionEye);
        if (string.equals(SdffConstants.SEGMENT_Eye_SdffHead)) {
            DvUtils.writetoTrace(" SdffStd:checkMatch SDFFHEAD segment found");
            if ((int)this.sectionType != SdffConstants.SEGMENT_SdffHead) {
                DvUtils.writetoTrace(" SdffStd:checkMatch SDFFHEAD section type mismatch");
                bl = false;
            }
        } else if (string.equals(SdffConstants.SEGMENT_Eye_SdffPrth)) {
            DvUtils.writetoTrace(" SdffStd:checkMatch SDFFPRTH segment found");
            if ((int)this.sectionType != SdffConstants.SEGMENT_Sdffprth) {
                DvUtils.writetoTrace(" SdffStd:checkMatch SDFFPRTH section type mismatch");
                bl = false;
            }
        } else if (string.equals(SdffConstants.SEGMENT_Eye_SdffMmem)) {
            DvUtils.writetoTrace(" SdffStd:checkMatch SDFFMMAP segment found");
            if ((int)this.sectionType != SdffConstants.SEGMENT_Sdffmmap) {
                DvUtils.writetoTrace(" SdffStd:checkMatch SDFFMMAP section type mismatch");
                bl = false;
            }
        } else if (string.equals(SdffConstants.SEGMENT_Eye_SdffMem)) {
            DvUtils.writetoTrace(" SdffStd:checkMatch SDFFMEM segment found");
            if ((int)this.sectionType != SdffConstants.SEGMENT_Sdffmem) {
                DvUtils.writetoTrace(" SdffStd:checkMatch SDFFMEM section type mismatch");
                bl = false;
            }
        } else if (string.equals(SdffConstants.SEGMENT_Eye_SdffRas)) {
            DvUtils.writetoTrace(" SdffStd:checkMatch SDFFRAS segment found");
            if ((int)this.sectionType != SdffConstants.SEGMENT_SdffRas) {
                DvUtils.writetoTrace(" SdffStd:checkMatch SDFFRAS section type mismatch");
                bl = false;
            }
        } else {
            bl = false;
        }
        DvUtils.writetoTrace(" SdffStd:checkMatch exit");
        return bl;
    }

    public void printSdff(Sdff sdff) throws IOException {
        DvUtils.writetoTrace("Writing SdffStd");
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeLong(this.sectionType);
        sdff.write(this.sectionEye);
        sdff.writeLong(this.sectionVer);
        sdff.printLength(l);
    }
}

