/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvNativeStack;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SDFFNativeStack
extends DvNativeStack {
    private long length = 64L;
    private byte[] eyecatcher = new byte[]{78, 83, 84, 65, 67, 75, 84, 82};
    private byte[] spare = new byte[32];
    private long nullMetaData = -1L;
    private byte[] metadata;
    private DvNativeFrame[] nativeFrames;

    public SDFFNativeStack() {
    }

    public SDFFNativeStack(DvNativeFrame[] dvNativeFrameArray) {
        super(dvNativeFrameArray);
        int n;
        for (n = 0; n < this.spare.length; ++n) {
            this.spare[n] = 127;
        }
        this.nativeFrames = dvNativeFrameArray;
        if (this.nativeFrames != null) {
            for (n = 0; n < this.nativeFrames.length; ++n) {
                this.length += 40L;
                if (this.nativeFrames[n].getName() == null) continue;
                this.length += (long)this.nativeFrames[n].getName().length;
            }
        }
    }

    public long getLength() {
        return this.length;
    }

    public void printSdff(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.writeLong(this.length);
            randomAccessFile.write(this.eyecatcher);
            randomAccessFile.writeLong(this.nativeFrames == null ? 0L : (long)this.nativeFrames.length);
            if (this.nativeFrames != null) {
                for (int i = 0; i < this.nativeFrames.length; ++i) {
                    randomAccessFile.writeLong(this.nativeFrames[i].getMb());
                    randomAccessFile.writeLong(this.nativeFrames[i].getPc());
                    randomAccessFile.writeLong(this.nativeFrames[i].getSp());
                    randomAccessFile.writeLong(this.nativeFrames[i].getFrameType());
                    if (this.nativeFrames[i].getName() != null) {
                        randomAccessFile.writeLong(this.nativeFrames[i].getName().length);
                        randomAccessFile.write(this.nativeFrames[i].getName());
                        continue;
                    }
                    randomAccessFile.writeLong(0L);
                }
            }
            randomAccessFile.write(this.spare);
            randomAccessFile.writeLong(this.nullMetaData);
        }
        catch (Exception exception) {
            System.out.println("Error dumping NSTACKTR section");
            return;
        }
    }

    public static SDFFNativeStack loadFromFile(long l, RandomAccessFile randomAccessFile) {
        DvUtils.writetoTrace("Entry to SDFFNativeStack:loadFromFile...");
        long l2 = l;
        DvUtils.writetoTrace("  .... Loading SDFFRegister object from file :" + l);
        SDFFNativeStack sDFFNativeStack = new SDFFNativeStack();
        try {
            randomAccessFile.seek(l2);
            long l3 = randomAccessFile.readLong();
            randomAccessFile.skipBytes(8);
            randomAccessFile.seek(l2 + l3 - 8L);
            long l4 = randomAccessFile.readLong();
            if (l4 != -1L) {
                sDFFNativeStack.metadata = new byte[(int)l4];
                randomAccessFile.seek(l2 + l3 - 8L - l4);
                randomAccessFile.read(sDFFNativeStack.metadata);
                String string = new String(sDFFNativeStack.metadata);
                System.out.println("nstackmd:" + string);
            }
            randomAccessFile.seek(l2 + 16L);
            int n = (int)randomAccessFile.readLong();
            DvNativeFrame[] dvNativeFrameArray = new DvNativeFrame[n];
            if (n == 0 || dvNativeFrameArray == null) {
                return sDFFNativeStack;
            }
            for (int i = 0; i < n; ++i) {
                dvNativeFrameArray[i] = new DvNativeFrame();
                dvNativeFrameArray[i].setMb(randomAccessFile.readLong());
                dvNativeFrameArray[i].setPc(randomAccessFile.readLong());
                dvNativeFrameArray[i].setSp(randomAccessFile.readLong());
                dvNativeFrameArray[i].setFrameType((int)randomAccessFile.readLong());
                int n2 = (int)randomAccessFile.readLong();
                if (n2 <= 0) continue;
                byte[] byArray = new byte[n2];
                if (byArray != null) {
                    randomAccessFile.read(byArray);
                }
                dvNativeFrameArray[i].setName(byArray);
            }
            sDFFNativeStack.setFrames(dvNativeFrameArray);
        }
        catch (IOException iOException) {
            DvUtils.errorMsg("IOException in SDFFNativeStack: loadFromFile", 0);
        }
        DvUtils.writetoTrace("Exit from SDFFNativeStack:loadFromFile");
        return sDFFNativeStack;
    }
}

