/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFClock;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.SdffConstants;
import com.ibm.jvm.dump.sdff.SdffStd;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SDFFMemoryMap {
    public Vector segments = new Vector(50);

    public SDFFMemoryMap() {
    }

    public SDFFMemoryMap(DvFileReader dvFileReader, SDFFDump sDFFDump) throws IOException {
    }

    public void printSdff(Sdff sdff) throws IOException {
        long l = sdff.getFilePointer();
        SdffStd sdffStd = new SdffStd(SdffConstants.SEGMENT_Sdffmmap, SdffConstants.VERSION1_0_0);
        sdffStd.printSdff(sdff);
        Enumeration enumeration = this.segments.elements();
        while (enumeration.hasMoreElements()) {
            Segment segment = (Segment)enumeration.nextElement();
            segment.printSdff(sdff);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }

    public void printMemory(Sdff sdff, DvFileReader dvFileReader) throws IOException {
        SDFFClock sDFFClock = new SDFFClock("Copying dump data ... ", 10);
        long l = sdff.getFilePointer();
        SdffStd sdffStd = new SdffStd(SdffConstants.SEGMENT_Sdffmem, SdffConstants.VERSION1_0_0);
        sdffStd.printSdff(sdff);
        sdff.fixupMap();
        dvFileReader.setPos(0L);
        int n = 32768;
        byte[] byArray = new byte[n];
        for (long i = dvFileReader.core.length(); i > 0L; i -= (long)byArray.length) {
            if (i < (long)n) {
                byArray = new byte[(int)i];
            }
            dvFileReader.read(byArray);
            sdff.write(byArray);
            sDFFClock.tick();
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
        System.err.print('\n');
    }

    public void printLoaded(Sdff sdff) throws IOException {
        DvUtils.trace("Printing Loaded", 0, false);
        sdff.align(4);
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes("LOADED  ");
        Enumeration enumeration = this.segments.elements();
        while (enumeration.hasMoreElements()) {
            Segment segment = (Segment)enumeration.nextElement();
            if (segment.moduleType != 1) continue;
            segment.printSdffLoaded(sdff);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

