/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.dump.plugins.DvClassCommands;
import com.ibm.jvm.dump.plugins.DvObjectsCommands;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class DvHeapDumpPlugin
extends CommandPlugin {
    static int ptrSize = 0;
    private static String thisName = "com.ibm.jvm.dump.plugins.DvHeapDumpPlugin";
    private static DvHeapDumpPlugin selfRef;
    private static String[] commandsSupported;

    public DvHeapDumpPlugin() {
        selfRef = this;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public String pluginName() {
        return "Heap Dump Plugin";
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvHeapDumpPlugin.properties");
        return vector;
    }

    public void doHDHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("HDHelp", "DvHeapDumpPlugin.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    private void doHeapDump(PrintStream printStream) throws Exception {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.produceHeapDump");
        if (ptrSize == 0) {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            ptrSize = dvAddressSpace.pointerSize();
        }
        printStream.println("// JFormat dump generated " + new Date() + " from '" + DvUtils.getValue("DUMP") + "'" + " (" + DvConsole.fullVersion + ")");
        int n = this.dumpObjects(printStream);
        String string = new Date() + ": " + "All " + n + " objects done.";
        this.cpr.output("\t" + string + " Closing file ...");
        printStream.println("// " + string);
        printStream.close();
        this.cpr.output("Heap Dump finished.");
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:DvObjectsCommands.produceHeapDump");
    }

    public void doHeapDumpNet() throws Exception {
        PrintStream printStream;
        String string;
        int n = 21179;
        String string2 = DvUtils.getValue("HD_HOST");
        if (string2 == null) {
            string2 = new String("localhost");
        }
        if ((string = DvUtils.getValue("HD_PORT")) != null) {
            try {
                n = Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                this.cpr.output("Invalid port specified (HD_PORT): " + string);
                this.forcedEnd = true;
                return;
            }
        }
        try {
            this.cpr.output(new Date() + ": " + "Connecting to " + string2 + ":" + n + " ...");
            printStream = this.getNetworkPrintStream(string2, n);
        }
        catch (IOException iOException) {
            this.cpr.output("Caught exception : " + iOException.toString());
            this.forcedEnd = true;
            return;
        }
        this.doHeapDump(printStream);
    }

    private String getHeapDumpFilename() {
        String string = DvUtils.getValue("DUMP");
        if (string.startsWith("sdff.")) {
            string = string.substring(5);
        }
        return string + ".txt.gz";
    }

    public void doHeapDumpFile() throws Exception {
        PrintStream printStream;
        String string = this.getHeapDumpFilename();
        try {
            this.cpr.output(new Date() + ": " + "Opening '" + string + "' to write heapdump ...");
            printStream = DvHeapDumpPlugin.getFilePrintStream(string);
        }
        catch (IOException iOException) {
            this.cpr.output("Caught exception : " + iOException.toString());
            this.forcedEnd = true;
            return;
        }
        this.doHeapDump(printStream);
    }

    private static PrintStream getFilePrintStream(String string) throws IOException {
        return new PrintStream(new GZIPOutputStream(new FileOutputStream(string)));
    }

    private PrintStream getNetworkPrintStream(String string, int n) throws IOException {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
        }
        catch (Exception exception) {
            this.cpr.output(" !!! Failure connecting to " + string + ":" + n);
            this.cpr.output("Caught exception : " + exception.toString());
        }
        if (socket != null) {
            this.cpr.output(new Date() + ": Connected ");
        }
        OutputStream outputStream = socket.getOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("// FORMAT=.txt.gz");
        printStream.flush();
        PrintStream printStream2 = new PrintStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));
        return printStream2;
    }

    private int dumpObjects(PrintStream printStream) {
        Vector vector = DvObjectsCommands.namesIndexFile.getAllClassNames();
        String string = "";
        int[] nArray = null;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            long l = 0L;
            long[] lArray = DvObjectsCommands.namesIndexFile.getInstancesForClass(string2);
            if (!string2.startsWith("array ")) {
                if (!string2.equals(string)) {
                    l = DvObjectsCommands.namesIndexFile.getInstanceSizeForClass(string2);
                    nArray = DvClassCommands.getClassRefOfsets(string2, DvConsole.theDump);
                    string = string2;
                }
            } else {
                nArray = null;
            }
            long l2 = 0L;
            if (null != lArray) {
                for (int j = 0; j < lArray.length; ++j) {
                    l2 = 0L;
                    if (string2.startsWith("arrObj ") || string2.startsWith("array ")) {
                        if (ptrSize == 8) {
                            l2 += 12L;
                        }
                        try {
                            l = dvAddressSpace.readInt(dvAddressSpace.createAddress(lArray[j] + l2));
                            System.err.println("Length of array is " + l + " offset = " + Long.toHexString(lArray[j] + l2));
                        }
                        catch (DvAddressException dvAddressException) {
                            // empty catch block
                        }
                    }
                    String string3 = "0x" + DvUtils.rJustifyZ(Long.toHexString(lArray[j] + (long)ptrSize), 8) + " [" + l + "] " + string2;
                    if (++n % 65536 == 0) {
                        this.cpr.output("\t" + new Date() + ": " + n + " objects done ...");
                    }
                    printStream.println(string3);
                    String string4 = "\t";
                    if (null != nArray) {
                        string4 = string4 + this.formatRefs(dvAddressSpace, nArray, lArray[j]);
                    } else if (string2.startsWith("arrObj ")) {
                        string4 = string4 + this.formatArrayRefs(dvAddressSpace, lArray[j]);
                    }
                    printStream.println(string4);
                }
                continue;
            }
            this.cpr.output("Null Instance List for : '" + string2 + "'");
        }
        return n;
    }

    private String formatArrayRefs(DvAddressSpace dvAddressSpace, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        DvAddress dvAddress = dvAddressSpace.createAddress(l + (long)(2 * ptrSize) - 4L);
        try {
            n = dvAddressSpace.readInt(dvAddress);
            dvAddress.offsetBy(4 + ptrSize);
        }
        catch (DvAddressException dvAddressException) {
            dvAddressException.printStackTrace();
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                long l2 = 0L;
                try {
                    l2 = dvAddressSpace.readPointer(dvAddress).getAddressAsLong();
                    if (l2 != 0L) {
                        stringBuffer.append(" 0x");
                        stringBuffer.append(Long.toHexString(l2));
                    }
                    dvAddress.offsetBy(ptrSize);
                    continue;
                }
                catch (DvAddressException dvAddressException) {
                    dvAddressException.printStackTrace();
                }
            }
        }
        return stringBuffer.toString();
    }

    private String formatRefs(DvAddressSpace dvAddressSpace, int[] nArray, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            long l2 = 0L;
            DvAddress dvAddress = dvAddressSpace.createAddress(l + (long)(3 * ptrSize) + (long)nArray[i]);
            try {
                l2 = dvAddressSpace.readPointer(dvAddress).getAddressAsLong();
            }
            catch (DvAddressException dvAddressException) {
                dvAddressException.printStackTrace();
            }
            if (0L == l2) continue;
            stringBuffer.append(" 0x");
            stringBuffer.append(Long.toHexString(l2));
        }
        return new String(stringBuffer);
    }

    private String doHeapDump(String string) {
        return null;
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String help() {
        return "HEAPHELP";
    }

    public String help(String string) {
        return "HEAPHELP2";
    }

    public void doHDHost() throws Exception {
        String string = "localhost";
        if (this.paramString != null) {
            string = new String(this.paramString);
        }
        DvUtils.setValue("HD_HOST", string);
        this.cpr.output("\nHD_HOST set to " + string + "\n");
        this.forcedEnd = true;
    }

    public void doHDPort() throws Exception {
        String string = "21179";
        int n = 0;
        if (this.paramString != null) {
            string = new String(this.paramString);
        }
        try {
            n = Integer.parseInt(string, 10);
            if (n <= 0) {
                n = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n != 0) {
            DvUtils.setValue("HD_PORT", string);
            this.cpr.output("\nHD_PORT set to " + string + "\n");
        } else {
            this.cpr.output("\n !!! HD_PORT unchanged (invalid input)\n");
        }
        this.forcedEnd = true;
    }

    static {
        commandsSupported = new String[]{"HEAPDUMP,HD,FILE,F,doHeapDumpFile,Y,Y", "HEAPDUMP,HD,NET,N,doHeapDumpNet,Y,Y", "HELP,?,HEAPDUMP,HD,doHDHelp,N,N", "HEAPDUMP,HD,help,?,doHDHelp,N,N", "HEAPDUMP,HD,PORT,P,doHDPort,N,N", "HEAPDUMP,HD,HOST,H,doHDHost,N,N"};
    }
}

