/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import java.io.RandomAccessFile;

public class ReaderProxy {
    RandomAccessFile memory;
    byte[] buffer = new byte[1];
    int bufferPos;
    long memoryLocation;
    DvAddressSpace space;
    int bufferLength;
    static int margin = 96;
    static int ListSize = 4;

    public ReaderProxy(DvAddressSpace dvAddressSpace) {
        this.space = dvAddressSpace;
    }

    private ReaderProxy(DvAddressSpace dvAddressSpace, DvAddress dvAddress) throws DvAddressException {
        this.space = dvAddressSpace;
        this.buffer = dvAddressSpace.readBytes(dvAddress, 2048L);
        this.memoryLocation = dvAddress.getAddressAsLong();
        this.bufferLength = this.buffer.length;
    }

    public static ReaderProxy getProxy(ReaderProxy readerProxy, DvAddress dvAddress) throws DvAddressException {
        if (readerProxy.inRange(dvAddress, margin)) {
            return readerProxy;
        }
        return new ReaderProxy(readerProxy.space, dvAddress);
    }

    private boolean inRange(DvAddress dvAddress, int n) {
        long l = dvAddress.getAddressAsLong();
        return l >= this.memoryLocation && l + (long)n - this.memoryLocation < (long)this.bufferLength;
    }

    public byte readByte(DvAddress dvAddress) throws DvAddressException {
        return (byte)(0xFFL & this.readNumeric(dvAddress, 1));
    }

    public short readShort(DvAddress dvAddress) throws DvAddressException {
        return (short)(0xFFFFL & this.readNumeric(dvAddress, 2));
    }

    public int readInt(DvAddress dvAddress) throws DvAddressException {
        return (int)(0xFFFFFFFFL & this.readNumeric(dvAddress, 4));
    }

    public long readLong(DvAddress dvAddress) throws DvAddressException {
        return this.readNumeric(dvAddress, 8);
    }

    public long readPointer(DvAddress dvAddress) throws DvAddressException {
        return this.readNumeric(dvAddress, this.space.pointerSize());
    }

    public long readNumeric(DvAddress dvAddress, int n) throws DvAddressException {
        long l;
        if (this.inRange(dvAddress, n)) {
            byte[] byArray = new byte[n];
            int n2 = (int)(dvAddress.getAddressAsLong() - this.memoryLocation);
            System.arraycopy(this.buffer, n2, byArray, 0, n);
            l = this.space.wordType().toLong(byArray);
        } else {
            l = this.space.readNumeric(dvAddress, n);
        }
        return l;
    }

    public byte[] readBytes(DvAddress dvAddress, int n) throws DvAddressException {
        byte[] byArray = new byte[n];
        if (this.inRange(dvAddress, n)) {
            int n2 = (int)(dvAddress.getAddressAsLong() - this.memoryLocation);
            System.arraycopy(this.buffer, n2, byArray, 0, n);
        } else {
            byArray = this.space.readBytes(dvAddress, (long)n);
        }
        return byArray;
    }

    public DvAddressSpace getSpace() {
        return this.space;
    }
}

