/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.JavaFrame;
import java.io.UnsupportedEncodingException;

public class DvJavaFrame {
    protected long mb;
    protected long pc;
    protected long sp;
    protected long args;
    protected long vars;
    protected int frameType;
    protected int nameLen;
    protected byte[] name;

    public long frameid() {
        return this.sp;
    }

    public DvAddress spAddress() {
        return new DvAddress(this.sp);
    }

    public DvAddress mbAddress() {
        return new DvAddress(this.mb);
    }

    public DvAddress pcAddress() {
        return new DvAddress(this.pc);
    }

    public DvAddress argsAddress() {
        return new DvAddress(this.args);
    }

    public DvAddress varsAddress() {
        return new DvAddress(this.vars);
    }

    public DvJavaFrame(JavaFrame javaFrame) {
        this.mb = javaFrame.getMb();
        this.pc = javaFrame.getPc();
        this.sp = javaFrame.getSp();
        this.args = javaFrame.getArgs();
        this.vars = javaFrame.getVars();
        this.frameType = javaFrame.getFrameType();
        this.name = javaFrame.getName();
        this.nameLen = javaFrame.getName() == null ? 0 : javaFrame.getName().length;
    }

    public DvJavaFrame() {
    }

    public boolean isJit() {
        return this.frameType == 2;
    }

    public boolean isNative() {
        return this.frameType == 3;
    }

    public boolean isMmi() {
        return this.frameType == 0;
    }

    public boolean isJava() {
        return this.frameType == 1;
    }

    public boolean isPseudo() {
        return this.mb == 0L;
    }

    public byte[] getMetadata() {
        return null;
    }

    public void setMb(long l) {
        this.mb = l;
    }

    public void setPc(long l) {
        this.pc = l;
    }

    public void setSp(long l) {
        this.sp = l;
    }

    public void setArgs(long l) {
        this.args = l;
    }

    public void setVars(long l) {
        this.vars = l;
    }

    public void setName(byte[] byArray) {
        this.name = byArray;
    }

    public void setFrameType(int n) {
        this.frameType = n;
    }

    public long getMb() {
        return this.mb;
    }

    public long getPc() {
        return this.pc;
    }

    public long getSp() {
        return this.sp;
    }

    public long getArgs() {
        return this.args;
    }

    public long getVars() {
        return this.vars;
    }

    public byte[] getName() {
        return this.name;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public String toString() {
        if (this.name == null) {
            return "pseudo frame";
        }
        String string = "";
        try {
            string = new String(this.name, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DvUtils.writetoTrace(" DvJavaFrame:toString() - ASCII encoding not found");
            string = new String(this.name);
        }
        return string;
    }
}

