/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.ContextManagerPlatformInterface;
import javax.security.auth.Subject;

public final class SyncToOSThreadHelper {
    private static final TraceComponent tc = Tr.register((Class)SyncToOSThreadHelper.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private ContextManagerPlatformInterface _contextManager = null;
    private WSLoginLocalOSExtension _localSecurity = null;
    private boolean _syncEnabled = false;

    public SyncToOSThreadHelper() {
        ContextManager contextManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) instanceof ContextManagerPlatformInterface) {
            this._contextManager = (ContextManagerPlatformInterface)contextManager;
            if (this._contextManager.processIsServer()) {
                this._localSecurity = WSLoginLocalOSExtensionFactory.getInstance();
            }
        }
        if (this._localSecurity != null) {
            this._syncEnabled = this._localSecurity.isApplicationSyncToOSThreadEnabled();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public Object setAppSyncToThread(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAppSynctothread", (Object)subject);
        }
        Object object = null;
        if (this._syncEnabled) {
            object = this._localSecurity.setAppLocalOSThreadID(subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAppSyncToThread", (Object)object);
        }
        return object;
    }

    public void restoreAppSyncToThread(Object object) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreAppSyncToThread", (Object)object);
        }
        if (object != null && this._syncEnabled) {
            this._localSecurity.restoreAppLocalOSThreadID(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"restoreAppSyncToThread");
        }
    }

    public boolean isThreadLocalApplicationSyncEnabled() {
        boolean bl = false;
        if (this._syncEnabled) {
            bl = this._localSecurity.isThreadLocalApplicationSyncEnabled();
        }
        return bl;
    }

    public void setThreadLocalApplicationSyncEnabled(boolean bl) {
        if (this._syncEnabled) {
            this._localSecurity.setThreadLocalApplicationSyncEnabled(bl);
        }
    }

    public boolean isCurrentComponentAppSyncEnabled() {
        boolean bl = false;
        if (this._syncEnabled) {
            bl = this._localSecurity.getAppSyncEnabledFromComponentMetaData();
        }
        return bl;
    }
}

