/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.SASPropFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropFilePasswordEncoder {
    public static void main(String[] stringArray) {
        Object object;
        int n;
        Object object2;
        File file;
        if (stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null) {
            System.out.println("USAGE:  java PropFilePasswordEncoder file_name password_properties_list");
            System.out.println("        java PropFilePasswordEncoder file_name -SAS");
            System.exit(1);
        }
        String string = stringArray[0].trim();
        String string2 = stringArray[1].trim();
        if (string.length() == 0 || string2.length() == 0) {
            System.out.println("USAGE:  java PropFilePasswordEncoder file_name password_properties_list");
            System.out.println("        java PropFilePasswordEncoder file_name -SAS");
            System.exit(1);
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        if (!file.exists()) {
            System.out.println("ERROR:  invalid target file == " + file.toString());
            System.exit(1);
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.util.PropFilePasswordEncoder.main", (String)"96");
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.security.util.PropFilePasswordEncoder.main", (String)"105");
                }
            }
            System.out.println("ERROR:  cannot load properties from target file == " + file.toString());
            System.exit(1);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string2.equalsIgnoreCase("-SAS")) {
            bl2 = true;
            try {
                bl = SASPropFile.encodePropPasswords((Properties)properties);
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                FFDCFilter.processException((Throwable)invalidPasswordEncodingException, (String)"com.ibm.ws.security.util.PropFilePasswordEncoder.main", (String)"127");
                System.out.println("ERROR:  invalid password encoding exception");
                System.exit(1);
            }
        } else {
            if (string2 == null || string2.length() == 0) {
                System.out.println("ERROR:  password properties list is null or empty");
                System.exit(1);
            }
            boolean bl3 = false;
            object2 = new StringTokenizer(string2, ",");
            int n2 = ((StringTokenizer)object2).countTokens();
            for (n = 0; n < n2; ++n) {
                String string3;
                String string4;
                object = ((StringTokenizer)object2).nextToken();
                if (object == null || (string4 = properties.getProperty(string3 = ((String)object).trim())) == null) continue;
                bl3 = true;
                String string5 = string4.trim();
                if (string5.length() <= 0) continue;
                String string6 = PasswordUtil.passwordEncode((String)string5);
                if (string6 == null) {
                    System.out.println("ERROR:  invalid password encoding exception");
                    System.exit(1);
                }
                if (string6.equals(string5)) continue;
                bl = true;
                properties.put(string3, string6);
            }
            if (!bl3) {
                System.out.println("ERROR:  no password properties in specified list were found in target file");
                System.exit(1);
            }
        }
        if (!bl) {
            System.out.println("NOTE:  all specified passwords already encoded in target file == " + file.toString());
            System.exit(0);
        }
        File file2 = new File(file.toString() + ".bak");
        try {
            object2 = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            n = ((FileInputStream)object2).available();
            object = new byte[n];
            ((FileInputStream)object2).read((byte[])object, 0, n);
            fileOutputStream.write((byte[])object, 0, ((Object)object).length);
            ((FileInputStream)object2).close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR:  File not found");
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("File i/o error");
            iOException.printStackTrace();
            System.exit(1);
        }
        if (!file2.exists()) {
            System.out.println("ERROR:  cannot create backup file == " + file2.toString());
            System.exit(1);
        }
        object2 = null;
        try {
            object2 = new FileOutputStream(file);
            if (bl2) {
                SASPropFile.saveConfig((Properties)properties, (FileOutputStream)object2);
            } else {
                properties.save((OutputStream)object2, null);
            }
            ((FileOutputStream)object2).close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.util.PropFilePasswordEncoder.main", (String)"225");
            if (object2 != null) {
                try {
                    ((FileOutputStream)object2).close();
                }
                catch (IOException iOException3) {
                    FFDCFilter.processException((Throwable)iOException3, (String)"com.ibm.ws.security.util.PropFilePasswordEncoder.main", (String)"234");
                }
            }
            System.out.println("ERROR:  cannot save properties to target file == " + file.toString());
            System.exit(1);
        }
        System.exit(0);
    }
}

