/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSAdminClientLoginModuleImpl
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    protected boolean debug = false;
    private static final TraceComponent tc = Tr.register((Class)WSAdminClientLoginModuleImpl.class, null, (String)"com.ibm.ejs.resources.security");

    public WSAdminClientLoginModuleImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSAdminClientLoginModuleImpl()");
            Tr.exit((TraceComponent)tc, (String)"WSAdminClientLoginModuleImpl()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")"));
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSAdminClientLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean login() throws LoginException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if (this.callbackHandler == null) {
            throw new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        String string = null;
        char[] cArray = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
            object = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object != null) {
                cArray = new char[((char[])object).length];
                System.arraycopy(object, 0, cArray, 0, ((char[])object).length);
                ((PasswordCallback)callbackArray[1]).clearPassword();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", (String)"191", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerIOException", (Object)new Object[]{this.getClass().getName(), iOException});
            throw new WSLoginFailedException("java.io.IOException from CallbackHandler.handle()", (Throwable)iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", (String)"196", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerException", (Object)new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
            throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", (Throwable)unsupportedCallbackException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uid = " + string));
            Tr.debug((TraceComponent)tc, (String)("password = " + (cArray == null ? "<null>" : "XXXXXXXX")));
        }
        if (string == null && cArray == null) {
            throw new WSLoginFailedException("No authentication data.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Successfully gathered authentication information");
        }
        if (string == null && cArray == null) throw new WSLoginFailedException("No authentication data");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Using uid and password for authentication");
            object = new StringBuffer("Authenticating \"");
            ((StringBuffer)object).append(string).append("\"");
            Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
        }
        try {
            if (cArray == null) {
                cArray = new char[]{};
            }
            this.credential = new WSCredentialImpl("", string, String.valueOf(cArray));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Credential after authentication: " + this.credential));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", (String)"239", (Object)this);
            throw new WSLoginFailedException("LoginFailed.", (Throwable)exception);
        }
        try {
            this.principal = null;
            if (this.credential != null) {
                this.principal = ContextManagerFactory.getInstance().createPrincipal(this.credential);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", (String)"262", (Object)this);
            throw new WSLoginFailedException("Failed to create WSPrincipal", (Throwable)wSSecurityException);
        }
        this.succeeded = true;
        if (!tc.isEntryEnabled()) return this.succeeded;
        Tr.exit((TraceComponent)tc, (String)("login(): status = " + this.succeeded));
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Start committing the changes to the Subject ...");
                    }
                    if (this.credential != null && this.principal != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                if (!WSAdminClientLoginModuleImpl.this.subject.getPrincipals().contains(WSAdminClientLoginModuleImpl.this.principal)) {
                                    WSAdminClientLoginModuleImpl.this.subject.getPrincipals().add((Principal)WSAdminClientLoginModuleImpl.this.principal);
                                }
                                if (!WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().contains(WSAdminClientLoginModuleImpl.this.credential)) {
                                    WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().add(WSAdminClientLoginModuleImpl.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.commit", (String)"339", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.LoginModuleCommitError", (Object)new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("commit(): status = " + bl));
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug((TraceComponent)tc, (String)"Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block9: {
                    try {
                        if (WSAdminClientLoginModuleImpl.this.principal != null && WSAdminClientLoginModuleImpl.this.subject.getPrincipals().contains(WSAdminClientLoginModuleImpl.this.principal)) {
                            WSAdminClientLoginModuleImpl.this.subject.getPrincipals().remove(WSAdminClientLoginModuleImpl.this.principal);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.run", (String)"455", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.jaas.removePrinException", (Object)new Object[]{this.getClass().getName(), WSAdminClientLoginModuleImpl.this.principal.getName(), exception});
                    }
                    if (WSAdminClientLoginModuleImpl.this.credential != null) {
                        try {
                            if (WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().contains(WSAdminClientLoginModuleImpl.this.credential)) {
                                WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().remove(WSAdminClientLoginModuleImpl.this.credential);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.run", (String)"464", (Object)this);
                            Tr.error((TraceComponent)tc, (String)"security.jaas.removeCredException", (Object)new Object[]{this.getClass().getName(), exception});
                        }
                        try {
                            WSAdminClientLoginModuleImpl.this.credential.destroy();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.run", (String)"483", (Object)this);
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug((TraceComponent)tc, (String)"Credential destroy failed");
                            Tr.debug((TraceComponent)tc, (String)Util.toString(exception));
                        }
                    }
                }
                return null;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }
}

