/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;

public final class StateofSecurity {
    private static final TraceComponent tc = Tr.register((Class)StateofSecurity.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private WSSecurityPropagationHelper helper = null;
    private ContextManager ctxManager = null;
    private boolean isServer = false;
    private boolean recordRunAsChangesInCallerList = false;
    private Object osThreadPlatformCred = null;
    private Object serverPlatformCred = null;
    Subject invocationSubject = null;
    Subject callerSubject = null;
    Subject serverSubject = null;
    Subject ownSubject = null;
    String firstAuthUser = null;
    boolean authFlag = false;
    boolean appSyncToOSThreadEnabled = false;
    private Map propagationTokens = null;
    private Map zOSThreadData = new HashMap();
    public static final String DEFER_OPI_DELETION = "zOSSecurity.DeferOPIDeletion";
    private Hashtable propTable = new Hashtable(32);
    private boolean authRetryForJAAS = true;
    private Throwable t = null;

    protected StateofSecurity() {
        VaultImpl vaultImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.helper = WSSecurityPropagationHelper.getInstance();
        this.ctxManager = ContextManagerFactory.getInstance();
        this.isServer = this.ctxManager.processIsServer();
        if (this.isServer && (vaultImpl = VaultImpl.getInstance()) != null) {
            SecurityConfiguration securityConfiguration = vaultImpl.getSecurityConfiguration();
            if (securityConfiguration != null) {
                this.recordRunAsChangesInCallerList = securityConfiguration.includeRunAsChangesInCallerList();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public Object getOSThreadPlatformCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOSThreadPlatformCred");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOSThreadPlatformCred", (Object)this.osThreadPlatformCred);
        }
        return this.osThreadPlatformCred;
    }

    public void setOSThreadPlatformCred(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setOSThreadPlatformCred", (Object)object);
        }
        this.osThreadPlatformCred = object;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setOSThreadPlatformCred");
        }
    }

    public Object getServerPlatformCred() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerPlatformCred");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerPlatformCred", (Object)this.serverPlatformCred);
        }
        return this.serverPlatformCred;
    }

    public void setServerPlatformCred(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServerPlatformCred", (Object)object);
        }
        this.serverPlatformCred = object;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerPlatformCred");
        }
    }

    Subject getInvocationSubject() {
        return this.invocationSubject;
    }

    Subject getServerSubject() {
        return this.serverSubject;
    }

    Subject getCallerSubject() {
        return this.callerSubject;
    }

    Subject getOwnSubject() {
        return this.ownSubject;
    }

    String getFirstAuthUser() {
        return this.firstAuthUser;
    }

    boolean getAuthFlag() {
        return this.authFlag;
    }

    void setInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInvocationSubject", (Object)subject);
        }
        this.invocationSubject = subject;
        if (this.isServer && this.isPropagationEnabled() && this.recordRunAsChangesInCallerList) {
            SubjectHelper.updatePropagationTokenWithSubjectChange((Subject)this.invocationSubject);
        }
    }

    void setServerSubject(Subject subject) {
        this.serverSubject = subject;
    }

    void setOwnSubject(Subject subject) {
        this.ownSubject = subject;
    }

    void setFirstAuthUser(String string) {
        this.firstAuthUser = string;
    }

    void setAuthFlag(boolean bl) {
        this.authFlag = bl;
    }

    void setCallerSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCallerSubject", (Object)subject);
        }
        this.callerSubject = subject;
        if (this.isServer && this.isPropagationEnabled()) {
            SubjectHelper.updatePropagationTokenWithSubjectChange((Subject)this.callerSubject);
        }
    }

    PropagationToken setPropagationToken(String string, PropagationToken propagationToken) throws WSSecurityException {
        if (this.propagationTokens == null) {
            this.propagationTokens = new HashMap();
        }
        return this.propagationTokens.put(string, propagationToken);
    }

    PropagationToken getPropagationToken(String string) throws WSSecurityException {
        return this.propagationTokens != null ? (PropagationToken)this.propagationTokens.get(string) : null;
    }

    Map getPropagationTokens() {
        return this.propagationTokens;
    }

    void clearPropagationToken() {
        this.propagationTokens = null;
    }

    void setPropagationTokenMap(Map map) {
        this.propagationTokens = map;
    }

    void setApplicationSyncToOSThreadEnabled(boolean bl) {
        this.appSyncToOSThreadEnabled = bl;
    }

    boolean isApplicationSyncToOSThreadEnabled() {
        return this.appSyncToOSThreadEnabled;
    }

    Object getzOSThreadData(String string) {
        Object var2_2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getzOSThreadData", (Object)string);
        }
        Object v0 = var2_2 = this.zOSThreadData != null ? this.zOSThreadData.get(string) : null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getzOSThreadData", var2_2);
        }
        return var2_2;
    }

    Object setzOSThreadData(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setzOSThreadData", (Object)new Object[]{string, object});
        }
        Object object2 = this.zOSThreadData.put(string, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setzOSThreadData", (Object)object2);
        }
        return object2;
    }

    private boolean isPropagationEnabled() {
        return this.helper.isRMIOutboundPropagationEnabled() || this.helper.isRMIInboundPropagationEnabled() || this.helper.isWebInboundPropagationEnabled();
    }

    public Object get_property(String string) {
        return this.propTable.get(string);
    }

    public Object set_property(String string, Object object) {
        if (object == null) {
            this.propTable.remove(string);
            return null;
        }
        return this.propTable.put(string, object);
    }

    public boolean contains_property(String string) {
        return this.propTable.contains(string);
    }

    public void set_root_exception(Throwable throwable) {
        this.t = throwable;
    }

    public Throwable get_root_exception() {
        return this.t;
    }

    public void set_authretry_for_jaas(boolean bl) {
        this.authRetryForJAAS = bl;
    }

    public boolean get_authretry_for_jaas() {
        return this.authRetryForJAAS;
    }
}

