/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.lang.reflect.Method;
import javax.security.auth.AuthPermission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WSSecurityHelper {
    private static final TraceComponent tc = Tr.register((Class)WSSecurityHelper.class, null, (String)"com.ibm.ejs.resources.security");
    private static final AuthPermission GETPROPATTRIBUTE_PERM = new AuthPermission("wssecurity.getPropagationAttributes");
    private static final AuthPermission SETPROPATTRIBUTE_PERM = new AuthPermission("wssecurity.addPropagationAttribute");
    private static Class webAttributesClass = null;
    private static Method createLogoutCookiesMethod = null;
    private static boolean isSSOEnabled = false;

    public static boolean isServerSecurityEnabled() {
        return ContextManagerFactory.getInstance().isServerSecurityEnabled();
    }

    public static boolean isGlobalSecurityEnabled() {
        return ContextManagerFactory.getInstance().isCellSecurityEnabled();
    }

    public static String getFirstCaller() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFirstCaller");
        }
        if (!(WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        String[] stringArray = WSSecurityHelper.getCallerList();
        if (stringArray != null && stringArray.length > 0) {
            String string = stringArray[0];
            if (string != null) {
                int n = string.indexOf(":");
                n = string.indexOf(":", n + 1);
                n = string.indexOf(":", n + 1);
                string = string.substring(n + 1);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getFirstCaller() returns " + string));
                }
                return RealmSecurityName.getSecurityName((String)string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller() returns null.");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFirstCaller() returns null.");
        }
        return null;
    }

    public static String getFirstServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFirstServer");
        }
        if (!(WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        String[] stringArray = WSSecurityHelper.getServerList();
        if (stringArray != null && stringArray.length > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getFirstServer() returns " + stringArray[0]));
            }
            return stringArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFirstServer() returns null.");
        }
        return null;
    }

    public static String[] getCallerList() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCallerList");
        }
        if (!(WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        try {
            PropagationToken propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (propagationToken != null) {
                String[] stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers");
                if (stringArray != null && stringArray.length > 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("getCallerList() returns " + stringArray));
                    }
                    return stringArray;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getCallerList() returns null, attribute not present.");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCallerList() returns null, token not present.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred calling getCallerList().", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.WSSecurityHelper.getCallerList", (String)"254");
            return null;
        }
    }

    public static String[] getServerList() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerList");
        }
        if (!(WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        try {
            PropagationToken propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (propagationToken != null) {
                String[] stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getServerList() returns " + stringArray));
                }
                return stringArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerList() returns null, token not present.");
            }
            return null;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"The following exception occurred calling getServerList().", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.WSSecurityHelper.getServerList", (String)"308");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred calling getServerList().", (Object)new Object[]{exception});
            }
            return null;
        }
    }

    public static String[] getPropagationAttributes(String string) throws WSSecurityException {
        PropagationToken propagationToken;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPropagationAttributes: " + string));
        }
        if (!(WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GETPROPATTRIBUTE_PERM);
        }
        if ((propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1")) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropagationAttributes: success");
            }
            return propagationToken.getAttributes(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropagationAttributes: no PropagationToken found on thread");
        }
        return null;
    }

    public static String[] addPropagationAttribute(String string, String string2) throws WSSecurityException {
        PropagationToken propagationToken;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addPropagationAttribute");
        }
        if (!(WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SETPROPATTRIBUTE_PERM);
        }
        if ((propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1")) == null && (propagationToken = ContextManagerFactory.getInstance().createPropagationToken(null)) != null) {
            ContextManagerFactory.getInstance().setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", propagationToken);
        }
        if (propagationToken != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addPropagationAttribute: success");
            }
            return propagationToken.addAttribute(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addPropagationAttribute: attribute not set");
        }
        return null;
    }

    public static byte[] convertCookieStringToBytes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertCookieStringToBytes");
        }
        try {
            return StringUtil.getBytes(Base64Coder.base64Decode(string));
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"convertCookieStringToBytes: failed", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.security.WSSecurityHelper.convertCookieStringToBytes", (String)"475");
            return null;
        }
    }

    public static void revokeSSOCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"revokeSSOCookies");
        }
        if (!WSSecurityHelper.isGlobalSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No action because global security was not enabled");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"revokeSSOCookies");
            }
            return;
        }
        if (webAttributesClass == null) {
            try {
                webAttributesClass = Class.forName("com.ibm.ws.security.web.WebAttributes");
                createLogoutCookiesMethod = webAttributesClass.getMethod("createLogoutCookiesStatic", HttpServletRequest.class, HttpServletResponse.class);
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                Method method = clazz.getMethod("getConfig", null);
                Method method2 = clazz.getMethod("getValue", String.class);
                Object object = method.invoke(null, new Object[0]);
                String string = "security.ltpa.sso.enabled";
                Boolean bl = (Boolean)method2.invoke(object, string);
                isSSOEnabled = bl;
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"Initialization revokeSSOCookies failed with Exception:", (Object)new Object[]{exception});
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (isSSOEnabled) {
            if (createLogoutCookiesMethod == null) {
                Tr.error((TraceComponent)tc, (String)"revokeSSOCookies init condition incorrect.");
            } else {
                try {
                    createLogoutCookiesMethod.invoke(null, httpServletRequest, httpServletResponse);
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"Invoke createLogoutCookie failed with Exception:", (Object)new Object[]{exception});
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"revokeSSOCookies");
        }
    }
}

