/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.RegExpSample;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileRegistrySample
implements UserRegistry {
    private static String USERFILENAME = null;
    private static String GROUPFILENAME = null;
    private static final TraceComponent tc = Tr.register((Class)FileRegistrySample.class, null, (String)"com.ibm.ejs.resources.security");

    public void initialize(Properties properties) throws CustomRegistryException {
        try {
            if (properties != null) {
                USERFILENAME = properties.getProperty("usersFile");
                GROUPFILENAME = properties.getProperty("groupsFile");
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        if (USERFILENAME == null || GROUPFILENAME == null) {
            throw new CustomRegistryException("users/groups information missing");
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        String string3 = null;
        BufferedReader bufferedReader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkPassword with ID: " + string + "\n using file: " + USERFILENAME));
        }
        try {
            String string4;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.startsWith("#") || string4.trim().length() <= 0) continue;
                int n = string4.indexOf(":");
                int n2 = string4.indexOf(":", n + 1);
                if (!string4.substring(0, n).equals(string) || !string4.substring(n + 1, n2).equals(string2)) continue;
                string3 = string;
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        if (string3 == null) {
            throw new PasswordCheckFailedException("Password check failed for user: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkPassword with ID: " + string3));
        }
        return string3;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        String string = null;
        X509Certificate x509Certificate = x509CertificateArray[0];
        try {
            string = x509Certificate.getSubjectDN().getName();
        }
        catch (Exception exception) {
            throw new CertificateMapNotSupportedException(exception.getMessage(), (Throwable)exception);
        }
        if (!this.isValidUser(string)) {
            throw new CertificateMapFailedException("user: " + string + " is not valid");
        }
        return string;
    }

    public String getRealm() throws CustomRegistryException {
        String string = "customRealm";
        return string;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Result result = new Result();
        int n2 = 0;
        int n3 = n + 1;
        try {
            String string2;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n4;
                String string3;
                if (string2.startsWith("#") || string2.trim().length() <= 0 || !this.match(string3 = string2.substring(0, n4 = string2.indexOf(":")), string)) continue;
                arrayList.add(string3);
                if (n == 0 || ++n2 != n3) continue;
                arrayList.remove(string3);
                result.setHasMore();
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        result.setList(arrayList);
        return result;
    }

    public String getUserDisplayName(String string) throws CustomRegistryException, EntryNotFoundException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        if (!this.isValidUser(string)) {
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException("user: " + string + " is not valid");
            throw entryNotFoundException;
        }
        try {
            String string3;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("#") || string3.trim().length() <= 0) continue;
                int n = string3.indexOf(":");
                int n2 = string3.lastIndexOf(":");
                if (!string3.substring(0, n).equals(string)) continue;
                string2 = string3.substring(n2 + 1);
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws CustomRegistryException, EntryNotFoundException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("#") || string3.trim().length() <= 0) continue;
                int n = string3.indexOf(":");
                int n2 = string3.indexOf(":", n + 1);
                if (!string3.substring(0, n).equals(string)) continue;
                int n3 = string3.indexOf(":", n2 + 1);
                string2 = string3.substring(n2 + 1, n3);
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        if (string2 == null) {
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException("Cannot obtain uniqueId for user: " + string);
            throw entryNotFoundException;
        }
        return string2;
    }

    public String getUserSecurityName(String string) throws CustomRegistryException, EntryNotFoundException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getUserSecurityName, with ID: " + string + "\n using file: " + USERFILENAME));
        }
        try {
            String string3;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string3 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                int n3;
                if (string3.startsWith("#") || string3.trim().length() <= 0 || !string3.substring((n3 = string3.indexOf(":", (n2 = string3.indexOf(":")) + 1)) + 1, n = string3.indexOf(":", n3 + 1)).equals(string)) continue;
                string2 = string3.substring(0, n2);
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        if (string2 == null) {
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException("Cannot obtain the user securityName for " + string);
            throw entryNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getUserSecurityName, with ID: " + string2));
        }
        return string2;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.startsWith("#") || string2.trim().length() <= 0 || !string2.substring(0, n = string2.indexOf(":")).equals(string)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        return bl;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Result result = new Result();
        int n2 = 0;
        int n3 = n + 1;
        try {
            String string2;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n4;
                String string3;
                if (string2.startsWith("#") || string2.trim().length() <= 0 || !this.match(string3 = string2.substring(0, n4 = string2.indexOf(":")), string)) continue;
                arrayList.add(string3);
                if (n == 0 || ++n2 != n3) continue;
                arrayList.remove(string3);
                result.setHasMore();
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        result.setList(arrayList);
        return result;
    }

    public String getGroupDisplayName(String string) throws CustomRegistryException, EntryNotFoundException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        if (!this.isValidGroup(string)) {
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException("group: " + string + " is not valid");
            throw entryNotFoundException;
        }
        try {
            String string3;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("#") || string3.trim().length() <= 0) continue;
                int n = string3.indexOf(":");
                int n2 = string3.lastIndexOf(":");
                if (!string3.substring(0, n).equals(string)) continue;
                string2 = string3.substring(n2 + 1);
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws CustomRegistryException, EntryNotFoundException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("#") || string3.trim().length() <= 0) continue;
                int n = string3.indexOf(":");
                int n2 = string3.indexOf(":", n + 1);
                if (!string3.substring(0, n).equals(string)) continue;
                string2 = string3.substring(n + 1, n2);
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        if (string2 == null) {
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException("Cannot obtain the uniqueId for group: " + string);
            throw entryNotFoundException;
        }
        return string2;
    }

    public List getUniqueGroupIds(String string) throws CustomRegistryException, EntryNotFoundException {
        Object var3_2 = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            bufferedReader = this.fileOpen(USERFILENAME);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                int n3;
                if (string2.startsWith("#") || string2.trim().length() <= 0 || !string2.substring((n3 = string2.indexOf(":", (n2 = string2.indexOf(":")) + 1)) + 1, n = string2.indexOf(":", n3 + 1)).equals(string)) continue;
                int n4 = string2.lastIndexOf(":");
                String string3 = string2.substring(n + 1, n4);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        return arrayList;
    }

    public String getGroupSecurityName(String string) throws CustomRegistryException, EntryNotFoundException {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            while ((string3 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                if (string3.startsWith("#") || string3.trim().length() <= 0 || !string3.substring((n2 = string3.indexOf(":")) + 1, n = string3.indexOf(":", n2 + 1)).equals(string)) continue;
                string2 = string3.substring(0, n2);
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        if (string2 == null) {
            EntryNotFoundException entryNotFoundException = new EntryNotFoundException("Cannot obtain the group security name for: " + string);
            throw entryNotFoundException;
        }
        return string2;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string2.startsWith("#") || string2.trim().length() <= 0 || !string2.substring(0, n = string2.indexOf(":")).equals(string)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        return bl;
    }

    public List getGroupsForUser(String string) throws CustomRegistryException, EntryNotFoundException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("#") || string2.trim().length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                for (int i = 0; i < 2; ++i) {
                    stringTokenizer.nextToken();
                }
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    if (!stringTokenizer2.nextToken().equals(string)) continue;
                    int n = string2.indexOf(":");
                    arrayList.add(string2.substring(0, n));
                }
            }
        }
        catch (Exception exception) {
            if (!this.isValidUser(string)) {
                throw new EntryNotFoundException("user: " + string + " is not valid");
            }
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        return arrayList;
    }

    public Result getUsersForGroup(String string, int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException {
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = n + 1;
        Result result = new Result();
        try {
            String string2;
            bufferedReader = this.fileOpen(GROUPFILENAME);
            block5: while ((string2 = bufferedReader.readLine()) != null) {
                int n4;
                if (string2.startsWith("#") || string2.trim().length() <= 0 || !string2.substring(0, n4 = string2.indexOf(":")).equals(string)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                for (int i = 0; i < 2; ++i) {
                    stringTokenizer.nextToken();
                }
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string4 = stringTokenizer2.nextToken();
                    arrayList.add(string4);
                    if (n == 0 || ++n2 != n3) continue;
                    arrayList.remove(string4);
                    result.setHasMore();
                    continue block5;
                }
            }
        }
        catch (Exception exception) {
            if (!this.isValidGroup(string)) {
                throw new EntryNotFoundException("group: " + string + " is not valid");
            }
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.fileClose(bufferedReader);
        }
        result.setList(arrayList);
        return result;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        return null;
    }

    private BufferedReader fileOpen(String string) throws FileNotFoundException {
        return new BufferedReader(new FileReader(string));
    }

    private void fileClose(BufferedReader bufferedReader) {
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Error closing file" + exception);
        }
    }

    private boolean match(String string, String string2) {
        RegExpSample regExpSample = new RegExpSample(string2);
        boolean bl = false;
        if (regExpSample.match(string)) {
            bl = true;
        }
        return bl;
    }
}

