/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;
import mx4j.util.Utils;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8644704819898565848L;
    private String attributeType;
    private boolean isRead;
    private boolean isWrite;
    private boolean is;

    public MBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description);
        String getterType = null;
        String setterType = null;
        if (getter != null) {
            if (Utils.isAttributeGetter((Method)getter)) {
                this.isRead = true;
                if (getter.getName().startsWith("is")) {
                    this.is = true;
                }
                getterType = getter.getReturnType().getName();
            } else {
                throw new IntrospectionException("Bad getter method");
            }
        }
        if (setter != null) {
            if (Utils.isAttributeSetter((Method)setter)) {
                this.isWrite = true;
                setterType = setter.getParameterTypes()[0].getName();
            } else {
                throw new IntrospectionException("Bad setter method");
            }
        }
        this.attributeType = this.reconcileAttributeType(getterType, setterType);
    }

    public MBeanAttributeInfo(String name, String className, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, description);
        if (className == null) {
            throw new IllegalArgumentException("MBeanAttributeInfo cannot be null");
        }
        this.attributeType = className;
        this.isRead = isReadable;
        this.isWrite = isWritable;
        this.is = isIs;
    }

    public String getType() {
        return this.attributeType;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public boolean isIs() {
        return this.is;
    }

    public int hashCode() {
        int hash = super.hashCode();
        String type = this.getType();
        hash ^= type == null ? 0 : type.hashCode();
        hash ^= this.isReadable() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        hash ^= this.isWritable() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        return hash ^= this.isIs() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj == null) {
            result = false;
        } else if (!(obj instanceof MBeanAttributeInfo)) {
            result = false;
        } else if (this == obj) {
            result = true;
        } else {
            MBeanAttributeInfo objattrinfo = (MBeanAttributeInfo)obj;
            boolean samefeature = super.equals((MBeanFeatureInfo)obj);
            boolean sameattr = this.attributeType.equals(objattrinfo.getType()) && this.isIs() == objattrinfo.isIs() && this.isReadable() == objattrinfo.isReadable() && this.isWritable() == objattrinfo.isWritable();
            result = samefeature && sameattr;
        }
        return result;
    }

    private String reconcileAttributeType(String getterType, String setterType) throws IntrospectionException {
        String result = null;
        if (getterType == null && setterType != null) {
            result = setterType;
        } else if (getterType != null && setterType == null) {
            result = getterType;
        } else if (getterType != null && setterType != null) {
            if (getterType.compareToIgnoreCase(setterType) == 0) {
                result = getterType;
            } else {
                throw new IntrospectionException("Attribute setter/getter types don't match");
            }
        }
        return result;
    }

    public Object clone() {
        MBeanAttributeInfo clone = null;
        try {
            clone = (MBeanAttributeInfo)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
        clone.is = this.is;
        clone.isRead = this.isRead;
        clone.isWrite = this.isWrite;
        return clone;
    }
}

