/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.util.ArrayList;
import sun.tools.javazic.Checksum;
import sun.tools.javazic.RuleRec;
import sun.tools.javazic.Time;
import sun.tools.javazic.ZoneRec;

class Timezone {
    private String name;
    private ArrayList transitions;
    private ArrayList offsets;
    private ArrayList gmtOffsets;
    private ArrayList dstOffsets;
    private ArrayList usedZoneRecs;
    private ArrayList usedRuleRecs;
    private int dstType;
    static final int UNDEF_DST = 0;
    static final int NO_DST = 1;
    static final int LAST_DST = 2;
    static final int X_DST = 3;
    static final int DST = 4;
    private int rawOffset;
    private int crc32;
    private ZoneRec lastZoneRec;
    private ArrayList lastRules;
    private int lastSaving;
    private boolean willRawOffsetChange = false;

    Timezone(String string) {
        this.name = string;
    }

    int getNTransitions() {
        if (this.transitions == null) {
            return 0;
        }
        return this.transitions.size();
    }

    String getName() {
        return this.name;
    }

    ArrayList getRules() {
        return this.usedRuleRecs;
    }

    ArrayList getZones() {
        return this.usedZoneRecs;
    }

    ArrayList getTransitions() {
        return this.transitions;
    }

    ArrayList getOffsets() {
        return this.offsets;
    }

    ArrayList getDstOffsets() {
        return this.dstOffsets;
    }

    ArrayList getGmtOffsets() {
        return this.gmtOffsets;
    }

    int getCRC32() {
        return this.crc32;
    }

    boolean willGMTOffsetChange() {
        return this.willRawOffsetChange;
    }

    int getRawOffset() {
        return this.rawOffset;
    }

    void setRawOffset(int n) {
        this.rawOffset = n;
    }

    void setRawOffset(int n, long l) {
        if (l > Time.getCurrentTime()) {
            this.willRawOffsetChange = true;
        }
        this.setRawOffset(n);
    }

    void addTransition(long l, int n, int n2) {
        if (this.transitions == null) {
            this.transitions = new ArrayList();
            this.offsets = new ArrayList();
            this.dstOffsets = new ArrayList();
        }
        this.transitions.add(new Long(l));
        this.offsets.add(new Integer(n));
        this.dstOffsets.add(new Integer(n2));
    }

    void setDSTType(int n) {
        this.dstType = n;
    }

    int getDSTType() {
        return this.dstType;
    }

    void addUsedRec(ZoneRec zoneRec) {
        if (this.usedZoneRecs == null) {
            this.usedZoneRecs = new ArrayList();
        }
        this.usedZoneRecs.add(zoneRec);
    }

    void addUsedRec(RuleRec ruleRec) {
        if (this.usedRuleRecs == null) {
            this.usedRuleRecs = new ArrayList();
        }
        int n = this.usedRuleRecs.size();
        for (int i = 0; i < n; ++i) {
            if (!this.usedRuleRecs.get(i).equals(ruleRec)) continue;
            return;
        }
        this.usedRuleRecs.add(ruleRec);
    }

    void setLastZoneRec(ZoneRec zoneRec) {
        this.lastZoneRec = zoneRec;
    }

    ZoneRec getLastZoneRec() {
        return this.lastZoneRec;
    }

    void setLastRules(ArrayList arrayList) {
        int n = arrayList.size();
        if (n > 0) {
            this.lastRules = arrayList;
            RuleRec ruleRec = (RuleRec)arrayList.get(0);
            int n2 = ruleRec.getSave();
            if (n2 > 0) {
                this.setLastDSTSaving(n2);
            } else {
                System.err.println("\t    No DST starting rule in the last rules.");
            }
        }
    }

    ArrayList getLastRules() {
        return this.lastRules;
    }

    void setLastDSTSaving(int n) {
        this.lastSaving = n;
    }

    int getLastDSTSaving() {
        return this.lastSaving;
    }

    void checksum() {
        if (this.transitions == null) {
            this.crc32 = 0;
            return;
        }
        Checksum checksum = new Checksum();
        for (int i = 0; i < this.transitions.size(); ++i) {
            int n = (Integer)this.offsets.get(i);
            checksum.update((Long)this.transitions.get(i) + (long)n);
            checksum.update(n);
            checksum.update((Integer)this.dstOffsets.get(i));
        }
        this.crc32 = (int)checksum.getValue();
    }

    void optimize() {
        int n;
        if (this.gmtOffsets.size() == 1) {
            this.transitions = null;
            this.usedRuleRecs = null;
            this.setDSTType(1);
            return;
        }
        for (n = 0; n < this.transitions.size() - 2; ++n) {
            if (((Long)this.transitions.get(n)).longValue() != ((Long)this.transitions.get(n + 1)).longValue()) continue;
            this.transitions.remove(n);
            this.offsets.remove(n);
            this.dstOffsets.remove(n);
            --n;
        }
        for (n = 0; n < this.transitions.size() - 2; ++n) {
            if (((Integer)this.offsets.get(n)).intValue() != ((Integer)this.offsets.get(n + 1)).intValue() || ((Integer)this.dstOffsets.get(n)).intValue() != ((Integer)this.dstOffsets.get(n + 1)).intValue()) continue;
            this.transitions.remove(n + 1);
            this.offsets.remove(n + 1);
            this.dstOffsets.remove(n + 1);
            --n;
        }
    }

    int getOffsetIndex(int n) {
        return this.getOffsetIndex(n, 0);
    }

    int getDstOffsetIndex(int n) {
        if (n == 0) {
            return -1;
        }
        return this.getOffsetIndex(n, 1);
    }

    private int getOffsetIndex(int n, int n2) {
        if (this.gmtOffsets == null) {
            this.gmtOffsets = new ArrayList();
        }
        for (int i = n2; i < this.gmtOffsets.size(); ++i) {
            if (n != (Integer)this.gmtOffsets.get(i)) continue;
            return i;
        }
        if (this.gmtOffsets.size() < n2) {
            this.gmtOffsets.add(new Integer(0));
        }
        this.gmtOffsets.add(new Integer(n));
        return this.gmtOffsets.size() - 1;
    }
}

