/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import sun.tools.javazic.Calendar;
import sun.tools.javazic.Main;
import sun.tools.javazic.RuleDay;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Gregorian;

class Time {
    private static final int WALL = 1;
    private static final int STD = 2;
    private static final int UTC = 3;
    private int type;
    private long time;
    private static long currentTime = System.currentTimeMillis();

    Time() {
        this.time = 0L;
    }

    Time(long l) {
        this.time = l;
    }

    void setType(int n) {
        this.type = n;
    }

    long getTime() {
        return this.time;
    }

    int getType() {
        return this.type;
    }

    static long getCurrentTime() {
        return currentTime;
    }

    boolean isWall() {
        return this.type == 1;
    }

    boolean isSTD() {
        return this.type == 2;
    }

    boolean isUTC() {
        return this.type == 3;
    }

    String getTypeForSimpleTimeZone() {
        String string = "SimpleTimeZone.";
        if (this.isWall()) {
            return string + "WALL_TIME";
        }
        if (this.isSTD()) {
            return string + "STANDARD_TIME";
        }
        if (this.isUTC()) {
            return string + "UTC_TIME";
        }
        return null;
    }

    static long getLocalTime(int n, int n2, RuleDay ruleDay, int n3, int n4, Time time) {
        long l = time.getTime();
        if (time.isSTD()) {
            l = time.getTime() + (long)n3;
        } else if (time.isUTC()) {
            l = time.getTime() + (long)n3 + (long)n4;
        }
        return Time.getLocalTime(n, n2, ruleDay, l);
    }

    static long getLocalTime(int n, int n2, int n3, long l) {
        CalendarDate calendarDate = new CalendarDate(n, n2, n3);
        long l2 = Gregorian.dateToMillis((CalendarDate)calendarDate);
        return l2 + l;
    }

    static long getLocalTime(int n, int n2, int n3, int n4) {
        return Time.getLocalTime(n, n2, n3, (long)n4);
    }

    static long getLocalTime(int n, int n2, RuleDay ruleDay, long l) {
        return Time.getLocalTime(n, n2, ruleDay, (int)l);
    }

    static long getLocalTime(int n, int n2, RuleDay ruleDay, int n3) {
        long l = 0L;
        if (ruleDay.isLast()) {
            l = Calendar.getNthDayOfWeek(-1, ruleDay.getDayOfWeek(), (int)Calendar.getFixedDate((int)n, (int)n2, (int)Gregorian.getMonthLength(n, n2)));
        } else if (ruleDay.isLater()) {
            l = Calendar.getNthDayOfWeek(1, ruleDay.getDayOfWeek(), (int)Calendar.getFixedDate((int)n, (int)n2, (int)ruleDay.getDay()));
        } else if (ruleDay.isExact()) {
            l = Calendar.getFixedDate((int)n, (int)n2, (int)ruleDay.getDay());
        } else if (ruleDay.isEarlier()) {
            l = Calendar.getNthDayOfWeek(-1, ruleDay.getDayOfWeek(), (int)Calendar.getFixedDate((int)n, (int)n2, (int)ruleDay.getDay()));
        } else {
            Main.panic("invalid day type: " + ruleDay);
        }
        return (l - 719163L) * 86400000L + (long)n3;
    }

    static Time parse(String string) {
        char c;
        int n;
        int n2 = 0;
        if (string.charAt(0) == '-') {
            n = -1;
            ++n2;
        } else {
            n = 1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n2 < string.length()) {
            if ((c = string.charAt(n2++)) == ':') {
                n3 = n3 * 60 + n4;
                ++n5;
                n4 = 0;
                continue;
            }
            int n6 = Character.digit(c, 10);
            if (n6 == -1) {
                --n2;
                break;
            }
            n4 = n4 * 10 + n6;
        }
        n3 = n3 * 60 + n4;
        while (n5 < 2) {
            n3 *= 60;
            ++n5;
        }
        Time time = new Time((long)n3 * 1000L * (long)n);
        if (n2 < string.length()) {
            if ((c = string.charAt(n2++)) == 's') {
                time.setType(2);
            } else if (c == 'u' || c == 'g' || c == 'z') {
                time.setType(3);
            } else if (c == 'w') {
                time.setType(1);
            } else {
                Main.panic("unknown time mode: " + c);
            }
        } else {
            time.setType(1);
        }
        return time;
    }

    static String toGMTFormat(String string) {
        String string2;
        long l = Long.parseLong(string) / 1000L;
        if (l < 0L) {
            string2 = "-";
            l = -l;
        } else {
            string2 = "+";
        }
        if (l < 36000L) {
            string2 = string2 + "0";
        }
        string2 = string2 + l / 3600L;
        string2 = string2 + ":";
        if ((l %= 3600L) < 600L) {
            string2 = string2 + "0";
        }
        string2 = string2 + l / 60L;
        return string2;
    }

    static String toFormedString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (n < 0) {
            stringBuffer.append("-");
            bl = true;
            n = -n;
        } else if (n == 0) {
            return "0";
        }
        int n2 = n / 3600000;
        int n3 = (n %= 3600000) / 60000;
        if (n2 != 0) {
            if (bl && n3 != 0) {
                stringBuffer.append("(");
            }
            stringBuffer.append(Integer.toString(n2) + "*ONE_HOUR");
        }
        if (n3 != 0) {
            if (n2 != 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(Integer.toString(n3) + "*ONE_MINUTE");
            if (bl && n2 != 0) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }
}

