/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.util.HashMap;

class RuleDay {
    private static HashMap dayOfWeek = new HashMap();
    private String dayName = null;
    private int dow;
    private boolean lastOne = false;
    private int soonerOrLater = 0;
    private int thanDay;
    private static final String[] upper_DayOfWeek;

    RuleDay() {
    }

    RuleDay(int n) {
        this.thanDay = n;
    }

    int getDay() {
        return this.thanDay;
    }

    int getDayOfWeek() {
        return this.dow;
    }

    boolean isLast() {
        return this.lastOne;
    }

    boolean isLater() {
        return this.soonerOrLater > 0;
    }

    boolean isEarlier() {
        return this.soonerOrLater < 0;
    }

    boolean isExact() {
        return this.soonerOrLater == 0;
    }

    static RuleDay parse(String string) {
        RuleDay ruleDay = new RuleDay();
        if (string.startsWith("last")) {
            ruleDay.lastOne = true;
            ruleDay.dayName = string.substring(4);
            ruleDay.dow = RuleDay.getDOW(ruleDay.dayName);
        } else {
            int n = string.indexOf(">=");
            if (n != -1) {
                ruleDay.dayName = string.substring(0, n);
                ruleDay.dow = RuleDay.getDOW(ruleDay.dayName);
                ruleDay.soonerOrLater = 1;
                ruleDay.thanDay = Integer.parseInt(string.substring(n + 2));
            } else {
                n = string.indexOf("<=");
                if (n != -1) {
                    ruleDay.dayName = string.substring(0, n);
                    ruleDay.dow = RuleDay.getDOW(ruleDay.dayName);
                    ruleDay.soonerOrLater = -1;
                    ruleDay.thanDay = Integer.parseInt(string.substring(n + 2));
                } else {
                    ruleDay.thanDay = Integer.parseInt(string);
                }
            }
        }
        return ruleDay;
    }

    int getDayForSimpleTimeZone() {
        if (this.isLast()) {
            return -1;
        }
        return this.getDay();
    }

    int getDayOfWeekForSimpleTimeZoneInt() {
        if (!(this.isLater() || this.isEarlier() || this.isLast())) {
            return 0;
        }
        if (this.isLater()) {
            return -this.getDayOfWeek();
        }
        return this.getDayOfWeek();
    }

    String getDayOfWeekForSimpleTimeZone() {
        int n = this.getDayOfWeekForSimpleTimeZoneInt();
        if (n == 0) {
            return "0";
        }
        String string = "";
        if (n < 0) {
            string = "-";
            n = -n;
        }
        return string + RuleDay.toString(n);
    }

    private static int getDOW(String string) {
        return (Integer)dayOfWeek.get(string);
    }

    static String toString(int n) {
        if (--n >= 0 && n <= 6) {
            return "Calendar." + upper_DayOfWeek[n];
        }
        throw new IllegalArgumentException("wrong Day_of_Week number: " + (n + 1));
    }

    static {
        dayOfWeek.put("Sun", new Integer(1));
        dayOfWeek.put("Mon", new Integer(2));
        dayOfWeek.put("Tue", new Integer(3));
        dayOfWeek.put("Wed", new Integer(4));
        dayOfWeek.put("Thu", new Integer(5));
        dayOfWeek.put("Fri", new Integer(6));
        dayOfWeek.put("Sat", new Integer(7));
        upper_DayOfWeek = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
    }
}

