/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.crunch.Attribute;
import sun.tools.crunch.ClassFile;
import sun.tools.crunch.GlobalTables;

public class ValueAttribute
extends Attribute {
    private ClassFile cfile;
    private short valueIndex;
    private static int count;
    private static int[] tagCounts;

    public static Attribute read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        return new ValueAttribute(classFile, dataInputStream);
    }

    private ValueAttribute(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        byte by;
        this.cfile = classFile;
        int n = dataInputStream.readInt();
        if (n != 2) {
            throw new Error("Unexpected length in ConstantValue attribute");
        }
        this.valueIndex = dataInputStream.readShort();
        ++count;
        byte by2 = by = classFile.constants[this.valueIndex].tag;
        tagCounts[by2] = tagCounts[by2] + 1;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(2);
        Object object = this.cfile.constants[this.valueIndex].getValue();
        dataOutputStream.writeShort(GlobalTables.findValue(object));
    }

    public static void summarize() {
        System.out.println("    " + count + " ConstantValue attributes," + " written length = " + count * 3 + " bytes");
    }

    static {
        tagCounts = new int[16];
    }
}

