/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.IOException;
import sun.tools.crunch.ClassFile;

public class Constant {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_FieldRef = 9;
    public static final int CONSTANT_MethodRef = 10;
    public static final int CONSTANT_InterfaceMethodRef = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static String[] tagNames = new String[]{"?0?", "UTF8", "?2?", "INTEGER", "FLOAT", "LONG", "DOUBLE", "CLASS", "STRING", "FIELDREF", "METHODREF", "INTERFACEMETHODREF", "NAMEANDTYPE"};
    ClassFile cfile;
    byte tag;
    private short index;
    private short index2;
    Object value;
    String utf;

    public static Constant read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        return new Constant(classFile, dataInputStream);
    }

    private Constant(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        this.cfile = classFile;
        this.tag = dataInputStream.readByte();
        switch (this.tag) {
            case 1: {
                this.utf = dataInputStream.readUTF();
                break;
            }
            case 3: {
                this.value = new Integer(dataInputStream.readInt());
                break;
            }
            case 4: {
                this.value = new Float(dataInputStream.readFloat());
                break;
            }
            case 5: {
                this.value = new Long(dataInputStream.readLong());
                break;
            }
            case 6: {
                this.value = new Double(dataInputStream.readDouble());
                break;
            }
            case 7: {
                this.index = dataInputStream.readShort();
                break;
            }
            case 8: {
                this.index = dataInputStream.readShort();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.index = dataInputStream.readShort();
                this.index2 = dataInputStream.readShort();
                break;
            }
            case 12: {
                this.index = dataInputStream.readShort();
                this.index2 = dataInputStream.readShort();
                break;
            }
            default: {
                throw new IOException("Bad classfile constant tag " + this.tag);
            }
        }
    }

    public String getClassName() {
        if (this.tag == 7) {
            Constant constant = this.cfile.constants[this.index];
            if (constant.tag != 1) {
                throw new Error("CLASS Constant doesn't point at UTF8: " + this.toIndex());
            }
            return constant.utf;
        }
        throw new Error("getClassName on non-class constant " + this.toIndex());
    }

    public String getRefClass() {
        switch (this.tag) {
            case 9: 
            case 10: 
            case 11: {
                Constant constant = this.cfile.constants[this.index];
                return constant.getClassName();
            }
        }
        throw new Error("getRefClass on non-ref constant " + this.toIndex());
    }

    public String getRefName() {
        switch (this.tag) {
            case 9: 
            case 10: 
            case 11: {
                Constant constant = this.cfile.constants[this.index2];
                if (constant.tag != 12) {
                    throw new Error("Ref doesn't point to NameAndType " + this.toIndex());
                }
                constant = this.cfile.constants[constant.index];
                if (constant.tag != 1) {
                    throw new Error("Ref doesn't point to NameAndType name " + this.toIndex());
                }
                return constant.utf;
            }
        }
        throw new Error("getRefName on non-ref constant " + this.toIndex());
    }

    public String getRefType() {
        switch (this.tag) {
            case 9: 
            case 10: 
            case 11: {
                Constant constant = this.cfile.constants[this.index2];
                if (constant.tag != 12) {
                    throw new Error("Ref doesn't point to NameAndType " + this.toIndex());
                }
                constant = this.cfile.constants[constant.index2];
                if (constant.tag != 1) {
                    throw new Error("Ref doesn't point to NameAndType type " + this.toIndex());
                }
                return constant.utf;
            }
        }
        throw new Error("getRefType on non-ref constant " + this.toIndex());
    }

    public Object getValue() {
        switch (this.tag) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.value;
            }
            case 8: {
                Constant constant = this.cfile.constants[this.index];
                if (constant.tag != 1) {
                    throw new Error("String Constant doesn't point at UTF8 " + this.toIndex());
                }
                return constant.utf;
            }
        }
        throw new Error("getValue on non-value constant " + this.toIndex());
    }

    public int getSize() {
        switch (this.tag) {
            case 1: {
                return 3 + this.utf.length();
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 5;
            }
            case 12: {
                return 5;
            }
        }
        throw new Error("Bad tag");
    }

    public int hashCode() {
        switch (this.tag) {
            case 1: {
                return this.utf.hashCode();
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.toString().hashCode();
            }
        }
        throw new Error("Bad tag");
    }

    public boolean equals(Object object) {
        Constant constant = (Constant)object;
        switch (this.tag) {
            case 1: {
                return this.utf.equals(constant.utf);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.toString().equals(constant.toString());
            }
        }
        throw new Error("Bad tag");
    }

    public String toString() {
        switch (this.tag) {
            case 1: {
                return this.utf;
            }
            case 3: {
                return "INTEGER: " + this.value;
            }
            case 4: {
                return "FLOAT: " + this.value;
            }
            case 5: {
                return "LONG: " + this.value;
            }
            case 6: {
                return "DOUBLE: " + this.value;
            }
            case 7: {
                return "CLASS: " + this.cfile.getString(this.index);
            }
            case 8: {
                return "STRING: " + this.cfile.getString(this.index);
            }
            case 9: {
                return "FIELD: " + this.cfile.getString(this.index) + " " + this.cfile.getString(this.index2);
            }
            case 10: {
                return "METHOD: " + this.cfile.getString(this.index) + " " + this.cfile.getString(this.index2);
            }
            case 11: {
                return "INTERFACEMETHOD: " + this.cfile.getString(this.index) + " " + this.cfile.getString(this.index2);
            }
            case 12: {
                return "N&T: " + this.cfile.getString(this.index) + " " + this.cfile.getString(this.index2);
            }
        }
        throw new Error("bad tag!!???");
    }

    public boolean takesTwoSlots() {
        return this.tag == 5 || this.tag == 6;
    }

    public String rawString() {
        switch (this.tag) {
            case 1: {
                return "UTF8: " + this.utf;
            }
            case 3: {
                return "INTEGER: " + this.value;
            }
            case 4: {
                return "FLOAT: " + this.value;
            }
            case 5: {
                return "LONG: " + this.value;
            }
            case 6: {
                return "DOUBLE: " + this.value;
            }
            case 7: {
                return "CLASS: " + this.index;
            }
            case 8: {
                return "STRING: " + this.index;
            }
            case 9: {
                return "FIELDREF: " + this.index + " " + this.index2;
            }
            case 10: {
                return "METHODREF: " + this.index + " " + this.index2;
            }
            case 11: {
                return "INTERFACEMETHODREF: " + this.index + " " + this.index2;
            }
            case 12: {
                return "NAMEANDTYPE: " + this.index + " " + this.index2;
            }
        }
        throw new Error("bad tag!!???");
    }

    public int toIndex() {
        for (int i = 0; i < this.cfile.constants.length; ++i) {
            if (this.cfile.constants[i] != this) continue;
            return i;
        }
        return -1;
    }
}

