/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sun.tools.crunch.ClassFile;
import sun.tools.crunch.CodeAttribute;
import sun.tools.crunch.ExceptionsAttribute;
import sun.tools.crunch.InnerClassesAttribute;
import sun.tools.crunch.SyntheticAttribute;
import sun.tools.crunch.ValueAttribute;

public abstract class Attribute {
    protected Attribute() {
    }

    public static Attribute[] readAttributes(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        Vector<Attribute> vector = new Vector<Attribute>();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = Attribute.read(classFile, dataInputStream);
            if (attribute == null) continue;
            vector.addElement(attribute);
        }
        Attribute[] attributeArray = new Attribute[vector.size()];
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeArray[i] = (Attribute)vector.elementAt(i);
        }
        return attributeArray;
    }

    private static Attribute read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        String string = classFile.getString(s);
        if (string.equals("Code")) {
            return CodeAttribute.read(classFile, dataInputStream);
        }
        if (string.equals("ConstantValue")) {
            return ValueAttribute.read(classFile, dataInputStream);
        }
        if (string.equals("Exceptions")) {
            return ExceptionsAttribute.read(classFile, dataInputStream);
        }
        if (string.equals("Synthetic")) {
            return SyntheticAttribute.read(classFile, dataInputStream);
        }
        if (string.equals("InnerClasses")) {
            return InnerClassesAttribute.read(classFile, dataInputStream);
        }
        if (string.equals("Deprecated")) {
            Attribute.skipAttribute(dataInputStream);
            return null;
        }
        if (string.equals("SourceFile")) {
            Attribute.skipAttribute(dataInputStream);
            return null;
        }
        if (string.equals("LineNumberTable")) {
            Attribute.skipAttribute(dataInputStream);
            return null;
        }
        if (string.equals("LocalVariableTable")) {
            Attribute.skipAttribute(dataInputStream);
            return null;
        }
        if (string.equals("Signature")) {
            Attribute.skipAttribute(dataInputStream);
            return null;
        }
        throw new Error("Unexpected attribute \"" + string + "\"");
    }

    protected static void skipAttribute(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; i += n) {
            n = dataInputStream.skipBytes(n2 - i);
            if (n > 0) continue;
            throw new Error("Skip failed");
        }
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public static void summarize() {
        ValueAttribute.summarize();
        ExceptionsAttribute.summarize();
        SyntheticAttribute.summarize();
        InnerClassesAttribute.summarize();
        CodeAttribute.summarize();
    }
}

