/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.StackFrameImpl;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.VMAction;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements ThreadReference,
VMListener {
    static final int SUSPEND_STATUS_SUSPENDED = 1;
    static final int SUSPEND_STATUS_BREAK = 2;
    private ThreadGroupReference threadGroup;
    private int suspendedZombieCount = 0;
    private List listeners = new ArrayList();

    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.state().addListener(this);
    }

    protected String description() {
        return "ThreadReference " + this.uniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vmNotSuspended(VMAction vMAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
        }
        return super.vmNotSuspended(vMAction);
    }

    public String name() {
        String string = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                string = cache.name;
            }
            if (string == null) {
                string = JDWP.ThreadReference.Name.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).threadName;
                if (cache != null) {
                    cache.name = string;
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketStream sendResumingCommand(CommandSender commandSender) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            return commandSender.send();
        }
    }

    public void suspend() {
        try {
            JDWP.ThreadReference.Suspend.process(this.vm, this);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        PacketStream packetStream;
        if (this.suspendedZombieCount > 0) {
            --this.suspendedZombieCount;
            return;
        }
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            packetStream = JDWP.ThreadReference.Resume.enqueueCommand(this.vm, this);
        }
        try {
            JDWP.ThreadReference.Resume.waitForReply(this.vm, packetStream);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public int suspendCount() {
        if (this.suspendedZombieCount > 0) {
            return this.suspendedZombieCount;
        }
        try {
            return JDWP.ThreadReference.SuspendCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).suspendCount;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public void stop(ObjectReference objectReference) throws InvalidTypeException {
        List list = this.vm.classesByName("java.lang.Throwable");
        ClassTypeImpl classTypeImpl = (ClassTypeImpl)list.get(0);
        if (objectReference == null || !classTypeImpl.isAssignableFrom(objectReference)) {
            throw new InvalidTypeException("Not an instance of Throwable");
        }
        try {
            JDWP.ThreadReference.Stop.process(this.vm, this, (ObjectReferenceImpl)objectReference);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    public void interrupt() {
        try {
            JDWP.ThreadReference.Interrupt.process(this.vm, this);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    private JDWP.ThreadReference.Status jdwpStatus() {
        JDWP.ThreadReference.Status status = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                status = cache.status;
            }
            if (status == null) {
                status = JDWP.ThreadReference.Status.process(this.vm, this);
                if (cache != null) {
                    cache.status = status;
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return status;
    }

    public int status() {
        return this.jdwpStatus().threadStatus;
    }

    public boolean isSuspended() {
        return this.suspendedZombieCount > 0 || (this.jdwpStatus().suspendStatus & 1) != 0;
    }

    public boolean isAtBreakpoint() {
        try {
            StackFrame stackFrame = this.frame(0);
            Location location = stackFrame.location();
            List list = this.vm.eventRequestManager().breakpointRequests();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BreakpointRequest breakpointRequest = (BreakpointRequest)iterator.next();
                if (!((Object)location).equals(breakpointRequest.location())) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
    }

    public ThreadGroupReference threadGroup() {
        if (this.threadGroup == null) {
            try {
                this.threadGroup = JDWP.ThreadReference.ThreadGroup.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).group;
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.threadGroup;
    }

    public int frameCount() throws IncompatibleThreadStateException {
        int n = -1;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                n = cache.frameCount;
            }
            if (n == -1) {
                n = JDWP.ThreadReference.FrameCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).frameCount;
                if (cache != null) {
                    cache.frameCount = n;
                }
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return n;
    }

    public List frames() throws IncompatibleThreadStateException {
        return this.privateFrames(0, -1);
    }

    public StackFrame frame(int n) throws IncompatibleThreadStateException {
        List list = this.privateFrames(n, 1);
        return (StackFrame)list.get(0);
    }

    private boolean isSubrange(Cache cache, int n, int n2, List list) {
        if (n < cache.framesStart) {
            return false;
        }
        if (n2 == -1) {
            return cache.framesLength == -1;
        }
        if (cache.framesLength == -1) {
            if (n + n2 > cache.framesStart + list.size()) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
        return n + n2 <= cache.framesStart + cache.framesLength;
    }

    public List frames(int n, int n2) throws IncompatibleThreadStateException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to zero");
        }
        return this.privateFrames(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List privateFrames(int n, int n2) throws IncompatibleThreadStateException {
        List<StackFrameImpl> list;
        block13: {
            list = null;
            try {
                Cache cache = (Cache)this.getCache();
                if (cache != null) {
                    list = cache.frames;
                }
                if (list == null || !this.isSubrange(cache, n, n2, list)) {
                    JDWP.ThreadReference.Frames.Frame[] frameArray = JDWP.ThreadReference.Frames.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this, (int)n, (int)n2).frames;
                    int n3 = frameArray.length;
                    list = new ArrayList(n3);
                    VMState vMState = this.vm.state();
                    synchronized (vMState) {
                        for (int i = 0; i < n3; ++i) {
                            if (frameArray[i].location == null) {
                                throw new InternalException("Invalid frame location");
                            }
                            StackFrameImpl stackFrameImpl = new StackFrameImpl(this.vm, this, frameArray[i].frameID, frameArray[i].location);
                            list.add(stackFrameImpl);
                        }
                    }
                    if (cache != null) {
                        cache.frames = list;
                        cache.framesStart = n;
                        cache.framesLength = n2;
                    }
                    break block13;
                }
                int n4 = n - cache.framesStart;
                int n5 = n2 == -1 ? list.size() - n4 : n4 + n2;
                list = list.subList(n4, n5);
            }
            catch (JDWPException jDWPException) {
                switch (jDWPException.errorCode()) {
                    case 10: 
                    case 13: {
                        throw new IncompatibleThreadStateException();
                    }
                }
                throw jDWPException.toJDIException();
            }
        }
        return Collections.unmodifiableList(list);
    }

    public List ownedMonitors() throws IncompatibleThreadStateException {
        List<ObjectReferenceImpl> list = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                list = cache.ownedMonitors;
            }
            if (list == null) {
                list = Arrays.asList(JDWP.ThreadReference.OwnedMonitors.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned);
                if (cache != null) {
                    cache.ownedMonitors = list;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching owned monitors" + " (count = " + list.size() + ")");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return list;
    }

    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        ObjectReference objectReference = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null && cache.triedCurrentContended) {
                objectReference = cache.contendedMonitor;
            } else {
                objectReference = JDWP.ThreadReference.CurrentContendedMonitor.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).monitor;
                if (cache != null) {
                    cache.triedCurrentContended = true;
                    cache.contendedMonitor = objectReference;
                    if (objectReference != null) {
                        if ((this.vm.traceFlags & 0x10) != 0) {
                            this.vm.printTrace(this.description() + " temporarily caching contended monitor" + " (id = " + objectReference.uniqueID() + ")");
                        }
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw jDWPException.toJDIException();
        }
        return objectReference;
    }

    public void popFrames(StackFrame stackFrame) throws IncompatibleThreadStateException {
        if (!stackFrame.thread().equals(this)) {
            throw new IllegalArgumentException("frame does not belong to this thread");
        }
        if (!this.vm.canPopFrames()) {
            throw new UnsupportedOperationException("target does not support popping frames");
        }
        ((StackFrameImpl)stackFrame).pop();
    }

    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', " + "id=" + this.uniqueID() + ")";
    }

    byte typeValueKey() {
        return 116;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ThreadListener threadListener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.listeners.add(new WeakReference<ThreadListener>(threadListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(ThreadListener threadListener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (!threadListener.equals(weakReference.get())) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadAction(ThreadAction threadAction) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                ThreadListener threadListener = (ThreadListener)weakReference.get();
                if (threadListener != null) {
                    switch (threadAction.id()) {
                        case 2: {
                            if (threadListener.threadResumable(threadAction)) break;
                            iterator.remove();
                        }
                    }
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        String name = null;
        JDWP.ThreadReference.Status status = null;
        List frames = null;
        int framesStart = -1;
        int framesLength = 0;
        int frameCount = -1;
        List ownedMonitors = null;
        ObjectReference contendedMonitor = null;
        boolean triedCurrentContended = false;

        private Cache() {
        }
    }
}

